/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;

public class YearValueFun
extends SetFun {
    private String functionName = null;
    private String functionKey = null;
    private MdxMemberExpr memberExpr;
    private String yearoffset;
    private String specifiedperiod;
    private SetFun relationfun;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionKey() {
        return this.functionKey;
    }

    public void setFunctionKey(String functionKey) {
        this.functionKey = functionKey;
    }

    public MdxMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    public void setMemberExpr(MdxMemberExpr memberExpr) {
        this.memberExpr = memberExpr;
    }

    public String getYearoffset() {
        return this.yearoffset;
    }

    public void setYearoffset(String yearoffset) {
        this.yearoffset = yearoffset;
    }

    public String getSpecifiedperiod() {
        return this.specifiedperiod;
    }

    public void setSpecifiedperiod(String specifiedperiod) {
        this.specifiedperiod = specifiedperiod;
    }

    public SetFun getRelationfun() {
        return this.relationfun;
    }

    public void setRelationfun(SetFun relationfun) {
        this.relationfun = relationfun;
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public String toMdx(Environment env) {
        RuleFunction ruleFunction = env.getFunctionMap().get(this.functionKey);
        if (ruleFunction == null) {
            return "Value(Tail(ParallelPeriod(BP.BudgetPeriod.FY2022.Level,0 , `BP`.CurrentMember*" + this.memberExpr.toMdx(env) + ").Children,1).Item(0))";
        }
        Map allVal = ruleFunction.getAllValues();
        String accountRangeMembStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.ACCOUNT.getKey(), ',', false, env);
        PeriodEnum enumByKey = PeriodEnum.getEnumByKey((String)this.specifiedperiod);
        StringBuilder stringBuilder = new StringBuilder("Value(Ancestor(ParallelPeriod(BP.BudgetPeriod.FirstChild.Level,");
        stringBuilder.append(-Integer.parseInt(this.yearoffset)).append(", `BP`.CurrentMember), BP.BudgetPeriod.FirstChild.Level)");
        switch (enumByKey) {
            case Y: {
                break;
            }
            case HF1: {
                stringBuilder.append(".FirstChild");
                break;
            }
            case HF2: {
                stringBuilder.append(".LastChild");
                break;
            }
            case Q1: {
                stringBuilder.append(".FirstChild.FirstChild");
                break;
            }
            case Q2: {
                stringBuilder.append(".FirstChild.FirstChild.Lead(1)");
                break;
            }
            case Q3: {
                stringBuilder.append(".FirstChild.FirstChild.Lead(2)");
                break;
            }
            case Q4: {
                stringBuilder.append(".FirstChild.FirstChild.Lead(3)");
                break;
            }
            case M01: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild");
                break;
            }
            case M02: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(1)");
                break;
            }
            case M03: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(2)");
                break;
            }
            case M04: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(3)");
                break;
            }
            case M05: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(4)");
                break;
            }
            case M06: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(5)");
                break;
            }
            case M07: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(6)");
                break;
            }
            case M08: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(7)");
                break;
            }
            case M09: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(8)");
                break;
            }
            case M10: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(9)");
                break;
            }
            case M11: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(10)");
                break;
            }
            case M12: {
                stringBuilder.append(".FirstChild.FirstChild.FirstChild.Lead(11)");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.specifiedperiod);
            }
        }
        stringBuilder.append(",").append(accountRangeMembStr);
        if (this.relationfun != null) {
            String relationFunMdx = this.relationfun.toMdx(env);
            if (this.relationfun instanceof SingleMemberExpr) {
                relationFunMdx = "{" + relationFunMdx + "}";
            }
            String dimNumber = this.relationfun.getDimNumber();
            IModelCacheHelper modelCacheHelper = env.getModelCache();
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            stringBuilder.append(",").append("FirstMember(").append(relationFunMdx).append(",`").append(dimension.getShortNumber()).append("`)");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        IRuleFunction ruleFunction = (IRuleFunction)env.getFunctionMap().get(this.functionKey);
        Map allVal = ruleFunction.getAllValues();
        this.yearValueFuncToPanel(env, panels, allVal);
        return panels;
    }

    private void yearValueFuncToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("@YearValue(", null);
        panels.add(panel);
        this.addAccountPanel(env, panels, allVal);
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        String yearoffset = (String)allVal.get("yearoffset");
        String specifiedperiod = (String)allVal.get("specifiedperiod");
        String showString = "," + yearoffset + "," + PeriodEnum.getEnumByKey((String)specifiedperiod).getName() + ",";
        panel.addShowStringAndValue(showString, null);
        panels.add(panel);
        if (this.relationfun != null) {
            panels.addAll(this.relationfun.toPanel(env));
        }
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(")", null);
        panels.add(panel);
    }

    private void addAccountPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        String keyInfo = (String)allVal.get(FunctionItemEnum.ACCOUNT.getKey());
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)keyInfo, FormulaMemberPojo.class);
        String key = (String)allVal.get("accountmemberkey");
        this.addAccountPanel(env, key, panels, formulaMemberPojo);
    }

    private void addAccountPanel(PanelEnvironment env, String memberKey, List<ExprPanel> panels, FormulaMemberPojo formulaMemberPojo) {
        ExprPanel panel = new ExprPanel(memberKey, ExprPanelType.Member, true);
        List refDimMembers = formulaMemberPojo.getRefDimMembers();
        StringBuilder stringBuilder = new StringBuilder();
        for (DimMemberPojo refDimMember : refDimMembers) {
            stringBuilder.append(refDimMember.getName()).append("|");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        Map<String, ReportShowBizRuleMemberBo> ruleMemberMap = env.getRuleMemberMap();
        ReportShowBizRuleMemberBo ruleMemberBo = ruleMemberMap.get(memberKey);
        String val = ruleMemberBo.getValue() == null ? null : ruleMemberBo.getValue().toString();
        panel.addShowStringAndValue(stringBuilder.toString(), val);
        panels.add(panel);
    }

    @Override
    public String toShrekString(Environment env) {
        return null;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.YearValueFun);
        IRuleFunction ruleFunction = env.getFunctionMap().get(this.functionKey);
        Map allVal = ruleFunction.getAllValues();
        String keyInfo = (String)allVal.get(FunctionItemEnum.ACCOUNT.getKey());
        String relationDimNumber = RuleFunctionUtils.getRelationDimNumber((String)((String)allVal.get(FunctionItemEnum.RELATIONFUN.getKey())));
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)keyInfo, FormulaMemberPojo.class);
        this.checkDateSetDim(env, formulaMemberPojo.getRefDimMembers(), relationDimNumber);
        env.addFunKeyRefMemKey(this.functionKey, formulaMemberPojo.getMemberKey());
        env.setParentToolEnum(null);
    }

    private void checkDateSetDim(CheckEnvironment env, List<DimMemberPojo> refDimMembers, String relationDimNumber) {
        Map<String, String> funMemMap = refDimMembers.stream().collect(Collectors.toMap(x -> x.getDimNumber(), x -> x.getNumber()));
        String account = funMemMap.get(SysDimensionEnum.Account.getNumber());
        if (StringUtils.isEmpty((String)account)) {
            return;
        }
        Member member = env.getModelCache().getMember(SysDimensionEnum.Account.getNumber(), null, account);
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"YearValue\u7684%1\u7ef4\u5ea6\u7684\u6210\u5458%2\u4e0d\u5b58\u5728", (String)"YearValueFun_02", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Account.getNumber(), account}));
        }
        if (member.getDatasetId().equals(env.getDataSetId())) {
            return;
        }
        Set leftList = env.getModelCache().getDimensionList(env.getDataSetId()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
        List rightList = env.getModelCache().getDimensionList(member.getDatasetId());
        Set funDims = rightList.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
        Optional<IRuleFunction> first = env.getFunctionMap().values().stream().findFirst();
        if (!first.isPresent()) {
            return;
        }
        Collection intersectionNumberStringSet = CollectionUtils.intersection(leftList, funDims);
        if (funDims.size() > intersectionNumberStringSet.size()) {
            Collection unsetDimensionNumberStringSet;
            Collection subtractNumberStringSet = CollectionUtils.subtract(funDims, (Iterable)intersectionNumberStringSet);
            if (StringUtils.isNotEmpty((String)relationDimNumber)) {
                subtractNumberStringSet.removeIf(e -> e.equals(relationDimNumber));
            }
            if ((unsetDimensionNumberStringSet = CollectionUtils.subtract((Iterable)subtractNumberStringSet, funMemMap.keySet())).size() > 0) {
                String dimensionString = rightList.stream().filter(x -> unsetDimensionNumberStringSet.contains(x.getNumber())).map(x -> StrUtils.format((String)"{}({})", (Object[])new Object[]{x.getName(), x.getNumber()})).sorted().collect(Collectors.joining(","));
                String formulaPojoString = StrUtils.format((String)"{}({})", (Object[])new Object[]{member.getName(), member.getNumber()});
                throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u4e2d\u53f3\u7b49\u5f0fYearValue\u51fd\u6570\u4e2d\u201c%1\u201d\u6210\u5458\u8303\u56f4\u672a\u8bbe\u7f6e\u201c%2\u201d\uff0c\u8bf7\u8bbe\u7f6e\u3002", (String)"YearValueFun_01", (String)"epm-eb-formplugin", (Object[])new Object[]{formulaPojoString, dimensionString}));
            }
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> childMap = this.memberExpr.analyzeRange(leftRange, evaluator);
        if (this.relationfun != null) {
            Map<String, Set<String>> child2Map = this.relationfun.analyzeRange(leftRange, evaluator);
            if (childMap != null && child2Map != null && !child2Map.isEmpty()) {
                for (Map.Entry<String, Set<String>> entry : child2Map.entrySet()) {
                    Set members = childMap.computeIfAbsent(entry.getKey(), k -> new HashSet(16));
                    members.addAll((Collection)entry.getValue());
                }
            }
        }
        return childMap;
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> accountSet = this.memberExpr.checkRuleEnlarge(evaluator);
        Set<String> relationSet = new HashSet<String>(16);
        if (this.relationfun != null) {
            relationSet = this.relationfun.checkRuleEnlarge(evaluator);
        }
        Set<String> ruleEnlarge = this.getRuleEnlarge(accountSet, relationSet);
        Set<String> dimNumbers = evaluator.getDimNumbers();
        if (CollectionUtils.isNotEmpty(ruleEnlarge)) {
            ruleEnlarge.retainAll(dimNumbers);
        }
        return ruleEnlarge;
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        FormulaPojo formulaPojo = env.getFormulaPojoMap().get(this.getFunctionKey());
        FormulaPojo formulaPojo1 = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
        env.getFormulaPojoMap().put(formulaPojo1.getKeyString(), formulaPojo1);
        return this.memberExpr.getReturnType(env);
    }

    @Override
    public List<IExpress> getChildren() {
        ArrayList<IExpress> childrenList = new ArrayList<IExpress>(16);
        childrenList.add(this.memberExpr);
        if (this.relationfun != null) {
            childrenList.add(this.relationfun);
        }
        return childrenList;
    }
}

