/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ExprParse;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AVGRangeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AVGRangeSFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbsFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AncestorFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AttributeValueExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ChildrenFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.CurrentMemberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.DateDifFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.DateExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.DateFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.FunctionExprProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetAttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetNameFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetNumberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IRRFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IfExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IsAttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ListFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MaxFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MaxRangeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MemberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MinFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MinRangeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MonthFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NPVFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NumberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.OtherFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ParentFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.PeriodShiftFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.RangeMemberSetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.RelativeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SiblingFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SimpleMemberSetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.StringExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SumFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.WordExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.YearFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.YearValueFun;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.AbstractOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.AddOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.AssignmentOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.CommaOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.DivOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.EqualOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.GreaterEqualOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.GreaterThanOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.LeftParentheses;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.LessEqualOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.LessthanOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.LogicAndOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.LogicOrOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.ModOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.MultiplyOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.NotEqualOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.OperationType;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.SubOper;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.ConditionProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.DateProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.FunctionProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.LogicProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.MemberProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.NumberProxy;
import kd.epm.eb.olap.impl.execute.impl.expr.proxy.WordProxy;
import org.apache.commons.collections4.CollectionUtils;

public class Parse2RPN {
    private String formulaStr;
    private int length = 0;
    private int point = 0;
    private char look;
    private Stack operand = new Stack();
    private Stack<AbstractOper> operator = new Stack();
    private boolean isOperation = false;

    public Parse2RPN(String formulaStr) {
        this.formulaStr = formulaStr;
        this.init();
    }

    private void init() {
        if (this.formulaStr == null || (this.formulaStr = this.formulaStr.trim()).length() == 0) {
            ParseUtils.expected(" formulaStr is null!");
            return;
        }
        this.formulaStr = StrUtils.getDbcString((String)this.formulaStr);
        this.point = 0;
        this.length = this.formulaStr.length();
        this.operator.clear();
        this.operand.clear();
        this.getChar();
    }

    public void parse(String formulaStr) {
        this.formulaStr = formulaStr;
        this.init();
        this.parse();
    }

    public void parse() {
        while (this.look != '\u0000') {
            this.readOperand();
            if (!ParseUtils.isOperation(this.look) && this.look != '(' && this.look != ')') continue;
            this.isOperation = ParseUtils.isOperation(this.look);
            this.readOperation(this.look);
        }
        this.push2S1();
    }

    public List<Object> getTokens() {
        return this.operand;
    }

    public IExpress getExpr() {
        ExprParse p2 = new ExprParse(this.getTokens());
        return p2.parse();
    }

    private void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaStr.charAt(this.point++);
    }

    private void push2S1() {
        while (!this.operator.isEmpty()) {
            this.operand.push(this.operator.pop());
        }
    }

    private void push2S2(AbstractOper oper) {
        this.operator.push(oper);
    }

    private void pushCheck2S2(AbstractOper oper) {
        if (oper == null) {
            return;
        }
        AbstractOper _oper = null;
        while (!this.operator.isEmpty()) {
            _oper = this.operator.pop();
            if (_oper.getSID() == 1 || _oper.getSID() == 2 || OperationType.comparePRI(oper.getSID(), _oper.getSID()) > 0) {
                this.operator.push(_oper);
                break;
            }
            this.operand.push(_oper);
        }
        this.operator.push(oper);
    }

    private void pushS22S1ByRightP() {
        AbstractOper _oper = null;
        while (!this.operator.isEmpty() && 1 != (_oper = this.operator.pop()).getSID()) {
            this.operand.push(_oper);
        }
    }

    private void readOperation(char c) {
        if ('+' == c) {
            this.add();
        } else if ('-' == c) {
            this.sub();
        } else if ('*' == c) {
            this.multiply();
        } else if ('/' == c) {
            this.div();
        } else if ('%' == c) {
            this.mod();
        } else if ('=' == c) {
            this.assignment();
        } else if ('>' == c) {
            this.greaterThan();
        } else if ('<' == c) {
            this.lessThan();
        } else if ('(' == c) {
            this.leftParentheses();
        } else if (')' == c) {
            this.rightParentheses();
        } else if ('&' == c) {
            this.and();
        } else if ('|' == c) {
            this.or();
        } else if (',' == c) {
            this.comma();
        }
    }

    private void add() {
        this.match('+');
        this.pushCheck2S2(new AddOper());
    }

    private void sub() {
        this.match('-');
        this.pushCheck2S2(new SubOper());
    }

    private void multiply() {
        this.match('*');
        this.pushCheck2S2(new MultiplyOper());
    }

    private void div() {
        this.match('/');
        this.pushCheck2S2(new DivOper());
    }

    private void mod() {
        this.match('%');
        this.pushCheck2S2(new ModOper());
    }

    private void assignment() {
        this.match('=');
        if (this.look == '=') {
            this.equal();
        } else {
            this.pushCheck2S2(new AssignmentOper());
        }
    }

    private void equal() {
        this.match('=');
        this.pushCheck2S2(new EqualOper());
    }

    private void greaterThan() {
        this.match('>');
        if (this.look == '=') {
            this.greaterEqual();
        } else {
            this.pushCheck2S2(new GreaterThanOper());
        }
    }

    private void greaterEqual() {
        this.match('=');
        this.pushCheck2S2(new GreaterEqualOper());
    }

    private void lessThan() {
        this.match('<');
        if (this.look == '=') {
            this.lessEqual();
        } else if (this.look == '>') {
            this.notEqual();
        } else {
            this.pushCheck2S2(new LessthanOper());
        }
    }

    private void lessEqual() {
        this.match('=');
        this.pushCheck2S2(new LessEqualOper());
    }

    private void notEqual() {
        this.match('>');
        this.pushCheck2S2(new NotEqualOper());
    }

    private void leftParentheses() {
        this.match('(');
        this.push2S2(new LeftParentheses());
    }

    private void comma() {
        this.match(',');
        this.push2S2(new CommaOper());
    }

    private void rightParentheses() {
        this.match(')');
        this.pushS22S1ByRightP();
    }

    private void and() {
        this.match('&');
        if (this.look != '&') {
            throw new ParseException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301&\u64cd\u4f5c\u7b26\uff0c\u8bf7\u4f7f\u7528\u903b\u8f91\u4e0e&&", (String)"Parse2RPN_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.logicAnd();
    }

    private void logicAnd() {
        this.match('&');
        this.pushCheck2S2(new LogicAndOper());
    }

    private void or() {
        this.match('|');
        if (this.look != '|') {
            throw new ParseException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301|\u64cd\u4f5c\u7b26\uff0c\u8bf7\u4f7f\u7528\u903b\u8f91\u6216||", (String)"Parse2RPN_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.logicOr();
    }

    private void logicOr() {
        this.match('|');
        this.pushCheck2S2(new LogicOrOper());
    }

    private void match(char x) {
        if (this.look != x) {
            ParseUtils.expected("" + x + "");
        } else {
            this.getChar();
            this.skipWhite();
        }
    }

    private void skipWhite() {
        while (ParseUtils.isWhite(this.look)) {
            this.getChar();
        }
    }

    private String getOperandStr() {
        int brace = 0;
        int bracket = 0;
        int parenthes = 0;
        int strCount = 0;
        int memberStrCount = 0;
        StringBuilder str = new StringBuilder();
        while (this.look == '(') {
            if (this.look != '(') continue;
            this.leftParentheses();
        }
        boolean check = brace > 0 || bracket > 0 || parenthes > 0 ? true : !ParseUtils.isOperation(this.look);
        boolean isSub = false;
        int backpoint = -1;
        if (this.look == '-' && (this.isOperation || this.point == 1)) {
            check = true;
            backpoint = this.point;
            isSub = true;
        }
        while (check && this.look != '\u0000') {
            if (this.look == '(') {
                ++parenthes;
            }
            if (this.look == ')') {
                --parenthes;
            }
            if (this.look == '[') {
                ++bracket;
            }
            if (this.look == ']') {
                --bracket;
            }
            if (this.look == '{') {
                ++brace;
            }
            if (this.look == '}') {
                --brace;
            }
            if (this.look == '\"' || this.look == '\'') {
                ++strCount;
            }
            if (strCount >= 2) {
                strCount = 0;
            }
            if (this.look == '`' && !this.checkBeforeIsFormult(str)) {
                ++memberStrCount;
            }
            if (memberStrCount >= 2) {
                memberStrCount = 0;
            }
            if (brace < 0 || bracket < 0 || parenthes < 0) break;
            str.append(this.look);
            this.getChar();
            check = brace > 0 || bracket > 0 || parenthes > 0 || strCount > 0 || memberStrCount > 0 ? true : !ParseUtils.isOperation(this.look);
        }
        this.skipWhite();
        if (isSub) {
            if (NumberProxy.check(str.toString().trim())) {
                return str.toString().trim();
            }
            this.point = backpoint;
            return "";
        }
        return str.toString().trim();
    }

    private boolean checkBeforeIsFormult(StringBuilder str) {
        if (str.length() < 7) {
            return false;
        }
        String substring = str.substring(str.length() - 7, str.length());
        return substring.equals("formult");
    }

    private void readOperand() {
        this.skipWhite();
        String str = this.getOperandStr();
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.isCondition(str)) {
            this.readCondition(str);
        } else if (this.isLogic(str)) {
            this.readLogic(str);
        } else if (this.isMember(str)) {
            this.readMember(str);
        } else if (this.isNumber(str)) {
            this.readNumber(str);
        } else if (this.isSumRangeFun(str)) {
            this.operand.add(this.parseSumRangeFun(str));
        } else if (this.isAbsFun(str)) {
            this.operand.add(this.parseAbsFun(str));
        } else if (this.isAVGRangeFun(str)) {
            this.operand.add(this.parseAVGRangeFun(str));
        } else if (this.isAVGRangeSFun(str)) {
            this.operand.add(this.parseAVGRangeSFun(str));
        } else if (this.isMaxFun(str)) {
            this.operand.add(this.parseMaxFun(str));
        } else if (this.isMaxRangeFun(str)) {
            this.operand.add(this.parseMaxRangeFun(str));
        } else if (this.isMinFun(str)) {
            this.operand.add(this.parseMinFun(str));
        } else if (this.isMinRangeFun(str)) {
            this.operand.add(this.parseMinRangeFun(str));
        } else if (this.isIRRFun(str)) {
            this.operand.add(this.parseIRRFun(str));
        } else if (this.isNPVFun(str)) {
            this.operand.add(this.parseNPVFun(str));
        } else if (this.isAttributeFun(str)) {
            this.operand.add(this.parseAttributeFun(str));
        } else if (this.isGetAttributeFun(str)) {
            this.operand.add(this.parseGetAttributeFun(str));
        } else if (this.isSiblingFun(str)) {
            this.operand.add(this.parseSiblingFun(str));
        } else if (this.isListFun(str)) {
            this.operand.add(this.parseListFun(str));
        } else if (this.isChildrenFun(str)) {
            this.operand.add(this.parseChildrenFun(str));
        } else if (this.isIsAttributeFun(str)) {
            this.operand.add(this.parseIsAttributeFun(str));
        } else if (this.isRelativeFun(str)) {
            this.operand.add(this.parseRelativeFun(str));
        } else if (this.isAncestorFun(str)) {
            this.operand.add(this.parseAncestorFun(str));
        } else if (this.isParentFun(str)) {
            this.operand.add(this.parseParentFun(str));
        } else if (this.isCurrMBR(str)) {
            this.operand.add(this.parseCurrMBRFun(str));
        } else if (this.isIRR(str)) {
            this.operand.add(this.parseCurrMBRFun(str));
        } else if (this.isNPV(str)) {
            this.operand.add(this.parseCurrMBRFun(str));
        } else if (this.isPeriodShiftFun(str)) {
            this.operand.add(this.parsePeriodShiftFun(str));
        } else if (this.isGetNumberFun(str)) {
            this.operand.add(this.parseGetNumberFun(str));
        } else if (this.isGetNameFun(str)) {
            this.operand.add(this.parseGetNameFun(str));
        } else if (this.isMemberFun(str)) {
            this.operand.add(this.parseMemberFun(str));
        } else if (this.isRoundFunction(str)) {
            this.readOtherFunExpr(str);
        } else if (this.isFunction(str)) {
            this.readOtherFunExpr(str);
        } else if (str.length() > 1 && (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\""))) {
            this.readString(str);
        } else if (str.length() > 1 && str.startsWith("`") && str.endsWith("`")) {
            this.readSingleMember(str);
        } else if (this.isWord(str)) {
            this.readWord(str);
        } else if (this.isMonthFun(str)) {
            this.operand.add(this.parseMonthFun(str));
        } else if (this.isYearFun(str)) {
            this.operand.add(this.parseYearFun(str));
        } else if (this.isDateDifFun(str)) {
            this.operand.add(this.parseDateDifFun(str));
        } else if (this.isDateFunction(str)) {
            this.operand.add(this.parseDateFun(str));
        } else if (this.isYearValueFun(str)) {
            this.operand.add(this.parseYearValueFun(str));
        } else {
            ParseUtils.expected(" error str!" + str);
        }
        this.isOperation = false;
    }

    private MemberFun parseMemberFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        MemberFun memberFun = new MemberFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        memberFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        memberFun.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (expr instanceof SetFun) {
            memberFun.setStringFun((SetFun)expr);
        } else if (expr instanceof MdxMemberExpr) {
            memberFun.setDimGroup((MdxMemberExpr)expr);
        } else if (expr instanceof StringExpr) {
            memberFun.setFixString((StringExpr)expr);
        }
        return memberFun;
    }

    private boolean isPeriodShiftFun(String str) {
        return str != null && str.startsWith("@PeriodShift(");
    }

    private void readSingleMember(String str) {
        this.operand.add(new SingleMemberExpr(str.substring(1, str.length() - 1)));
    }

    private void readString(String str) {
        this.operand.add(new StringExpr(str.substring(1, str.length() - 1)));
    }

    private void readWord(String str) {
        this.operand.add(new WordExpr(str));
    }

    private void readOtherFunExpr(String str) {
        OtherFun expr = FunctionProxy.parse(str);
        if (expr == null) {
            ParseUtils.expected(" error member!" + str);
        }
        this.operand.add(expr);
    }

    private void readDateFunExpr(String str) {
        DateExpr expr = DateProxy.parse(str);
        if (expr == null) {
            ParseUtils.expected(" error member!" + str);
        }
        this.operand.add(expr);
    }

    private boolean isNumber(String memberStr) {
        return NumberProxy.check(memberStr);
    }

    private void readNumber(String str) {
        this.operand.add(new NumberExpr(str));
    }

    private boolean isMember(String memberStr) {
        return MemberProxy.isMember(memberStr);
    }

    private void readMember(String str) {
        MdxMemberExpr expr = MemberProxy.parse(str);
        if (expr == null) {
            ParseUtils.expected(" error member!" + str);
        }
        this.operand.add(expr);
    }

    private boolean isLogic(String formulaStr) {
        return LogicProxy.isLogic(formulaStr);
    }

    private void readLogic(String str) {
        BinaryExpr expr = LogicProxy.parse(str);
        if (expr == null) {
            ParseUtils.expected(" error logic!" + str);
        }
        this.operand.add(expr);
    }

    private boolean isCondition(String conditionStr) {
        return ConditionProxy.check(conditionStr);
    }

    private void readCondition(String str) {
        IfExpr expr = ConditionProxy.parse(str);
        if (expr == null) {
            ParseUtils.expected(" error condition!" + str);
        }
        this.operand.add(expr);
    }

    private CurrentMemberFun parseCurrMBRFun(String parseStr) {
        CurrentMemberFun currentMemberFun = new CurrentMemberFun();
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        currentMemberFun.setFunKey(funKey);
        String dimNumber = parseStr.substring(firstIndex + 1, lastIndex);
        currentMemberFun.setDimNumber(dimNumber);
        return currentMemberFun;
    }

    private SumFun parseSumRangeFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.SumRange.name()}));
        }
        SumFun sumFun = new SumFun();
        if (!(expressList.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadSumParam1Error());
        }
        sumFun.setMemberExpr((MdxMemberExpr)expressList.get(0));
        if (!(expressList.get(1) instanceof SetFun)) {
            throw new KDBizException(ParseExceptionCatcher.loadSumParam2Error());
        }
        sumFun.setSetExpr((SetFun)expressList.get(1));
        return sumFun;
    }

    private MaxFun parseMaxFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.Max.name()}));
        }
        MaxFun maxFun = new MaxFun();
        ArrayList args = Lists.newArrayList();
        IExpress arg0 = expressList.get(0);
        if (arg0.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadMaxParam2Error());
        }
        args.add(arg0);
        IExpress arg1 = expressList.get(1);
        if (arg1.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadMaxParam2Error());
        }
        args.add(arg1);
        maxFun.setArgs(args);
        return maxFun;
    }

    private MaxRangeFun parseMaxRangeFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.MaxRange.name()}));
        }
        MaxRangeFun maxRangeFun = new MaxRangeFun();
        LambdaUtils.run(() -> {
            IExpress express = (IExpress)expressList.get(0);
            if (!(express instanceof MdxMemberExpr)) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"ParseExceptionCatcher_37", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.MaxRange.name()}));
            }
            maxRangeFun.setArg0(express);
        });
        LambdaUtils.run(() -> {
            IExpress express = (IExpress)expressList.get(1);
            if (express.getReturnType() != FunReturnType.MemberSet && express.getReturnType() != FunReturnType.Member) {
                throw new KDBizException(ParseExceptionCatcher.loadMaxRangeParam2Error());
            }
            maxRangeFun.setArg1(express);
        });
        return maxRangeFun;
    }

    private MinFun parseMinFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.Min.name()}));
        }
        MinFun minFun = new MinFun();
        ArrayList args = Lists.newArrayList();
        IExpress arg0 = expressList.get(0);
        if (arg0.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadMinParam2Error());
        }
        args.add(arg0);
        IExpress arg1 = expressList.get(1);
        if (arg1.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadMinParam2Error());
        }
        args.add(arg1);
        minFun.setArgs(args);
        return minFun;
    }

    private MinRangeFun parseMinRangeFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.MinRange.name()}));
        }
        MinRangeFun minRangeFun = new MinRangeFun();
        LambdaUtils.run(() -> {
            IExpress express = (IExpress)expressList.get(0);
            if (!(express instanceof MdxMemberExpr)) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"ParseExceptionCatcher_37", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.MinRange.name()}));
            }
            minRangeFun.setArg0(express);
        });
        LambdaUtils.run(() -> {
            IExpress express = (IExpress)expressList.get(1);
            if (express.getReturnType() != FunReturnType.MemberSet && express.getReturnType() != FunReturnType.Member) {
                throw new KDBizException(ParseExceptionCatcher.loadMinRangeParam2Error());
            }
            minRangeFun.setArg1(express);
        });
        return minRangeFun;
    }

    private AbsFun parseAbsFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_41", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.ABS.name()}));
        }
        AbsFun absFun = new AbsFun();
        IExpress express = expressList.get(0);
        if (express.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadAbsError());
        }
        absFun.setExpress(express);
        return absFun;
    }

    private MonthFun parseMonthFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_41", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.Month.name()}));
        }
        MonthFun monthFun = new MonthFun();
        IExpress express = expressList.get(0);
        monthFun.setExpress(express);
        return monthFun;
    }

    private Object parseYearFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_41", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.Year.name()}));
        }
        YearFun yearFun = new YearFun();
        IExpress express = expressList.get(0);
        yearFun.setExpress(express);
        return yearFun;
    }

    private Object parseDateDifFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 3) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u6709\u4e14\u4ec5\u67093\u4e2a\u53c2\u6570", (String)"ParseExceptionCatcher_53", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.ABS.name()}));
        }
        DateDifFun fun = new DateDifFun(expressList.get(0), expressList.get(1), expressList.get(2));
        return fun;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseDateFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        DateFun dateFun = new DateFun();
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        dateFun.setFunKey(funKey);
        String setFunStr = parseStr.substring(firstIndex + 1, lastIndex);
        if (!setFunStr.startsWith("SimpleMemberSetFun")) {
            Parse2RPN parse = new Parse2RPN(setFunStr);
            parse.parse();
            IExpress expr = parse.getExpr();
            if (expr instanceof SetFun) {
                dateFun.setDimNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                dateFun.setSetFun((SetFun)expr);
                return dateFun;
            } else {
                if (!(expr instanceof StringExpr)) throw new KDBizException(ParseExceptionCatcher.loadDateParamError());
                dateFun.setExpr((StringExpr)expr);
            }
            return dateFun;
        } else {
            SimpleMemberSetFun setFun = new SimpleMemberSetFun(funKey);
            setFun.setDimNumber(SysDimensionEnum.BudgetPeriod.getNumber());
            dateFun.setSetFun(setFun);
        }
        return dateFun;
    }

    private YearValueFun parseYearValueFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() < 3) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e3\u4e2a", (String)"ParseExceptionCatcher_61", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.YearValue.name()}));
        }
        YearValueFun yearValueFun = new YearValueFun();
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        if (!(expressList.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadSumParam1Error());
        }
        yearValueFun.setMemberExpr((MdxMemberExpr)expressList.get(0));
        yearValueFun.setFunctionKey(funKey);
        yearValueFun.setYearoffset(((StringExpr)expressList.get(1)).getName());
        yearValueFun.setSpecifiedperiod(((StringExpr)expressList.get(2)).getName());
        if (expressList.size() > 3) {
            IExpress iExpress = expressList.get(3);
            if (iExpress instanceof StringExpr) {
                StringExpr relationStr = (StringExpr)iExpress;
                if (StringUtils.isNotEmpty((String)relationStr.toString())) {
                    Parse2RPN parse = new Parse2RPN(relationStr.toString());
                    parse.parse();
                    IExpress expr = parse.getExpr();
                    yearValueFun.setRelationfun((SetFun)expr);
                }
            } else if (iExpress instanceof SetFun) {
                yearValueFun.setRelationfun((SetFun)iExpress);
            }
        }
        return yearValueFun;
    }

    private AVGRangeFun parseAVGRangeFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.AVGRange.name()}));
        }
        if (expressList.get(0).getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadAVGRange1Error());
        }
        if (!(expressList.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"ParseExceptionCatcher_37", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.AVGRange.name()}));
        }
        if (expressList.get(1).getReturnType() != FunReturnType.MemberSet) {
            throw new KDBizException(ParseExceptionCatcher.loadAVGRange2Error());
        }
        AVGRangeFun avgRangeFun = new AVGRangeFun();
        avgRangeFun.setArgs(expressList);
        return avgRangeFun;
    }

    private PeriodShiftFun parsePeriodShiftFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.PeriodShift.name()}));
        }
        if (!(expressList.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"ParseExceptionCatcher_37", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.PeriodShift.name()}));
        }
        if (expressList.get(1).getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadPeriodShift2Error());
        }
        PeriodShiftFun periodShiftFun = new PeriodShiftFun();
        periodShiftFun.setArgs(expressList);
        return periodShiftFun;
    }

    private AVGRangeSFun parseAVGRangeSFun(String parseStr) {
        List<IExpress> expressList = FunctionExprProxy.parse(parseStr);
        if (CollectionUtils.isEmpty(expressList) || expressList.size() != 2) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u51fd\u6570\u6709\u4e14\u4ec5\u6709\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ParseExceptionCatcher_40", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.AVGRangeS.name()}));
        }
        if (expressList.get(0).getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadAVGRangeS1Error());
        }
        if (!(expressList.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"ParseExceptionCatcher_37", (String)"epm-eb-olap", (Object[])new Object[]{ToolEnum.AVGRangeS.name()}));
        }
        if (expressList.get(1).getReturnType() != FunReturnType.MemberSet) {
            throw new KDBizException(ParseExceptionCatcher.loadAVGRangeS2Error());
        }
        AVGRangeSFun avgRangeSFun = new AVGRangeSFun();
        avgRangeSFun.setArgs(expressList);
        return avgRangeSFun;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AttributeFun parseAttributeFun(String parseStr) {
        AttributeFun attributeExpr = new AttributeFun();
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        attributeExpr.setFunKey(funKey);
        List<String> params = FunctionExprProxy.parse2Strings(parseStr);
        if (params.size() != 4) throw new KDBizException(ParseExceptionCatcher.loadAttributeParamSizeError());
        String dimNumber = params.get(0);
        attributeExpr.setDimNumber(dimNumber);
        String setFunStr = params.get(1);
        if (!setFunStr.startsWith("RangeMemberSetFun")) {
            Parse2RPN parse = new Parse2RPN(setFunStr);
            parse.parse();
            IExpress expr = parse.getExpr();
            if (!(expr instanceof SetFun)) throw new KDBizException(ParseExceptionCatcher.loadAttributeParam2Error());
            attributeExpr.setSetExpr((SetFun)expr);
        } else {
            RangeMemberSetFun setFun = new RangeMemberSetFun(funKey);
            setFun.setDimNumber(dimNumber);
            attributeExpr.setSetExpr(setFun);
        }
        String attribute = params.get(2);
        attributeExpr.setAttribute(attribute);
        String attributeValue = params.get(3);
        if (attributeValue.startsWith("@")) {
            Parse2RPN parse = new Parse2RPN(attributeValue);
            parse.parse();
            IExpress expr = parse.getExpr();
            attributeExpr.setAttributeValue((SetFun)expr);
            return attributeExpr;
        } else {
            AttributeValueExpr setFun = new AttributeValueExpr(attribute, attributeValue);
            attributeExpr.setAttributeValue(setFun);
        }
        return attributeExpr;
    }

    private GetAttributeFun parseGetAttributeFun(String parseStr) {
        GetAttributeFun getAttributeExpr = new GetAttributeFun();
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        int lastParamIndex = parseStr.lastIndexOf(44);
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        getAttributeExpr.setDimNumber(dimNumber);
        String member = parseStr.substring(firstParamIndex + 1, lastParamIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.GetAttribute.getName()));
        }
        getAttributeExpr.setMemberExpr((SingleMemberExpr)expr);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        getAttributeExpr.setFunKey(funKey);
        String attribute = parseStr.substring(lastParamIndex + 1, lastIndex);
        getAttributeExpr.setAttribute(attribute);
        return getAttributeExpr;
    }

    private IsAttributeFun parseIsAttributeFun(String parseStr) {
        IsAttributeFun isAttributeExpr = new IsAttributeFun();
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        int lastParamIndex = parseStr.lastIndexOf(44);
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        isAttributeExpr.setDimNumber(dimNumber);
        String attribute = parseStr.substring(firstParamIndex + 1, lastParamIndex);
        isAttributeExpr.setAttribute(attribute);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        isAttributeExpr.setFunKey(funKey);
        String attributeVal = parseStr.substring(lastParamIndex + 1, lastIndex);
        isAttributeExpr.setAttributeValue(attributeVal);
        return isAttributeExpr;
    }

    private AncestorFun parseAncestorFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        int lastParamIndex = parseStr.lastIndexOf(44);
        AncestorFun ancestorFun = new AncestorFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        ancestorFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        ancestorFun.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastParamIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.Ancestor.getName()));
        }
        ancestorFun.setMemberExpr((SingleMemberExpr)expr);
        String level = parseStr.substring(lastParamIndex + 1, lastIndex);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)level)) {
            throw new KDBizException(ParseExceptionCatcher.loadAncestorParam3Error());
        }
        ancestorFun.setLevel(Integer.parseInt(level));
        return ancestorFun;
    }

    private ParentFun parseParentFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        ParentFun parentExpr = new ParentFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        parentExpr.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        parentExpr.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.Parent.getName()));
        }
        parentExpr.setMemberExpr((SingleMemberExpr)expr);
        return parentExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildrenFun parseChildrenFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        ChildrenFun childrenFun = new ChildrenFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        childrenFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        childrenFun.setFunKey(funKey);
        String setFunStr = parseStr.substring(firstParamIndex + 1, lastIndex);
        if (!setFunStr.startsWith("SimpleMemberSetFun")) {
            Parse2RPN parse = new Parse2RPN(setFunStr);
            parse.parse();
            IExpress expr = parse.getExpr();
            if (!(expr instanceof SetFun)) throw new KDBizException(ParseExceptionCatcher.loadChildrenParam2Error());
            childrenFun.setSetExpr((SetFun)expr);
            return childrenFun;
        } else {
            SimpleMemberSetFun setFun = new SimpleMemberSetFun(funKey);
            setFun.setDimNumber(dimNumber);
            childrenFun.setSetExpr(setFun);
        }
        return childrenFun;
    }

    private GetNumberFun parseGetNumberFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        GetNumberFun getNumberFun = new GetNumberFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        getNumberFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        getNumberFun.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.GetNumber.getName()));
        }
        getNumberFun.setMemberExpr((SingleMemberExpr)expr);
        return getNumberFun;
    }

    private GetNameFun parseGetNameFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        GetNameFun getNameFun = new GetNameFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        getNameFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        getNameFun.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.GetName.getName()));
        }
        getNameFun.setMemberExpr((SingleMemberExpr)expr);
        return getNameFun;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RelativeFun parseRelativeFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        RelativeFun relativeFun = new RelativeFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        relativeFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        relativeFun.setFunKey(funKey);
        String setFunStr = parseStr.substring(firstParamIndex + 1, lastIndex);
        if (!setFunStr.startsWith("SimpleMemberSetFun")) {
            Parse2RPN parse = new Parse2RPN(setFunStr);
            parse.parse();
            IExpress expr = parse.getExpr();
            if (!(expr instanceof SetFun)) throw new KDBizException(ParseExceptionCatcher.loadRelativeParam2Error());
            relativeFun.setSetExpr((SetFun)expr);
            return relativeFun;
        } else {
            SimpleMemberSetFun setFun = new SimpleMemberSetFun(funKey);
            setFun.setDimNumber(dimNumber);
            relativeFun.setSetExpr(setFun);
        }
        return relativeFun;
    }

    private SiblingFun parseSiblingFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        SiblingFun siblingExpr = new SiblingFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        siblingExpr.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        siblingExpr.setFunKey(funKey);
        String member = parseStr.substring(firstParamIndex + 1, lastIndex);
        Parse2RPN parse = new Parse2RPN(member);
        parse.parse();
        IExpress expr = parse.getExpr();
        if (!(expr instanceof SingleMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.Sibling.getName()));
        }
        siblingExpr.setMemberExpr((SingleMemberExpr)expr);
        return siblingExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ListFun parseListFun(String parseStr) {
        int firstIndex = parseStr.indexOf(40);
        int lastIndex = parseStr.lastIndexOf(41);
        int firstParamIndex = parseStr.indexOf(44);
        ListFun listFun = new ListFun();
        String dimNumber = parseStr.substring(firstIndex + 1, firstParamIndex);
        listFun.setDimNumber(dimNumber);
        String funKey = parseStr.substring(parseStr.indexOf(91) + 1, parseStr.indexOf(93));
        listFun.setFunKey(funKey);
        String setFunStr = parseStr.substring(firstParamIndex + 1, lastIndex);
        if (!setFunStr.startsWith("RangeMemberSetFun")) {
            Parse2RPN parse = new Parse2RPN(setFunStr);
            parse.parse();
            IExpress expr = parse.getExpr();
            if (!(expr instanceof SetFun)) throw new KDBizException(ParseExceptionCatcher.loadParam2MemberError(RuleFunctionEnum.List.getName()));
            listFun.setSetFun((SetFun)expr);
            return listFun;
        } else {
            RangeMemberSetFun setFun = new RangeMemberSetFun(funKey);
            setFun.setDimNumber(dimNumber);
            listFun.setSetFun(setFun);
        }
        return listFun;
    }

    private IRRFun parseIRRFun(String parseStr) {
        List<IExpress> params = this.parseParams(parseStr, Sets.newHashSet((Object[])new Integer[]{2, 3}));
        IRRFun irrFun = new IRRFun();
        IExpress arg0 = params.get(0);
        if (!(arg0 instanceof MdxMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadIRR1Error());
        }
        irrFun.setArg0((MdxMemberExpr)arg0);
        IExpress arg1 = params.get(1);
        if (arg1.getReturnType() != FunReturnType.MemberSet) {
            throw new KDBizException(ParseExceptionCatcher.loadIRR2Error());
        }
        irrFun.setArg1(arg1);
        if (params.size() == 3) {
            IExpress arg2 = params.get(2);
            if (arg2.getReturnType() != FunReturnType.Numeric) {
                throw new KDBizException(ParseExceptionCatcher.loadIRR3Error());
            }
            irrFun.setArg2(arg2);
        }
        return irrFun;
    }

    private NPVFun parseNPVFun(String parseStr) {
        List<IExpress> params = this.parseParams(parseStr, Sets.newHashSet((Object[])new Integer[]{3}));
        NPVFun npvFun = new NPVFun();
        if (!(params.get(0) instanceof MdxMemberExpr)) {
            throw new KDBizException(ParseExceptionCatcher.loadNPV1Error());
        }
        npvFun.setArg0((MdxMemberExpr)params.get(0));
        IExpress param1 = params.get(1);
        if (param1.getReturnType() != FunReturnType.MemberSet) {
            throw new KDBizException(ParseExceptionCatcher.loadNPV2Error());
        }
        npvFun.setArg1(param1);
        IExpress param2 = params.get(2);
        if (param2.getReturnType() != FunReturnType.Numeric) {
            throw new KDBizException(ParseExceptionCatcher.loadNPV3Error());
        }
        npvFun.setArg2(param2);
        return npvFun;
    }

    private List<IExpress> parseParams(String parseStr, Set<Integer> paramLength) {
        int firstIndex = parseStr.indexOf(40) + 1;
        int lastIndex = parseStr.lastIndexOf(41);
        if (lastIndex != parseStr.length() - 1) {
            throw new ParseException(ResManager.loadResFormat((String)"(%1)\u51fd\u6570\u53c2\u6570\u9519\u8bef\u3002", (String)"", (String)"", (Object[])new Object[]{parseStr.substring(1, firstIndex - 1)}));
        }
        String paramStr = org.apache.commons.lang3.StringUtils.substring((String)parseStr, (int)firstIndex, (int)lastIndex);
        Parse2RPN parse2RPN = new Parse2RPN(paramStr);
        parse2RPN.parse();
        IExpress expr = parse2RPN.getExpr();
        ArrayList<IExpress> params = new ArrayList<IExpress>();
        this.dfs(expr, params);
        if (!paramLength.contains(params.size())) {
            throw new ParseException(ResManager.loadResFormat((String)"(%1)\u51fd\u6570\u53c2\u6570\u9519\u8bef\u3002", (String)"", (String)"", (Object[])new Object[]{parseStr.substring(1, firstIndex - 1)}));
        }
        return params;
    }

    private void dfs(IExpress expr, List<IExpress> params) {
        if (expr instanceof BinaryExpr && ((BinaryExpr)expr).getOperType() instanceof CommaOper) {
            this.dfs(((BinaryExpr)expr).getLeft(), params);
            this.dfs(((BinaryExpr)expr).getRight(), params);
        } else {
            params.add(expr);
        }
    }

    private boolean isRoundFunction(String str) {
        return str != null && str.startsWith("@Round(");
    }

    private boolean isDateFunction(String str) {
        return str != null && str.startsWith("@Date");
    }

    private boolean isYearValueFun(String str) {
        return str != null && str.startsWith("@YearValue");
    }

    private boolean isSumRangeFun(String str) {
        return str != null && str.startsWith("@SumRange(");
    }

    private boolean isMaxFun(String str) {
        return str != null && str.startsWith("@Max(");
    }

    private boolean isMaxRangeFun(String str) {
        return str != null && str.startsWith("@MaxRange(");
    }

    private boolean isMinFun(String str) {
        return str != null && str.startsWith("@Min(");
    }

    private boolean isMinRangeFun(String str) {
        return str != null && str.startsWith("@MinRange(");
    }

    private boolean isIRRFun(String str) {
        return str != null && str.startsWith("@IRR(");
    }

    private boolean isNPVFun(String str) {
        return str != null && str.startsWith("@NPV(");
    }

    private boolean isAbsFun(String str) {
        return str != null && str.startsWith("@ABS(");
    }

    private boolean isMonthFun(String str) {
        return str != null && str.startsWith("@Month(");
    }

    private boolean isYearFun(String str) {
        return str != null && str.startsWith("@Year(");
    }

    private boolean isDateDifFun(String str) {
        return str != null && str.startsWith("@DateDif(");
    }

    private boolean isAVGRangeFun(String str) {
        return str != null && str.startsWith("@AVGRange(");
    }

    private boolean isAVGRangeSFun(String str) {
        return str != null && str.startsWith("@AVGRangeS(");
    }

    private boolean isSiblingFun(String str) {
        return str != null && str.startsWith("@Sibling");
    }

    private boolean isListFun(String str) {
        return str != null && str.startsWith("@List");
    }

    private boolean isChildrenFun(String str) {
        return str != null && str.startsWith("@Children");
    }

    private boolean isIsAttributeFun(String str) {
        return str != null && str.startsWith("@IsAttribute");
    }

    private boolean isRelativeFun(String str) {
        return str != null && str.startsWith("@Relative");
    }

    private boolean isAncestorFun(String str) {
        return str != null && str.startsWith("@Ancestor");
    }

    private boolean isParentFun(String str) {
        return str != null && str.startsWith("@Parent");
    }

    private boolean isAttributeFun(String str) {
        return str != null && str.startsWith("@Attribute");
    }

    private boolean isGetAttributeFun(String str) {
        return str != null && str.startsWith("@GetAttribute");
    }

    private boolean isCurrMBR(String str) {
        return str != null && str.startsWith("@CurrMBR");
    }

    private boolean isIRR(String str) {
        return str != null && str.startsWith("@IRR(");
    }

    private boolean isNPV(String str) {
        return str != null && str.startsWith("@NPV(");
    }

    private boolean isFunction(String str) {
        return FunctionProxy.check(str);
    }

    private boolean isWord(String str) {
        return WordProxy.check(str);
    }

    private boolean isGetNumberFun(String str) {
        return str != null && str.startsWith("@GetNumber");
    }

    private boolean isGetNameFun(String str) {
        return str != null && str.startsWith("@GetName");
    }

    private boolean isMemberFun(String str) {
        return str != null && str.startsWith("@Member");
    }
}

