/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.proxy;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NumberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.OtherFun;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;

public class FunctionProxy {
    public static final String FUNCTION_EXPR_TAG1 = "^MBR:\\[F`[a-zA-Z]*`[0-9]*\\]\\(.*?\\)$";
    public static final String FUNCTION_EXPR_TAG2 = "^MBR:\\[F`[a-zA-Z]*`[0-9]*\\]$";
    public static final String FUNCTION_EXPR_TAG3 = "^F`[a-zA-Z]*`[0-9]*";

    public static boolean check(String str) {
        if (str != null) {
            for (RuleFunctionEnum function : RuleFunctionEnum.values()) {
                if (!str.startsWith("@" + function.getName() + "(")) continue;
                return true;
            }
            return FunctionProxy.verify(str);
        }
        return false;
    }

    public static boolean verify(String functionStr) {
        if (StringUtils.isEmpty((String)functionStr)) {
            return false;
        }
        return functionStr.trim().matches(FUNCTION_EXPR_TAG1) || functionStr.trim().matches(FUNCTION_EXPR_TAG2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OtherFun parse(String str) {
        OtherFun funcExpr = new OtherFun(str);
        if (str.startsWith("@")) {
            int startIndex = str.indexOf(64);
            int endIndex = str.indexOf(40);
            int lastIndex = str.lastIndexOf(41);
            String functionName = str.substring(startIndex + 1, endIndex);
            funcExpr.setFunctionName(functionName);
            funcExpr.setFunctionKey(functionName);
            funcExpr.setParams(new ArrayList<Object>());
            if (!functionName.equals("Round")) return null;
            int lastParamIndex = str.lastIndexOf(44);
            String lastPerm = str.substring(lastParamIndex + 1, lastIndex);
            if (lastPerm.trim().equals("")) {
                lastPerm = "0";
            }
            Parse2RPN parse2RPN = new Parse2RPN(lastPerm);
            parse2RPN.parse();
            IExpress iExpre = parse2RPN.getExpr();
            if (!(iExpre instanceof NumberExpr)) throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u7c7b\u578b\u9519\u8bef\u3002", (String)"FunctionProxy_3", (String)"epm-eb-olap", (Object[])new Object[0]));
            BigDecimal val = (BigDecimal)((NumberExpr)iExpre).getNumber();
            if (val.scale() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u53ea\u80fd\u662f\u6574\u6570\u3002", (String)"FunctionProxy_0", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (val.compareTo(BigDecimal.ZERO) < 0 || val.compareTo(BigDecimal.TEN) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u7684\u53ea\u80fd\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e10\u3002", (String)"FunctionProxy_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            funcExpr.getParams().add(0, iExpre);
            String firstPerm = str.substring(endIndex + 1, lastParamIndex);
            if (StringUtils.isEmpty((String)firstPerm)) {
                throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunctionProxy_4", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            Parse2RPN parse2RPN1 = new Parse2RPN(firstPerm);
            parse2RPN1.parse();
            IExpress iExpre1 = parse2RPN1.getExpr();
            if (FunReturnType.Numeric != iExpre1.getReturnType()) {
                throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u7c7b\u578b\u9519\u8bef\u3002", (String)"FunctionProxy_2", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            funcExpr.getParams().add(0, iExpre1);
            return funcExpr;
        }
        String functionKey = null;
        if (StringUtils.isEmpty((String)str)) return funcExpr;
        int index1 = str.indexOf(91) + 1;
        int index2 = str.indexOf(93);
        functionKey = str.substring(index1, index2);
        funcExpr.setFunctionKey(functionKey);
        funcExpr.setFunctionName(FunctionProxy.getFucntionNameFromKey(functionKey));
        index1 = str.indexOf(40) + 1;
        index2 = str.lastIndexOf(41);
        if (index1 <= 1 || index2 <= 0) return funcExpr;
        str = str.substring(index1, index2);
        for (String param : str.split(",")) {
            Parse2RPN parse2RPN = new Parse2RPN(param);
            parse2RPN.parse();
            IExpress iExpre = parse2RPN.getExpr();
            funcExpr.getParams().add(iExpre);
        }
        return funcExpr;
    }

    private static String getFucntionNameFromKey(String functionKey) {
        StringBuilder sb = new StringBuilder();
        boolean findFirstSign = false;
        for (char word : functionKey.toCharArray()) {
            if (!findFirstSign) {
                if (word != '`') continue;
                findFirstSign = true;
                continue;
            }
            if (word == '`') break;
            sb.append(word);
        }
        return sb.toString();
    }
}

