/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr;

import java.util.Arrays;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.impl.ext.expr.face.IAnalyseExpr;
import kd.epm.eb.olap.impl.ext.expr.impl.EmptyExpr;
import kd.epm.eb.olap.impl.metadata.DataRow;

public class AnalyseExprParse {
    private static final Log log = LogFactory.getLog(AnalyseExprParse.class);
    private static final IAnalyseExpr defaultExpr = EmptyExpr.of();

    public static IAnalyseExpr parse(DataRow dataRow, IModelCacheHelper modelCacheHelper, Map<String, IDataRow> dataRowMap, Map<String, String> commMemberMap) {
        IAnalyseExpr expr = defaultExpr;
        if (dataRow == null || StringUtils.isEmpty((String)dataRow.getExpression()) || modelCacheHelper == null) {
            return expr;
        }
        int beginIndex = dataRow.getExpression().indexOf(40);
        int endIndex = dataRow.getExpression().indexOf(41);
        if (beginIndex == -1 || endIndex == -1) {
            return expr;
        }
        String exprNumber = dataRow.getExpression().substring(0, beginIndex).trim();
        for (QuickAnalyzeActionEnum type : QuickAnalyzeActionEnum.values()) {
            if (!type.getNumber().equals(exprNumber) || (expr = AnalyseExprParse.buildAnalyseExpr(type)) == null) continue;
            expr.setModelCacheHelper(modelCacheHelper);
            expr.setDataRowMap(dataRowMap);
            expr.setCommMemberMap(commMemberMap);
            String exprParams = dataRow.getExpression().substring(beginIndex + 1, endIndex).trim();
            if (!StringUtils.isNotEmpty((String)exprParams)) break;
            String[] params = exprParams.split(",");
            expr.setParams(Arrays.asList(params));
            break;
        }
        return expr;
    }

    private static IAnalyseExpr buildAnalyseExpr(QuickAnalyzeActionEnum type) {
        if (type == null) {
            return defaultExpr;
        }
        IAnalyseExpr expr = null;
        String classPath = "kd.epm.eb.olap.impl.ext.expr.impl.";
        String className = StringUtils.firstUpperCase((String)type.getNumber());
        try {
            Class<?> _class = Class.forName(classPath + className);
            expr = (IAnalyseExpr)_class.newInstance();
        }
        catch (Exception ex) {
            log.warn("analyse expr parse error.", (Throwable)ex);
        }
        return expr;
    }
}

