/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr.impl;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.ext.expr.impl.AbstractLeadExpr;

public abstract class AbstractAccumulated
extends AbstractLeadExpr {
    @Override
    public BigDecimal calc(MembersKey currKey, Map<MembersKey, IKDCell> membersKeys, Map<String, Integer> dimIndexMap) {
        Set<String> periods;
        if (currKey == null || membersKeys == null || dimIndexMap == null) {
            return null;
        }
        Integer periodIndex = dimIndexMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (periodIndex == null) {
            log.warn("YearOnYear calc error. periodIndex is null.");
            return null;
        }
        BigDecimal value = null;
        Object[] metas = currKey.getKeys();
        if (metas != null && metas.length > periodIndex + 1 && (periods = this.getMetas().get(SysDimensionEnum.BudgetPeriod.getNumber())) != null) {
            for (String period : periods) {
                Object[] _metas = new Object[metas.length];
                System.arraycopy(metas, 0, _metas, 0, metas.length);
                _metas[periodIndex.intValue() + 1] = period;
                IKDCell cell = membersKeys.get(new MembersKey(_metas));
                if (cell == null || cell.getValue().getDecimal() == null) continue;
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                value = value.add(cell.getValue().getDecimal());
            }
        }
        return value;
    }
}

