/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr.impl;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.ext.expr.impl.AbstractExpr;

public abstract class AbstractLeadExpr
extends AbstractExpr {
    private Map<String, String> leads = Maps.newLinkedHashMap();

    protected Map<String, String> getLeads() {
        return this.leads;
    }

    @Override
    public BigDecimal calc(MembersKey currKey, Map<MembersKey, IKDCell> membersKeys, Map<String, Integer> dimIndexMap) {
        IKDCell lead;
        if (currKey == null || membersKeys == null || dimIndexMap == null) {
            return null;
        }
        BigDecimal leadValue = null;
        MembersKey leadKey = this.leadPeriod(currKey, dimIndexMap);
        if (leadKey != null && (lead = membersKeys.get(leadKey)) != null && lead.getValue().getDecimal() != null) {
            leadValue = lead.getValue().getDecimal();
        }
        return leadValue;
    }

    protected MembersKey leadPeriod(MembersKey currKey, Map<String, Integer> dimIndexMap) {
        if (currKey == null || dimIndexMap == null) {
            return null;
        }
        Integer index = dimIndexMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (index == null) {
            log.warn("YearOnYear calc error. periodIndex is null.");
            return null;
        }
        int periodIndex = index + 1;
        Object[] metas = currKey.getKeys();
        if (metas != null && metas.length > periodIndex) {
            Object[] clone = new Object[metas.length];
            System.arraycopy(metas, 0, clone, 0, metas.length);
            String leadPeriod = this.getLeads().get(metas[periodIndex]);
            if (leadPeriod != null) {
                clone[periodIndex] = leadPeriod;
                return new MembersKey(clone);
            }
        }
        return null;
    }

    protected MembersKey leadPeriod(MembersKey currKey, PeriodLeadUtils.PeriodLead pCtp, Map<String, Integer> dimIndexMap) {
        if (currKey == null || pCtp == null || dimIndexMap == null) {
            return null;
        }
        Integer index = dimIndexMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (index == null) {
            log.warn("YearOnYear calc error. periodIndex is null.");
            return null;
        }
        int periodIndex = index + 1;
        Object[] metas = currKey.getKeys();
        if (metas != null && metas.length > periodIndex) {
            Object[] clone = new Object[metas.length];
            System.arraycopy(metas, 0, clone, 0, metas.length);
            String leadPeriod = PeriodLeadUtils.get((String)((String)metas[periodIndex]), (PeriodLeadUtils.PeriodLead)pCtp);
            if (leadPeriod != null) {
                clone[periodIndex] = leadPeriod;
                return new MembersKey(clone);
            }
        }
        return null;
    }
}

