/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.ext.expr.impl.AbstractAccumulated;

public class Accumulated
extends AbstractAccumulated {
    @Override
    public Map<String, Set<String>> getMetas() {
        if (this.metas == null) {
            this.metas = Maps.newLinkedHashMap();
            if (!this.getParams().isEmpty()) {
                String dataRowKey = this.getParams().get(0);
                IDataRow dataRow = this.getDataRowMap().get(dataRowKey);
                if (dataRow != null) {
                    BgPeriodHelper.PeriodType periodType;
                    PeriodLeadUtils.PeriodLead ctp;
                    String periodNumber = dataRow.getMetas().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (periodNumber == null && this.getCommMemberMap() != null) {
                        periodNumber = this.getCommMemberMap().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    }
                    if ((ctp = PeriodLeadUtils.parse((String)dataRow.getLead())) != null) {
                        String _leadNumber = PeriodLeadUtils.get((String)periodNumber, (PeriodLeadUtils.PeriodLead)ctp);
                        periodNumber = this.getModelCacheHelper().getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, _leadNumber) != null ? _leadNumber : null;
                    }
                    if ((periodType = BgPeriodHelper.parse((String)periodNumber)) != null) {
                        Set members = this.metas.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), f -> Sets.newHashSet());
                        Dimension periodDim = this.getModelCacheHelper().getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                        for (Member member : periodDim.getAllMembers()) {
                            if (!BgPeriodHelper.compareType((String)member.getNumber(), (String)periodNumber) || BgPeriodHelper.compareTo((String)member.getNumber(), (String)periodNumber) > 0) continue;
                            members.add(member.getNumber());
                        }
                    }
                }
            }
        }
        return this.metas;
    }

    @Override
    public BigDecimal calc(MembersKey currKey, Map<MembersKey, IKDCell> membersKeys, Map<String, Integer> dimIndexMap) {
        return super.calc(currKey, membersKeys, dimIndexMap);
    }
}

