/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.ext.expr.impl.AbstractLeadExpr;

public class MonthOnMonth
extends AbstractLeadExpr {
    private PeriodLeadUtils.PeriodLead pCtp = null;

    @Override
    public Map<String, String> getLeads() {
        return super.getLeads();
    }

    @Override
    public Map<String, Set<String>> getMetas() {
        if (this.metas == null) {
            this.metas = Maps.newHashMap();
            if (!this.getParams().isEmpty()) {
                String dataRowKey = this.getParams().get(0);
                IDataRow dataRow = this.getDataRowMap().get(dataRowKey);
                if (dataRow != null) {
                    String leadNumber;
                    String periodNumber;
                    String _periodNumber = dataRow.getMetas().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (_periodNumber == null && this.getCommMemberMap() != null) {
                        _periodNumber = this.getCommMemberMap().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    }
                    if (StringUtils.isNotEmpty((String)(periodNumber = _periodNumber)) && (leadNumber = this.getLeads().computeIfAbsent(periodNumber, f -> {
                        PeriodLeadUtils.PeriodLead ctp;
                        String _leadNumber = periodNumber;
                        if (StringUtils.isNotEmpty((String)dataRow.getLead())) {
                            this.pCtp = PeriodLeadUtils.parse((String)dataRow.getLead());
                            if (this.pCtp != null) {
                                _leadNumber = PeriodLeadUtils.get((String)_leadNumber, (PeriodLeadUtils.PeriodLead)this.pCtp);
                            }
                        }
                        if ((ctp = PeriodLeadUtils.getCTPLead()) != null) {
                            _leadNumber = PeriodLeadUtils.get((String)_leadNumber, (PeriodLeadUtils.PeriodLead)ctp);
                            if (this.getModelCacheHelper().getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, _leadNumber) != null) {
                                return _leadNumber;
                            }
                        }
                        return null;
                    })) != null) {
                        Set members = this.metas.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), f -> Sets.newHashSet());
                        members.add(leadNumber);
                    }
                }
            }
        }
        return this.metas;
    }

    @Override
    public BigDecimal calc(MembersKey currKey, Map<MembersKey, IKDCell> membersKeys, Map<String, Integer> dimIndexMap) {
        if (currKey == null || membersKeys == null || dimIndexMap == null) {
            return null;
        }
        BigDecimal currValue = null;
        IKDCell currCell = this.pCtp != null ? membersKeys.get(this.leadPeriod(currKey, this.pCtp, dimIndexMap)) : membersKeys.get(currKey);
        if (currCell != null && currCell.getValue().getDecimal() != null) {
            currValue = currCell.getValue().getDecimal();
        }
        BigDecimal leadValue = super.calc(currKey, membersKeys, dimIndexMap);
        if (currValue != null && leadValue != null && leadValue.compareTo(BigDecimal.ZERO) != 0) {
            return currValue.subtract(leadValue).divide(leadValue, 15, 4);
        }
        return null;
    }
}

