/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.ext.expr.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.ext.expr.impl.AbstractAccumulated;

public class YearAccumulated
extends AbstractAccumulated {
    @Override
    public Map<String, Set<String>> getMetas() {
        if (this.metas == null) {
            this.metas = Maps.newHashMap();
            if (!this.getParams().isEmpty()) {
                String dataRowKey = this.getParams().get(0);
                IDataRow dataRow = this.getDataRowMap().get(dataRowKey);
                if (dataRow != null) {
                    BgPeriodHelper.PeriodType periodType;
                    PeriodLeadUtils.PeriodLead ctp;
                    String periodNumber = dataRow.getMetas().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (periodNumber == null && this.getCommMemberMap() != null) {
                        periodNumber = this.getCommMemberMap().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    }
                    if ((ctp = PeriodLeadUtils.parse((String)dataRow.getLead())) != null) {
                        String _leadNumber = PeriodLeadUtils.get((String)periodNumber, (PeriodLeadUtils.PeriodLead)ctp);
                        periodNumber = this.getModelCacheHelper().getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, _leadNumber) != null ? _leadNumber : null;
                    }
                    if ((periodType = BgPeriodHelper.parse((String)periodNumber)) != null) {
                        Set members = this.metas.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), f -> Sets.newHashSet());
                        if (periodType.getType() == 1) {
                            members.add(periodNumber);
                        } else {
                            int end = periodType.getPeriod();
                            for (int begin = 1; begin <= end; ++begin) {
                                periodNumber = BgPeriodHelper.toPeriodNumber((BgPeriodHelper.PeriodType)BgPeriodHelper.PeriodType.of((int)periodType.getType(), (int)periodType.getYear(), (int)begin));
                                if (periodNumber == null) continue;
                                members.add(periodNumber);
                            }
                        }
                    }
                }
            }
        }
        return this.metas;
    }

    @Override
    public BigDecimal calc(MembersKey currKey, Map<MembersKey, IKDCell> membersKeys, Map<String, Integer> dimIndexMap) {
        return super.calc(currKey, membersKeys, dimIndexMap);
    }
}

