/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.func.calc;

import java.math.BigDecimal;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IList;
import kd.epm.eb.algo.olap.collection.ListFactoryFactory;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.BooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.util.Util;

public class MemberPropertiesFilterCalc
extends AbstractListCalc {
    private ListCalc listCalc;
    private BooleanCalc calc;
    private static final int BOOLEAN_CALC_PARAM_SIZE = 2;

    public MemberPropertiesFilterCalc(Exp exp, ListCalc listCalc, BooleanCalc calc) {
        super(exp, new Calc[]{listCalc, calc});
        this.listCalc = listCalc;
        this.calc = calc;
    }

    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList result = ListFactoryFactory.getListFactory().createArrayList();
        Calc[] calcArray = this.calc.getCalcs();
        if (calcArray == null || calcArray.length < 2) {
            return result;
        }
        Calc calc = calcArray[0];
        Calc calc2 = calcArray[1];
        Object evaluate2 = calc2.evaluate(evaluator);
        Evaluator evaluator2 = evaluator.push();
        if (((SetType)this.listCalc.getType()).getElementType() instanceof MemberType) {
            IList members = this.listCalc.evaluateList(evaluator);
            for (Member member : members) {
                evaluator2.setContext(member);
                Object evaluate = calc.evaluate(evaluator2);
                if (!this.evaluateBoolean(this.evaluateBigDecimal(evaluator2, evaluate), this.evaluateBigDecimal(evaluator, evaluate2))) continue;
                result.add((Object)member);
            }
        }
        return result;
    }

    public BigDecimal evaluateBigDecimal(Evaluator evaluator, Object o) throws OlapException {
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        } else if (o instanceof Number) {
            return Util.toBigDecimal((Object)((Number)o));
        }
        throw new OlapException("Can't convert " + this.exp.toMdx() + " to Number.");
    }

    public boolean evaluateBoolean(BigDecimal o0, BigDecimal o1) throws OlapException {
        if (o0 == null && o1 == null) {
            return true;
        }
        if (o0 == null || o1 == null) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal("-1");
        if (o0.compareTo(bigDecimal) == 0 || o1.compareTo(bigDecimal) == 0) {
            return false;
        }
        return o0.compareTo(o1) == 0;
    }
}

