/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.utils.DimMembers;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.impl.ext.expr.AnalyseExprParse;
import kd.epm.eb.olap.impl.ext.expr.face.IAnalyseExpr;
import kd.epm.eb.olap.impl.ext.expr.impl.EmptyExpr;

public class DataRow
implements IDataRow,
Serializable {
    private String index = null;
    private String refIndex = null;
    private Map<String, String> metas = Maps.newLinkedHashMap();
    private Map<String, Set<String>> calcMates = Maps.newLinkedHashMap();
    private Map<String, IAnalyseExpr> expressions = Maps.newLinkedHashMap();
    private Map<String, Long> dimensionViews = Maps.newHashMapWithExpectedSize((int)16);
    private String lead = null;
    private DataRowEnum type = DataRowEnum.DATA;
    private String expression = null;

    @Override
    public void setIndex(String index) {
        this.index = index;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public void setRefIndex(String refIndex) {
        this.refIndex = refIndex;
    }

    @Override
    public String getRefIndex() {
        return this.refIndex;
    }

    @Override
    public void setMetas(Map<String, String> metas) {
        this.metas.clear();
        if (metas != null) {
            this.metas.putAll(metas);
        }
    }

    @Override
    public Map<String, String> getMetas() {
        return this.metas;
    }

    @Override
    public void addCalcMetas(String calcDim, String calcMember) {
        if (calcDim == null || calcMember == null) {
            return;
        }
        Set members = this.calcMates.computeIfAbsent(calcDim, f -> Sets.newLinkedHashSet());
        members.add(calcMember);
    }

    @Override
    public Map<String, Set<String>> getCalcMetas() {
        return this.calcMates;
    }

    @Override
    public Map<String, IAnalyseExpr> getExpressions() {
        return this.expressions;
    }

    @Override
    public IAnalyseExpr getExpr(MembersKey key, Map<String, Integer> dimIndexMap) {
        if (key == null || key.getKeys() == null || dimIndexMap == null) {
            return null;
        }
        LinkedList keys = Lists.newLinkedList();
        for (String dimension : this.getMetas().keySet()) {
            keys.add((String)key.getKeys()[dimIndexMap.get(dimension) + 1]);
        }
        for (String dimension : this.calcMates.keySet()) {
            keys.add((String)key.getKeys()[dimIndexMap.get(dimension) + 1]);
        }
        return this.getExpressions().get(StringUtils.join((Collection)keys, (char)','));
    }

    @Override
    public Map<String, Set<String>> getExtMetas(IModelCacheHelper modelCacheHelper, Map<String, IDataRow> dataRowMap, Map<String, String> commMemberMap) {
        if (DataRowEnum.CUSTOM != this.getDataRowType()) {
            return null;
        }
        DimMembers dimMembers = new DimMembers();
        for (Map.Entry<String, String> entry : this.getMetas().entrySet()) {
            dimMembers.addMembers(entry.getKey(), StringUtils.asList((String[])new String[]{entry.getValue()}));
        }
        for (Map.Entry<String, Object> entry : this.getCalcMetas().entrySet()) {
            dimMembers.addMembers(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        LinkedHashMap metas = Maps.newLinkedHashMap();
        while (dimMembers.hasNext()) {
            Map<String, Set<String>> _metas;
            Object[] objectArray = dimMembers.next();
            HashMap _commMemberMap = Maps.newHashMapWithExpectedSize((int)commMemberMap.size());
            _commMemberMap.putAll(commMemberMap);
            int in = dimMembers.getDimensions().size();
            for (int i = 0; i < in; ++i) {
                _commMemberMap.put(dimMembers.getDimensions().get(i), objectArray[i]);
            }
            String key = StringUtils.join((Object[])objectArray, (char)',');
            IAnalyseExpr expr = this.getExpressions().computeIfAbsent(key, f -> AnalyseExprParse.parse(this, modelCacheHelper, dataRowMap, _commMemberMap));
            if (expr == null || (_metas = expr.getMetas()) == null) continue;
            for (Map.Entry<String, Set<String>> entry : _metas.entrySet()) {
                if (metas.containsKey(entry.getKey())) {
                    ((Set)metas.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                metas.put(entry.getKey(), new HashSet(entry.getValue()));
            }
        }
        if (!this.getExpressions().isEmpty()) {
            HashSet removes = Sets.newHashSetWithExpectedSize((int)this.getExpressions().size());
            for (Map.Entry<String, IAnalyseExpr> entry : this.getExpressions().entrySet()) {
                if (!(entry.getValue() instanceof EmptyExpr)) continue;
                removes.add(entry.getKey());
            }
            for (String _key : removes) {
                this.getExpressions().remove(_key);
            }
        }
        return metas;
    }

    @Override
    public Map<String, Long> getDimensionViews() {
        return this.dimensionViews;
    }

    @Override
    public void setDimensionViews(Map<String, Long> dimensionViews) {
        this.dimensionViews = dimensionViews;
    }

    @Override
    public void setLead(String lead) {
        this.lead = lead;
    }

    @Override
    public String getLead() {
        return this.lead;
    }

    @Override
    public void setDataRowType(DataRowEnum type) {
        this.type = type;
    }

    @Override
    public DataRowEnum getDataRowType() {
        return this.type;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public IDataRow copy() {
        DataRow clone = new DataRow();
        clone.setIndex(this.getIndex());
        clone.setMetas(this.getMetas());
        clone.setDataRowType(this.getDataRowType());
        clone.setExpression(this.getExpression());
        clone.setDimensionViews(this.getDimensionViews());
        return clone;
    }

    public String toString() {
        return "DataRow{index='" + this.index + '\'' + ", refIndex='" + this.refIndex + '\'' + ", metas=" + this.metas + ", calcMates=" + this.calcMates + ", expressions=" + this.expressions + ", dimensionViews=" + this.dimensionViews + ", lead='" + this.lead + '\'' + ", type=" + (Object)((Object)this.type) + ", expression='" + this.expression + '\'' + '}';
    }
}

