/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IDrillQuery;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.impl.metadata.OlapBase;

public class DrillQuery
extends OlapBase
implements IDrillQuery {
    private static final long serialVersionUID = -5731497132389629708L;
    private List<Dimension> rowDims = null;
    private List<Dimension> colDims = null;
    private List<IDataRow> dataRows = null;
    private List<Dimension> dims = null;

    @Override
    public void setRowDims(List<Dimension> rowDims) {
        this.rowDims = rowDims;
    }

    @Override
    public List<Dimension> getRowDims() {
        return this.rowDims;
    }

    @Override
    public void setColDims(List<Dimension> colDims) {
        this.colDims = colDims;
    }

    @Override
    public List<Dimension> getColDims() {
        return this.colDims;
    }

    @Override
    public void setDataRows(List<IDataRow> dataRows) {
        this.dataRows = dataRows;
    }

    @Override
    public List<IDataRow> getDataRows() {
        return this.dataRows;
    }

    @Override
    public void add(IDataRow dataRow) {
        if (dataRow == null) {
            return;
        }
        if (this.dataRows == null) {
            this.dataRows = new ArrayList<IDataRow>();
        }
        this.dataRows.add(dataRow);
    }

    @Override
    public void setCommDims(List<Dimension> dims) {
        this.dims = dims;
    }

    @Override
    public List<Dimension> getCommDims() {
        return this.dims;
    }

    @Override
    public boolean check() {
        boolean re = super.check();
        if (re) {
            if (this.getRowDims() == null || this.getRowDims().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u94bb\u53d6\u884c\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\u3002", (String)"DrillQuery_0", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (this.getDataRows() == null || this.getDataRows().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u94bb\u53d6\u5217\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\u3002", (String)"DrillQuery_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            HashSet<String> dimensionSet = new HashSet<String>(32);
            for (Dimension dimension : this.getRowDims()) {
                dimensionSet.add(dimension.getNumber());
            }
            for (Dimension dimension : this.getColDims()) {
                dimensionSet.add(dimension.getNumber());
            }
            if (this.getCommDims() != null) {
                for (Dimension dimension : this.getCommDims()) {
                    dimensionSet.add(dimension.getNumber());
                }
            }
            if (dimensionSet.size() != this.getUseDimension().length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u7ef4\u5ea6\u4e0e\u6570\u636e\u96c6\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"DrillQuery_2", (String)"epm-eb-olap", (Object[])new Object[0]) + " " + dimensionSet + " " + Arrays.toString(this.getUseDimension()));
            }
            int dataSize = 0;
            for (IDataRow row : this.getDataRows()) {
                if (row.getDataRowType() == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u5206\u6790\u5217\u201c1\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"DrillQuery_3", (String)"epm-eb-olap", (Object[])new Object[]{row.getIndex()}));
                }
                if (row.getDataRowType().getIndex() == DataRowEnum.DATA.getIndex()) {
                    ++dataSize;
                    continue;
                }
                if (row.getDataRowType().getIndex() == DataRowEnum.DIFF.getIndex() || row.getDataRowType().getIndex() == DataRowEnum.RATIO.getIndex() || row.getDataRowType().getIndex() != DataRowEnum.CUSTOM.getIndex() || !StringUtils.isEmpty((String)row.getExpression())) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u5206\u6790\u5217\u201c1\u201d\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\u4e3a\u7a7a\u3002", (String)"DrillQuery_4", (String)"epm-eb-olap", (Object[])new Object[]{row.getIndex()}));
            }
            for (IDataRow row : this.getDataRows()) {
                if (row.getDataRowType().getIndex() != DataRowEnum.DIFF.getIndex() && row.getDataRowType().getIndex() != DataRowEnum.RATIO.getIndex() || dataSize <= 2 || !StringUtils.isEmpty((String)row.getExpression())) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u5206\u6790\u5217\u201c1\u201d\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\u4e3a\u7a7a\u3002", (String)"DrillQuery_5", (String)"epm-eb-olap", (Object[])new Object[]{row.getIndex()}));
            }
        }
        return re;
    }

    @Override
    public IDrillQuery copy() {
        DrillQuery clone = new DrillQuery();
        clone.setBusModelId(this.getBusModelId());
        clone.setDatasetId(this.getDatasetId());
        clone.setUseDimension(this.getUseDimension());
        clone.setDimensionMap(this.getDimensionMap());
        ArrayList rowDims = null;
        if (this.getRowDims() != null) {
            rowDims = Lists.newArrayListWithCapacity((int)this.getRowDims().size());
            int in = this.getRowDims().size();
            for (int i = 0; i < in; ++i) {
                rowDims.add(this.getRowDims().get(i).copy());
            }
        }
        clone.setRowDims(rowDims);
        ArrayList colDims = null;
        if (this.getColDims() != null) {
            colDims = Lists.newArrayListWithCapacity((int)this.getColDims().size());
            int in = this.getColDims().size();
            for (int i = 0; i < in; ++i) {
                colDims.add(this.getColDims().get(i).copy());
            }
        }
        clone.setColDims(colDims);
        ArrayList dataRows = null;
        if (this.getDataRows() != null) {
            dataRows = Lists.newArrayListWithCapacity((int)this.getDataRows().size());
            int in = this.getDataRows().size();
            for (int i = 0; i < in; ++i) {
                dataRows.add(this.getDataRows().get(i).copy());
            }
        }
        clone.setDataRows(dataRows);
        ArrayList commDims = null;
        if (this.getCommDims() != null) {
            commDims = Lists.newArrayListWithCapacity((int)this.getCommDims().size());
            int in = this.getCommDims().size();
            for (int i = 0; i < in; ++i) {
                commDims.add(this.getCommDims().get(i).copy());
            }
        }
        clone.setCommDims(commDims);
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DrillQuery info:").append('\n');
        sb.append("BusModelId:").append(this.getBusModelId()).append('\n');
        sb.append("DatasetId:").append(this.getDatasetId()).append('\n');
        if (this.getUseDimension() != null) {
            sb.append("UseDimension:");
            for (int i = 0; i < this.getUseDimension().length; ++i) {
                sb.append(this.getUseDimension()[i]).append(' ');
            }
            sb.append('\n');
        }
        if (this.getDimensionMap() != null) {
            sb.append("DimensionMap:");
            sb.append("keys").append(this.getDimensionMap().keySet());
            sb.append('\n');
        }
        if (this.rowDims != null) {
            sb.append("rowDims:").append('\n');
            for (Dimension dimension : this.rowDims) {
                sb.append(dimension.getNumber()).append(" members: ");
                if (dimension.getMembers() != null) {
                    for (Member member : dimension.getMembers()) {
                        sb.append(member.getNumber()).append(' ');
                    }
                }
                sb.append('\n');
            }
        }
        if (this.colDims != null) {
            sb.append("colDims:").append('\n');
            for (Dimension dimension : this.colDims) {
                sb.append(dimension.getNumber()).append(" members: ");
                if (dimension.getMembers() != null) {
                    for (Member member : dimension.getMembers()) {
                        sb.append(member.getNumber()).append(", ");
                    }
                }
                sb.append('\n');
            }
        }
        if (this.dims != null) {
            sb.append("commonDims:").append('\n');
            for (Dimension dimension : this.dims) {
                sb.append(dimension.getNumber()).append(" members: ");
                if (dimension.getMembers() != null) {
                    for (Member member : dimension.getMembers()) {
                        sb.append(member.getNumber()).append('[').append(member.getRange()).append(']').append(' ');
                    }
                }
                sb.append('\n');
            }
        }
        if (this.dataRows != null) {
            sb.append("dataRows:").append('\n');
            for (IDataRow d : this.dataRows) {
                sb.append(d.getIndex()).append('|').append((Object)d.getDataRowType()).append('|').append(d.getLead()).append('|').append(d.getExpression()).append('|').append(d.getMetas()).append('\n');
                if (d.getDimensionViews() == null || d.getDimensionViews().size() <= 0) continue;
                sb.append("viewIds:").append(d.getDimensionViews());
            }
        }
        if (this.getViews() != null) {
            sb.append("viewIds:").append(this.getViews());
        }
        return sb.toString();
    }
}

