/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.utils.BgDataUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCellMeta;
import kd.epm.eb.olap.api.metadata.IOlapBase;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCellMeta;
import org.jetbrains.annotations.NotNull;

public final class KDCell
implements IKDCell {
    private static final long serialVersionUID = -8015733594649375332L;
    private IKDCellMeta meta = null;
    private Long id = null;
    private IKDValue value = KDValue.NULL_VALUE;
    private IKDValue oldValue = KDValue.NULL_VALUE;
    private Boolean detail = null;
    private Boolean write = null;
    private String cellKey = null;
    private String cellDimKey = null;
    private Long dimKey = null;

    @Override
    public IKDCellMeta getMeta() {
        return this.meta;
    }

    private KDCell() {
    }

    public KDCell(IKDCellMeta meta) {
        this();
        if (meta == null || meta.getNumber() == null || meta.getNumber().length == 0) {
            throw new KDBizException("error cell parameter. meta is null.");
        }
        this.meta = meta;
    }

    public static IKDCell of(Long id) {
        KDCell cell = new KDCell();
        cell.setId(id);
        return cell;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public IKDValue getValue() {
        return this.value;
    }

    @Override
    public void setValue(IKDValue value) {
        this.value = value;
        if (this.value == null || this.value.isEmpty()) {
            this.value = KDValue.NULL_VALUE;
        }
    }

    @Override
    public IKDValue getOldValue() {
        return this.oldValue;
    }

    @Override
    public void setOldValue(IKDValue oldValue) {
        this.oldValue = oldValue;
        if (this.oldValue == null || this.oldValue.isEmpty()) {
            this.oldValue = KDValue.NULL_VALUE;
        }
    }

    @Override
    public boolean isDetail(IModelCacheHelper cacheHelper, String[] dimensions, Map<String, Long> viewIds) {
        if (cacheHelper == null || dimensions == null || dimensions.length == 0) {
            return false;
        }
        if (this.detail == null) {
            boolean verify = true;
            if (dimensions.length != this.getMeta().getNumber().length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0e\u6570\u636e\u96c6\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"KDCell_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            int in = this.getMeta().getNumber().length;
            for (int i = 0; i < in && verify; ++i) {
                String dimNumber = dimensions[i];
                String memNumber = this.getMeta().getNumber()[i];
                Long viewId = viewIds != null ? viewIds.get(dimNumber) : null;
                Member member = cacheHelper.getMemberByAnyView(dimNumber, memNumber);
                if (member == null) {
                    throw new KDBizException(new ErrorCode("EB030001", "error member number(" + dimNumber + "-" + memNumber + ", " + Arrays.toString(this.getMeta().getNumber()) + ")! member is null."), new Object[0]);
                }
                verify = member.isLeaf();
            }
            this.detail = verify;
        }
        return this.detail;
    }

    @Override
    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    @Override
    public boolean getDetail() {
        return this.detail != null ? this.detail : false;
    }

    @Override
    public boolean hasWrite(IMemberPermCache perm, String[] dimensions, Map<String, Long> viewIds) {
        if (perm == null || dimensions == null || dimensions.length == 0 || this.getMeta().getNumber().length != dimensions.length) {
            return false;
        }
        if (this.write == null) {
            boolean hasWrite = true;
            int in = this.getMeta().getNumber().length;
            for (int i = 0; i < in && hasWrite; ++i) {
                String dimNumber = dimensions[i];
                String memberNumber = this.getMeta().getNumber()[i];
                Long viewId = 0L;
                viewId = viewIds != null ? viewIds.get(dimNumber) : Long.valueOf(0L);
                hasWrite = perm.hasWritePerm(dimNumber, memberNumber, viewId);
            }
            this.write = hasWrite;
        }
        return this.write;
    }

    @Override
    public boolean isLock(IBgmdDataLockCache dataLockCache, int[] indexs) {
        return false;
    }

    @Override
    public boolean compareValue(IKDCell cell) {
        if (cell == null) {
            return false;
        }
        if (this == cell) {
            return true;
        }
        return this.getValue().compareTo(cell.getValue());
    }

    @Override
    public String getKey() {
        if (this.cellKey == null) {
            StringBuilder str = new StringBuilder();
            int in = this.getMeta().getNumber().length;
            for (int i = 0; i < in; ++i) {
                str.append(this.getMeta().getNumber()[i]).append('!');
            }
            this.cellKey = str.toString();
        }
        return this.cellKey;
    }

    @Override
    public String getKey(IOlapBase olapBase) {
        if (this.cellDimKey == null) {
            if (olapBase == null || olapBase.getUseDimensions() == null || olapBase.getUseDimensions().isEmpty() || olapBase.getUseDimensions().size() != this.getMeta().getNumber().length) {
                return null;
            }
            List<Dimension> dimensions = olapBase.getUseDimensions();
            StringBuilder str = new StringBuilder();
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                Dimension dimension = dimensions.get(i);
                str.append(dimension.getShortNumber()).append('@').append(this.getMeta().getNumber()[i]).append('!');
            }
            this.cellDimKey = str.toString();
        }
        return this.cellDimKey;
    }

    @Override
    public Long getDimKey(IOlapBase olapBase) {
        return this.getDimKey(olapBase.getUseDimension(), olapBase.getDimensionMap(), olapBase.getOrgDimIndex(), true, null);
    }

    @Override
    public Long getDimKey(IOlapBase olapBase, LogStats stats) {
        return this.getDimKey(olapBase.getUseDimension(), olapBase.getDimensionMap(), olapBase.getOrgDimIndex(), true, stats);
    }

    @Override
    public Long getDimKeyByAll(IOlapBase olapBase) {
        return this.getDimKey(olapBase.getUseDimension(), olapBase.getDimensionMap(), olapBase.getOrgDimIndex(), false, null);
    }

    @Override
    public Long getDimKeyByAll(IOlapBase olapBase, LogStats stats) {
        return this.getDimKey(olapBase.getUseDimension(), olapBase.getDimensionMap(), olapBase.getOrgDimIndex(), false, stats);
    }

    private Long getDimKey(String[] useDimension, Map<String, Dimension> dimensionMap, int orgIndex, boolean ignOrgDim, LogStats stats) {
        if (this.dimKey == null || this.dimKey == 0L) {
            this.dimKey = BgDataUtils.calcKey((String[])useDimension, (String[])this.getMeta().getNumber(), dimensionMap, (boolean)ignOrgDim, (LogStats)stats);
        }
        return this.dimKey;
    }

    public static IKDCell of(String[] metaData) {
        if (metaData == null) {
            return null;
        }
        return new KDCell(KDCellMeta.of(metaData));
    }

    public static IKDCell of(String[] metaData, BigDecimal value) {
        if (metaData == null) {
            return null;
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metaData));
        kdCell.setValue(KDValue.valueOf(value));
        return kdCell;
    }

    public static IKDCell of(String[] metaData, String text) {
        if (metaData == null || StringUtils.isEmpty((String)text)) {
            return null;
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metaData));
        kdCell.setValue(KDValue.valueOf(text));
        return kdCell;
    }

    public static IKDCell of(BgData bgdata, Object value, List<Dimension> dimensions) {
        if (bgdata == null || dimensions == null) {
            return null;
        }
        String[] metaData = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            metaData[i] = bgdata.getMemberNumber(dimensions.get(i).getNumber());
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metaData));
        kdCell.setValue(KDCell.getValue(value));
        return kdCell;
    }

    public static IKDCell of(BgData bgdata, Object value, String[] dimensions) {
        if (bgdata == null || dimensions == null) {
            return null;
        }
        String[] metaData = new String[dimensions.length];
        int in = dimensions.length;
        for (int i = 0; i < in; ++i) {
            metaData[i] = bgdata.getMemberNumber(dimensions[i]);
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metaData));
        kdCell.setValue(KDCell.getValue(value));
        return kdCell;
    }

    private static IKDValue getValue(Object value) {
        IKDValue kdValue = null;
        if (value instanceof String) {
            kdValue = KDValue.valueOf((String)value);
        } else if (value instanceof Date) {
            kdValue = KDValue.valueOf((Date)value);
        } else {
            BigDecimal numeric = ConvertUtils.toDecimal((Object)value);
            if (numeric != null) {
                kdValue = KDValue.valueOf(numeric);
            }
        }
        return kdValue;
    }

    public static IKDCell of(Cell cell, List<Dimension> dimensions, Map<String, String> defaultMemberMap) {
        kd.epm.eb.algo.olap.Member[] members;
        if (cell == null || cell.getMemberContext() == null || dimensions == null) {
            return null;
        }
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (kd.epm.eb.algo.olap.Member member : members = cell.getMemberContext()) {
            memberMap.put(member.getDimension().getName(), member.getName());
        }
        if (defaultMemberMap != null && !defaultMemberMap.isEmpty()) {
            Map.Entry<String, String> entry2 = null;
            for (Map.Entry<String, String> entry2 : defaultMemberMap.entrySet()) {
                memberMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        String[] metas = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            metas[i] = (String)memberMap.get(dimensions.get(i).getShortNumber());
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metas));
        BigDecimal value = ConvertUtils.toDecimal((Object)cell.getValue());
        if (value != null) {
            kdCell.setValue(KDValue.valueOf(value));
        }
        return kdCell;
    }

    public static IKDCell of(MembersKey cell, BigDecimal value, List<Dimension> keyDims, List<Dimension> dimensions, Map<String, String> defaultMemberMap) {
        if (cell == null || keyDims == null || dimensions == null) {
            return null;
        }
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        int in = keyDims.size();
        for (int i = 0; i < in; ++i) {
            memberMap.put(keyDims.get(i).getShortNumber(), (String)cell.getKeys()[i + 1]);
        }
        if (defaultMemberMap != null && !defaultMemberMap.isEmpty()) {
            Map.Entry<String, String> entry2 = null;
            for (Map.Entry<String, String> entry2 : defaultMemberMap.entrySet()) {
                memberMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        String[] metas = new String[dimensions.size()];
        int in2 = dimensions.size();
        for (int i = 0; i < in2; ++i) {
            metas[i] = (String)memberMap.get(dimensions.get(i).getShortNumber());
        }
        KDCell kdCell = new KDCell(KDCellMeta.of(metas));
        kdCell.setDetail(cell.isDetail());
        if (value != null) {
            kdCell.setValue(KDValue.valueOf(value));
        }
        return kdCell;
    }

    public static IKDCell of(Object[] shrekData) {
        if (shrekData == null || shrekData.length == 0) {
            return null;
        }
        String[] metas = new String[shrekData.length - 1];
        System.arraycopy(shrekData, 1, metas, 0, shrekData.length - 1);
        Object value = shrekData[0];
        if (value instanceof Number) {
            return KDCell.of(metas, ConvertUtils.toDecimal((Object)value));
        }
        if (value instanceof String) {
            return KDCell.of(metas, (String)value);
        }
        return null;
    }

    public static IKDCell of(Object[] shrekData, boolean canNull) {
        if (shrekData == null || shrekData.length == 0) {
            return null;
        }
        String[] metas = new String[shrekData.length - 1];
        System.arraycopy(shrekData, 1, metas, 0, shrekData.length - 1);
        KDCell kdCell = new KDCell(KDCellMeta.of(metas));
        kdCell.setValue(KDValue.valueOf(shrekData[0]));
        return kdCell;
    }

    public String toString() {
        return this.cellKey + ":" + this.value;
    }

    public String toShowStr() {
        return "{key:" + Arrays.toString(this.getMeta().getNumber()) + ",val:" + this.value + "}";
    }

    public static Object[] transMetas(@NotNull Object[] metas, @NotNull String[] distDims, @NotNull String[] srcDims, @NotNull Map<String, Dimension> dimensionMap, @NotNull Map<String, String> memberCache) {
        if (metas.length == 0) {
            return null;
        }
        if (metas.length != srcDims.length + 1) {
            throw new KDBizException(ResManager.loadResFormat((String)"", (String)"", (String)"", (Object[])new Object[]{StringUtils.join((Object[])metas, (char)',')}));
        }
        memberCache.clear();
        int in = srcDims.length;
        for (int i = 0; i < in; ++i) {
            memberCache.put(srcDims[i], (String)metas[i + 1]);
        }
        Object[] distMetas = new Object[distDims.length + 1];
        if (metas[0] != null) {
            distMetas[0] = metas[0];
        }
        int in2 = distDims.length;
        for (int i = 0; i < in2; ++i) {
            String memberNum = memberCache.get(distDims[i]);
            if (StringUtils.isEmpty((String)memberNum)) {
                memberNum = dimensionMap.get(distDims[i]).getNoneNumber();
            }
            distMetas[i + 1] = memberNum;
        }
        return distMetas;
    }
}

