/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IKDCubeStrategy;
import kd.epm.eb.olap.impl.base.KDProperties;
import kd.epm.eb.olap.impl.metadata.KDCubeStrategy;
import org.jetbrains.annotations.NotNull;

public class KDCube
implements IKDCube {
    private String cubeId = null;
    private String cubeNumber = null;
    private String cubeAlias = null;
    private IKDOlapServer server = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IKDProperties properties = new KDProperties();
    private IKDCubeStrategy strategy = null;

    @Override
    public void setId(@NotNull String id) {
        this.cubeId = id;
    }

    @Override
    public String getId() {
        return this.cubeId;
    }

    @Override
    public void setNumber(String number) {
        this.cubeNumber = number;
    }

    @Override
    public String getNumber() {
        return this.cubeNumber;
    }

    @Override
    public void setAlias(String alias) {
        this.cubeAlias = alias;
    }

    @Override
    public String getAlias() {
        return this.cubeAlias;
    }

    private KDCube() {
    }

    public KDCube(@NotNull String cubeId, IKDOlapServer server) {
        this();
        if (StringUtils.isEmpty((String)cubeId)) {
            throw new KDBizException("init KDCube error. cubeId is null");
        }
        this.cubeId = cubeId;
        this.server = server;
        this.initialize();
    }

    @Override
    public final void initialize() {
    }

    @Override
    public IKDOlapServer getServer() {
        return this.server;
    }

    @Override
    public IModelCacheHelper getModelCache() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)Long.valueOf(this.getId()));
        }
        return this.modelCacheHelper;
    }

    @Override
    public void reBuilder() {
        this.modelCacheHelper = null;
    }

    @Override
    public IKDProperties getProperties() {
        return this.properties;
    }

    @Override
    public IKDCubeStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.createStrategy();
        }
        return this.strategy;
    }

    @Override
    public IKDCubeStrategy createStrategy() {
        return new KDCubeStrategy(this);
    }

    @Override
    public void close() {
        this.strategy = null;
        this.getProperties().clear();
    }
}

