/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.api.metadata.IOlapBase;

public abstract class OlapBase
implements IOlapBase,
Serializable {
    private static final long serialVersionUID = 7862724174103407663L;
    private transient IModelCacheHelper modelCacheHelper = null;
    private Long modelId = null;
    private Long busModelId = null;
    private Long datasetId;
    private String[] useDimension = null;
    private List<Dimension> useDimensions = null;
    private Map<String, Dimension> dimensionMap = null;
    private Map<String, Integer> dimIndexMap = null;
    private Map<String, Long> viewIds;
    private int orgIndex = -1;
    private int accountIndex = -1;

    @Override
    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        if (this.modelCacheHelper != null) {
            this.setModelId(modelCacheHelper.getModelobj().getId());
        } else {
            this.setModelId(null);
        }
    }

    @Override
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null && this.getModelId() != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    @Override
    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Long getModelId() {
        return this.modelId;
    }

    @Override
    public Long getBusModelId() {
        return this.busModelId;
    }

    @Override
    public void setBusModelId(Long busModelId) {
        this.busModelId = busModelId;
    }

    @Override
    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public Long getDatasetId() {
        return this.datasetId;
    }

    @Override
    public String[] getUseDimension() {
        return this.useDimension;
    }

    @Override
    public void setUseDimension(String[] useDimension) {
        this.useDimension = useDimension;
    }

    @Override
    public List<Dimension> getUseDimensions() {
        if (this.useDimensions == null) {
            if (this.getUseDimension() == null || this.getUseDimension().length == 0 || this.getDimensionMap() == null || this.getDimensionMap().isEmpty()) {
                throw new KDBizException("dimension or dimensionMap is null.");
            }
            this.useDimensions = new ArrayList<Dimension>(this.getUseDimension().length);
            for (String dimNumber : this.getUseDimension()) {
                this.useDimensions.add(this.getDimensionMap().get(dimNumber));
            }
        }
        return this.useDimensions;
    }

    @Override
    public Map<String, Integer> getDimIndexMap() {
        HashMap dimIndexMap = Maps.newHashMapWithExpectedSize((int)this.useDimension.length);
        int in = this.useDimension.length;
        for (int i = 0; i < in; ++i) {
            dimIndexMap.put(this.useDimension[i], i);
        }
        return dimIndexMap;
    }

    @Override
    public void setDimensionMap(Map<String, Dimension> dimensionMap) {
        this.dimensionMap = dimensionMap;
    }

    @Override
    public Map<String, Dimension> getDimensionMap() {
        return this.dimensionMap;
    }

    @Override
    public int getDimensionIndex(String dimensionNumber) {
        Integer index;
        if (this.dimIndexMap == null) {
            this.dimIndexMap = Maps.newHashMapWithExpectedSize((int)this.useDimension.length);
            int in = this.useDimension.length;
            for (int i = 0; i < in; ++i) {
                this.dimIndexMap.put(this.useDimension[i], i);
            }
        }
        return (index = this.dimIndexMap.get(dimensionNumber)) != null ? index : -1;
    }

    @Override
    public Map<String, Long> getViews() {
        if (this.viewIds == null) {
            this.viewIds = BusinessModelServiceHelper.getViewIds((Long)this.getBusModelId(), (boolean)false);
            return this.viewIds;
        }
        return Collections.unmodifiableMap(this.viewIds);
    }

    @Override
    public void setViews(Map<String, Long> views) {
        if (views == null) {
            return;
        }
        if (this.viewIds == null) {
            this.viewIds = new HashMap<String, Long>();
        }
        this.viewIds.clear();
        this.viewIds.putAll(views);
    }

    @Override
    public void addView(String dimNumber, Long viewId) {
        if (IDUtils.isNull((Long)viewId)) {
            return;
        }
        if (this.viewIds == null) {
            this.viewIds = new HashMap<String, Long>();
        }
        this.viewIds.put(dimNumber, viewId);
    }

    @Override
    public void addViews(Map<String, Long> viewIds) {
        if (viewIds == null) {
            return;
        }
        for (Map.Entry<String, Long> entry : viewIds.entrySet()) {
            this.addView(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int getOrgDimIndex() {
        if (this.orgIndex == -1) {
            if (this.getUseDimension() == null || this.getUseDimension().length == 0) {
                throw new KDBizException("dimension or dimensionMap is null.");
            }
            int in = this.getUseDimension().length;
            for (int i = 0; i < in; ++i) {
                if (!SysDimensionEnum.Entity.getNumber().equals(this.getUseDimension()[i])) continue;
                this.orgIndex = i;
                break;
            }
        }
        return this.orgIndex;
    }

    @Override
    public int getAccountDimIndex() {
        if (this.accountIndex == -1) {
            if (this.getUseDimension() == null || this.getUseDimension().length == 0) {
                throw new KDBizException("dimension or dimensionMap is null.");
            }
            int in = this.getUseDimension().length;
            for (int i = 0; i < in; ++i) {
                if (!SysDimensionEnum.Account.getNumber().equals(this.getUseDimension()[i])) continue;
                this.accountIndex = i;
                break;
            }
        }
        return this.accountIndex;
    }

    @Override
    public Dimension getOrgDim() {
        if (this.getOrgDimIndex() == -1) {
            return null;
        }
        return this.getUseDimensions().get(this.getOrgDimIndex());
    }

    @Override
    public Dimension getAccountDim() {
        if (this.getAccountDimIndex() == -1) {
            return null;
        }
        return this.getUseDimensions().get(this.getAccountDimIndex());
    }

    @Override
    public boolean check() {
        return this.getUseDimension() != null && this.getUseDimension().length > 0 && this.getDimensionMap() != null && !this.getDimensionMap().isEmpty();
    }

    public OlapBase() {
    }

    public OlapBase(Long busModelId, Long datasetId, String[] useDimension, Map<String, Dimension> dimensionMap) {
        this();
        this.busModelId = busModelId;
        this.datasetId = datasetId;
        this.useDimension = useDimension;
        this.dimensionMap = dimensionMap;
    }

    @Override
    public abstract IOlapBase copy();
}

