/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.metadata.OlapBase;

public class OlapData
extends OlapBase
implements IOlapData {
    private static final long serialVersionUID = -4182582596520084898L;
    private Long modifierId = null;
    private Date modifyTime = null;
    private List<IKDCell> cells = null;

    public OlapData() {
    }

    public OlapData(Long modifierId, Long busModelId, Long datasetId, String[] useDimension, Map<String, Dimension> dimensionMap, List<IKDCell> cells) {
        super(busModelId, datasetId, useDimension, dimensionMap);
        this.modifierId = modifierId;
        this.cells = cells;
    }

    @Override
    public Long getModifierId() {
        if (this.modifierId == null) {
            this.modifierId = UserUtils.getUserId();
        }
        return this.modifierId;
    }

    @Override
    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    @Override
    public Date getModifyTime() {
        if (this.modifyTime == null) {
            this.modifyTime = new Date();
        }
        return this.modifyTime;
    }

    @Override
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public void setCells(List<IKDCell> cells) {
        this.cells = cells;
    }

    @Override
    public List<IKDCell> getCells() {
        return this.cells;
    }

    @Override
    public boolean check() {
        return super.check() && this.getModifierId() != null && this.getBusModelId() != null && this.getCells() != null && this.getCells().size() > 0;
    }

    public static IOlapData of(Long modifierId, Long busModelId, Long datasetId, String[] useDimension, Map<String, Dimension> dimensionMap, List<IKDCell> cells) {
        return new OlapData(modifierId, busModelId, datasetId, useDimension, dimensionMap, cells);
    }

    public static String[] by(List<Dimension> dimensions) {
        if (dimensions == null) {
            return null;
        }
        String[] useDim = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            useDim[i] = dimensions.get(i).getNumber();
        }
        return useDim;
    }

    @Override
    public IOlapData copy() {
        OlapData data = new OlapData();
        data.setBusModelId(this.getBusModelId());
        data.setDatasetId(this.getDatasetId());
        data.setModifierId(this.getModifierId());
        data.setModifyTime(this.getModifyTime());
        data.setCells(this.getCells());
        data.setUseDimension(this.getUseDimension());
        data.setDimensionMap(this.getDimensionMap());
        return data;
    }
}

