/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.metadata.IRelation;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.api.rule.IKDBizRule;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.metadata.OlapBase;
import kd.epm.eb.olap.impl.metadata.Relation;

public class OlapQuery
extends OlapBase
implements IOlapQuery,
Serializable {
    private static final long serialVersionUID = 9179826927121631458L;
    private List<IKDQuery> queries = new LinkedList<IKDQuery>();
    private Set<Long> bizRuleIds = new LinkedHashSet<Long>();
    private List<RuleDto> formulas = new LinkedList<RuleDto>();
    private List<IKDBizRule> prefFormulas = new ArrayList<IKDBizRule>();
    private Long modifierId;
    private IRelation relation = null;

    public OlapQuery() {
    }

    public OlapQuery(Long busModelId, Long datasetId, String[] useDimension, Map<String, kd.epm.eb.common.cache.impl.Dimension> dimensionMap) {
        super(busModelId, datasetId, useDimension, dimensionMap);
    }

    @Override
    public List<IKDQuery> getQueries() {
        return Collections.unmodifiableList(this.queries);
    }

    @Override
    public void setQueries(List<IKDQuery> queries) {
        if (queries == null) {
            return;
        }
        this.queries.clear();
        this.queries = queries;
    }

    @Override
    public void addQuery(IKDQuery query) {
        if (query != null) {
            this.queries.add(query);
        }
    }

    @Override
    public IKDQuery getQuery(String queryId) {
        Optional<IKDQuery> first = this.queries.stream().filter(query -> Objects.equals(queryId, query.getId())).findFirst();
        return first.orElse(null);
    }

    @Override
    public void clearQuery() {
        this.queries.clear();
    }

    @Override
    public void removeQuery(Collection<IKDQuery> queries) {
        if (queries != null) {
            for (IKDQuery query : queries) {
                this.queries.remove(query);
            }
        }
    }

    @Override
    public Set<Long> getBizRuleIds() {
        return this.bizRuleIds;
    }

    @Override
    public void setBizRuleIds(Set<Long> bizRuleIds) {
        this.bizRuleIds = bizRuleIds;
    }

    @Override
    public void setFormulas(List<RuleDto> formulas) {
        this.formulas = formulas;
    }

    @Override
    public List<RuleDto> getFormulas() {
        return this.formulas;
    }

    @Override
    public void setPrefFormulas(List<IKDBizRule> prefFormulas) {
        this.prefFormulas = prefFormulas;
    }

    @Override
    public List<IKDBizRule> getPrefFormulas() {
        return this.prefFormulas;
    }

    @Override
    public Long getModifierId() {
        return this.modifierId;
    }

    @Override
    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    @Override
    public void setRelation(IRelation relation) {
        this.relation = relation;
    }

    @Override
    public IRelation getRelation() {
        if (this.relation == null) {
            this.relation = this.createRelation();
        }
        return this.relation;
    }

    protected IRelation createRelation() {
        return new Relation(this.getModelCacheHelper());
    }

    @Override
    public IOlapQuery copy(Set<String> orgMembers) {
        OlapQuery clone = new OlapQuery(this.getBusModelId(), this.getDatasetId(), this.getUseDimension(), this.getDimensionMap());
        clone.setViews(new HashMap<String, Long>(this.getViews()));
        clone.setBizRuleIds(this.getBizRuleIds());
        clone.setFormulas(this.getFormulas());
        clone.setPrefFormulas(this.getPrefFormulas());
        clone.setBusModelId(this.getBusModelId());
        int in = this.queries.size();
        for (int i = 0; i < in; ++i) {
            IKDQuery query = this.queries.get(i);
            IKDQuery tmpQuery = query.copy(orgMembers);
            if (tmpQuery == null) continue;
            clone.addQuery(tmpQuery);
        }
        clone.setRelation(this.getRelation());
        return clone;
    }

    @Override
    public IOlapQuery copy(Map<String, List<Member>> refMember) {
        if (refMember.isEmpty()) {
            return null;
        }
        OlapQuery clone = new OlapQuery(this.getBusModelId(), this.getDatasetId(), this.getUseDimension(), this.getDimensionMap());
        clone.setViews(new HashMap<String, Long>(this.getViews()));
        clone.setBizRuleIds(this.getBizRuleIds());
        clone.setFormulas(this.getFormulas());
        clone.setPrefFormulas(this.getPrefFormulas());
        clone.setBusModelId(this.getBusModelId());
        int in = this.queries.size();
        for (int i = 0; i < in; ++i) {
            IKDQuery query = this.queries.get(i);
            clone.addQuery(query.copy(refMember));
        }
        clone.setRelation(this.getRelation());
        return clone;
    }

    @Override
    public String[] getUseDimension() {
        return super.getUseDimension();
    }

    @Override
    public boolean check() {
        boolean re = super.check();
        if (re) {
            List<IKDQuery> queries = this.getQueries();
            if (queries.isEmpty()) {
                return false;
            }
            for (IKDQuery query : queries) {
                for (Dimension dimension : query.getDimension()) {
                    if (!dimension.getMembers().isEmpty()) continue;
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    public IOlapQuery copy() {
        OlapQuery clone = new OlapQuery();
        clone.setBusModelId(this.getBusModelId());
        clone.setDatasetId(this.getDatasetId());
        clone.setUseDimension(this.getUseDimension());
        clone.setDimensionMap(this.getDimensionMap());
        clone.setViews(new HashMap<String, Long>(this.getViews()));
        clone.setQueries(new ArrayList<IKDQuery>(this.queries));
        clone.setBizRuleIds(this.getBizRuleIds());
        clone.setFormulas(this.getFormulas());
        clone.setPrefFormulas(this.getPrefFormulas());
        clone.setRelation(this.getRelation());
        return clone;
    }
}

