/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.metadata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.AbstractCacheServiceHelper;
import kd.epm.eb.olap.api.metadata.IRelation;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.query.param.QueryParameter;

public class Relation
extends AbstractCacheServiceHelper
implements IRelation {
    private final IModelCacheHelper modelCacheHelper;
    private DynamicObject relSchema = null;
    private List<String[]> relationRowData = null;
    private List<String[]> relationColData = null;
    private Boolean hasOrgRelation = null;

    protected IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    protected void setRelSchema(DynamicObject relSchema) {
        this.relSchema = relSchema;
    }

    protected DynamicObject getRelSchema() {
        return this.relSchema;
    }

    protected void setRelationRowData(List<String[]> relationRowData) {
        this.relationRowData = relationRowData;
    }

    protected List<String[]> getRelationRowData() {
        return this.relationRowData;
    }

    protected void setRelationColData(List<String[]> relationColData) {
        this.relationColData = relationColData;
    }

    protected List<String[]> getRelationColData() {
        return this.relationColData;
    }

    public Relation(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    @Override
    public void loadRelation(Long relationId, LogStats stats) {
        if (this.getModelCacheHelper() == null || relationId == null || relationId == 0L || stats == null) {
            return;
        }
        stats.addInfo("begin-load-relationData.");
        try {
            this.setRelationRowData(null);
            this.setRelationColData(null);
            this.setRelSchema(BusinessDataServiceHelper.loadSingle((Object)relationId, (String)"epm_dimensionrelation"));
            if (this.getRelSchema() != null) {
                this.queryRelationData(relationId, stats);
            }
        }
        finally {
            stats.add("end-load-relationData.");
        }
    }

    @Override
    public boolean hasRelation() {
        return this.getRelDims().size() > 0;
    }

    protected void queryRelationData(Long relationId, LogStats stats) {
        if (this.getModelCacheHelper() == null || relationId == null || relationId == 0L) {
            return;
        }
        this.setRelationRowData(this.loadRelationDataCache(relationId, stats));
    }

    protected List<String[]> loadRelationDataCache(Long relationId, LogStats stats) {
        List relationData;
        String str;
        if (this.getModelCacheHelper() == null || relationId == null || relationId == 0L) {
            return null;
        }
        String _relationId = relationId.toString();
        Map relationDataMap = (Map)Relation.get((String)"BUDGET_RELATION_DATA", Map.class);
        if (relationDataMap == null) {
            relationDataMap = Maps.newHashMapWithExpectedSize((int)32);
        }
        if (StringUtils.isNotEmpty((String)(str = (String)relationDataMap.get(_relationId)))) {
            stats.addInfo("begin-load-cache.");
            CollectionType javaType = JSONUtils.getMapper().getTypeFactory().constructCollectionType(List.class, String[].class);
            relationData = (List)JSONUtils.parse((String)str, (JavaType)javaType);
            stats.add("end-load-cache.");
        } else {
            stats.addInfo("begin-load-db.");
            relationData = this.loadRelationData(this.modelCacheHelper, stats);
            str = relationData != null ? JSONUtils.toString(relationData) : null;
            relationDataMap.put(_relationId, str);
            Relation.put((String)"BUDGET_RELATION_DATA", (Object)relationDataMap);
            stats.add("end-load-db.");
        }
        return relationData;
    }

    protected List<String[]> loadRelationData(IModelCacheHelper modelCacheHelper, LogStats stats) {
        if (modelCacheHelper == null || this.getRelSchema() == null || stats == null) {
            return null;
        }
        stats.addInfo("begin-load-relation.");
        Long dim1Id = this.getRelSchema().getLong("dimension1.id");
        Long dim2Id = this.getRelSchema().getLong("dimension2.id");
        if (dim1Id == null || dim2Id == null || dim1Id == 0L || dim2Id == 0L) {
            return null;
        }
        Dimension dimension1 = modelCacheHelper.getDimension(dim1Id);
        Dimension dimension2 = modelCacheHelper.getDimension(dim2Id);
        if (dimension1 == null || dimension2 == null) {
            return null;
        }
        Long viewId1 = this.getRelSchema().getLong("dimensionview1.id");
        Long viewId2 = this.getRelSchema().getLong("dimensionview2.id");
        String columnField1 = this.getColumnField(dimension1, true);
        String columnField2 = this.getColumnField(dimension2, false);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select ", new Object[0]).append(columnField1, new Object[0]).append(", ", new Object[0]).append(columnField2, new Object[0]);
        sql.append(" from t_eb_dimmemberrelation where frelationid = ?", new Object[]{this.getRelSchema().getLong("id")});
        sql.append(" and fstatus = '1'", new Object[0]);
        LinkedList relationData = Lists.newLinkedList();
        relationData.add(new String[]{dimension1.getShortNumber(), dimension2.getShortNumber()});
        try (DataSet ds = DB.queryDataSet((String)"queryRelationData", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                Member member1 = dimension1.getMember(viewId1, row.getLong(columnField1));
                Member member2 = dimension2.getMember(viewId2, row.getLong(columnField2));
                if (member1 == null || member2 == null) continue;
                relationData.add(new String[]{member1.getNumber(), member2.getNumber()});
            }
        }
        if (relationData == null || relationData.size() <= 1) {
            relationData = null;
        }
        stats.add("end-load-relation.");
        return relationData;
    }

    private String getColumnField(Dimension dimension, boolean hasOne) {
        String columnField = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? (hasOne ? "fcustomdim1" : "fcustomdim2") : "f" + dimension.getNumber();
        return columnField;
    }

    @Override
    public Set<String> getRelDims() {
        HashSet relDims = Sets.newHashSetWithExpectedSize((int)32);
        Set<String> rowDims = this.getRowDims();
        Set<String> colDims = this.getColDims();
        if (rowDims != null) {
            relDims.addAll(rowDims);
        }
        if (colDims != null) {
            relDims.addAll(colDims);
        }
        return relDims;
    }

    @Override
    public List<String[]>[] getFilter(Set<String> refCurrOrg, IKDQuery query, boolean hasOrgUnit, LogStats stats) {
        if (this.getRelSchema() == null || query == null || stats == null) {
            return null;
        }
        stats.addInfo("begin-getFilter.");
        List<String[]> rowFilter = this.getRowFilter(refCurrOrg, query, hasOrgUnit, stats);
        List<String[]> colFilter = this.getColFilter(refCurrOrg, query, hasOrgUnit, stats);
        if (rowFilter == null && colFilter == null) {
            return null;
        }
        List[] filters = new List[]{colFilter, rowFilter};
        stats.add("end-getFilter.");
        return filters;
    }

    @Override
    public Set<String> getRowDims() {
        List<String[]> relationData = this.getRelationRowData();
        if (relationData == null || relationData.isEmpty()) {
            return null;
        }
        String[] relDims = relationData.get(0);
        if (relDims != null && relDims.length > 0) {
            LinkedHashSet relDimSet = Sets.newLinkedHashSetWithExpectedSize((int)relDims.length);
            for (String relDim : relDims) {
                relDimSet.add(relDim);
            }
            return relDimSet;
        }
        return null;
    }

    private List<String[]> getRowFilter(Set<String> refCurrOrg, IKDQuery query, boolean hasOrgUnit, LogStats stats) {
        return this.getFilterData(refCurrOrg, query, hasOrgUnit, true, stats);
    }

    private List<String[]> getFilterData(Set<String> refCurrOrg, IKDQuery query, boolean hasOrgUnit, boolean hasRow, LogStats stats) {
        List<String[]> relationData;
        if (this.getRelSchema() == null || query == null || query.getDimension().isEmpty()) {
            return null;
        }
        List<String[]> list = relationData = hasRow ? this.getRelationRowData() : this.getRelationColData();
        if (relationData == null || relationData.isEmpty()) {
            return null;
        }
        String[] relDims = relationData.get(0);
        if (relDims == null || relDims.length == 0) {
            return null;
        }
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)relDims.length);
        for (String relDim : relDims) {
            memberMap.put(relDim, query.getMemberNumsByShort(relDim));
        }
        if (refCurrOrg != null) {
            Set tmpOrg = memberMap.computeIfAbsent(SysDimensionEnum.Entity.getNumber(), f -> Sets.newLinkedHashSet());
            if (tmpOrg.isEmpty()) {
                tmpOrg.addAll(refCurrOrg);
            } else {
                tmpOrg.retainAll(refCurrOrg);
            }
        }
        ArrayList filter = Lists.newArrayListWithCapacity((int)relationData.size());
        ArrayList tmpList = Lists.newArrayListWithCapacity((int)relationData.size());
        filter.addAll(relationData);
        int in = relDims.length;
        for (int i = 0; i < in; ++i) {
            Set filterSet = (Set)memberMap.get(relDims[i]);
            tmpList.add(relDims);
            int jn = filter.size();
            for (int j = 1; j < jn; ++j) {
                String[] relData = (String[])filter.get(j);
                if (!filterSet.contains(relData[i])) continue;
                tmpList.add(relData);
            }
            filter.clear();
            filter.addAll(tmpList);
            tmpList.clear();
        }
        if (!hasOrgUnit && this.hasOrgRelation()) {
            this.filterOrgData(filter);
        }
        return filter;
    }

    private void filterOrgData(List<String[]> relationData) {
        if (relationData == null || relationData.isEmpty()) {
            return;
        }
        int orgIndex = -1;
        String[] relDims = relationData.get(0);
        if (relDims != null) {
            int in = relDims.length;
            for (int i = 0; i < in; ++i) {
                if (!SysDimensionEnum.Entity.getShortNumber().equals(relDims[i])) continue;
                orgIndex = i;
                break;
            }
            if (orgIndex >= 0) {
                ArrayList tmpList = Lists.newArrayListWithCapacity((int)relationData.size());
                if (orgIndex == 0) {
                    for (String[] data : relationData) {
                        String[] tmpData = new String[data.length - 1];
                        System.arraycopy(data, 1, tmpData, 0, tmpData.length);
                        tmpList.add(tmpData);
                    }
                } else if (orgIndex == relDims.length - 1) {
                    for (String[] data : relationData) {
                        String[] tmpData = new String[data.length - 1];
                        System.arraycopy(data, 0, tmpData, 0, tmpData.length);
                        tmpList.add(tmpData);
                    }
                } else {
                    for (String[] data : relationData) {
                        String[] tmpData = new String[data.length - 1];
                        System.arraycopy(data, 0, tmpData, 0, orgIndex);
                        System.arraycopy(data, orgIndex + 1, tmpData, orgIndex, tmpData.length - orgIndex);
                        tmpList.add(tmpData);
                    }
                }
                relationData.clear();
                relationData.addAll(tmpList);
                tmpList.clear();
            }
        }
    }

    @Override
    public Set<String> getColDims() {
        return null;
    }

    private List<String[]> getColFilter(Set<String> refCurrOrg, IKDQuery query, boolean hasOrgUnit, LogStats stats) {
        return null;
    }

    @Override
    public boolean hasOrgRelation() {
        if (this.hasOrgRelation == null) {
            Set<String> relDims = this.getRelDims();
            this.hasOrgRelation = relDims.contains(SysDimensionEnum.Entity.getShortNumber());
        }
        return this.hasOrgRelation;
    }

    @Override
    public Set<String> getOrgRelation() {
        if (!this.hasOrgRelation()) {
            return Collections.emptySet();
        }
        LinkedHashSet orgMembers = Sets.newLinkedHashSet();
        List<String[]> rowFilters = this.getRelationRowData();
        if (rowFilters != null && rowFilters.size() > 1) {
            String[] relDims = rowFilters.get(0);
            int in = relDims.length;
            for (int i = 0; i < in; ++i) {
                if (!SysDimensionEnum.Entity.getShortNumber().equals(relDims[i])) continue;
                int jn = rowFilters.size();
                for (int j = 1; j < jn; ++j) {
                    orgMembers.add(rowFilters.get(j)[i]);
                }
            }
        }
        return orgMembers;
    }

    @Override
    public Set<String> getRefCurrOrg(QueryParameter parameter, Map<String, Set<String>> refMemberByCalc) {
        Set<String> refOrgByCalc;
        HashSet<String> refCurrOrg = new HashSet<String>();
        refCurrOrg.addAll(parameter.getRefOrgUnits());
        if (refMemberByCalc != null && (refOrgByCalc = refMemberByCalc.get(SysDimensionEnum.Entity.getNumber())) != null) {
            refCurrOrg.addAll(refOrgByCalc);
        }
        return refCurrOrg;
    }
}

