/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.query.AbstractKDData;
import kd.epm.eb.olap.impl.query.task.AbstractBaseTask;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGFData
extends AbstractKDData {
    public AbstractGFData(@NotNull LogStats stats) {
        super(stats);
    }

    protected List<AbstractBaseTask> getTasks(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, @NotNull Map<String, List<Map<String, Set<Long>>>> areaMemberMap) {
        LinkedList<AbstractBaseTask> threads = new LinkedList<AbstractBaseTask>();
        for (Map.Entry<String, List<Map<String, Set<Long>>>> entry : areaMemberMap.entrySet()) {
            String areaKey = entry.getKey();
            List<Map<String, Set<Long>>> areas = entry.getValue();
            if (areas == null || areas.isEmpty()) continue;
            int in = areas.size();
            for (int index = 0; index < in; ++index) {
                Map<String, Set<Long>> memberMap = areas.get(index);
                if (memberMap == null || memberMap.isEmpty()) continue;
                IKDQuery query = request.getOlapQuery().getQuery(areaKey);
                AbstractBaseTask callable = this.getCallable(cube, request, request.getOlapQuery(), query, memberMap);
                callable.setStats(this.getStats());
                threads.add(callable);
            }
        }
        return threads;
    }

    protected abstract AbstractBaseTask getCallable(@NotNull IKDCube var1, @NotNull IKDOlapRequest var2, @NotNull IOlapQuery var3, @NotNull IKDQuery var4, Map<String, Set<Long>> var5);

    protected abstract Map<String, List<Map<String, Set<Long>>>> getMembers(@NotNull IKDCube var1, @NotNull IKDOlapRequest var2);
}

