/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQueryView;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractKDData {
    public static final Log log = LogFactory.getLog(AbstractKDData.class);
    private LogStats stats;
    private Map<String, Long> viewIds = null;

    protected LogStats getStats() {
        return this.stats;
    }

    public AbstractKDData(@NotNull LogStats stats) {
        this.stats = stats;
    }

    public Map<String, Long> getViewIds(IKDOlapRequest request) {
        if (this.viewIds == null) {
            this.viewIds = BusinessModelServiceHelper.getEditViewIds((Long)request.getOlapQuery().getBusModelId());
        }
        return this.viewIds;
    }

    protected Map<String, Long> getViewIds(String floatKey, IKDOlapRequest request) {
        if (request == null) {
            return null;
        }
        HashMap viewIds = Maps.newHashMapWithExpectedSize((int)32);
        for (Map.Entry<String, Long> entry : request.getOlapQuery().getViews().entrySet()) {
            if (entry.getKey().indexOf(95) != -1) continue;
            viewIds.put(entry.getKey(), entry.getValue());
        }
        if (floatKey != null) {
            for (Map.Entry<String, Long> entry : request.getOlapQuery().getViews().entrySet()) {
                String[] tmpStr;
                if (entry.getKey().indexOf(95) <= 0 || (tmpStr = entry.getKey().split("_")) == null || tmpStr.length <= 1 || !floatKey.equals(tmpStr[1])) continue;
                viewIds.put(tmpStr[0], entry.getValue());
            }
        }
        return viewIds;
    }

    public abstract IKDQueryView doQuery(@NotNull IKDCube var1, @NotNull IKDOlapRequest var2);

    protected void writeRequestLog(IKDOlapRequest request) {
        if (request == null) {
            return;
        }
        int in = request.getOlapQuery().getQueries().size();
        for (int i = 0; i < in; ++i) {
            log.info("request-get" + i + JSONObject.toJSONString(request.getOlapQuery().getQueries().get(i).getDimension()));
        }
        log.info("doQuery-get-view" + JSONObject.toJSONString(request.getOlapQuery().getViews()));
    }
}

