/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.base.KDObject;

public class KDQuery
extends KDObject
implements IKDQuery {
    private Map<String, Long> viewIds = new Hashtable<String, Long>();
    private Map<String, Dimension> dimensions = new LinkedHashMap<String, Dimension>();
    private List<Dimension[]> rows = new LinkedList<Dimension[]>();
    private List<Dimension> cols = new LinkedList<Dimension>();
    private List<Member[]> floatColSection = null;

    @Override
    public Map<String, Long> getViews() {
        return Collections.unmodifiableMap(this.viewIds);
    }

    @Override
    public void setViews(Map<String, Long> views) {
        if (views == null) {
            return;
        }
        this.viewIds.clear();
        this.viewIds.putAll(views);
    }

    @Override
    public List<Dimension> getDimension() {
        return new ArrayList<Dimension>(this.dimensions.values());
    }

    @Override
    public void addDimension(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        Dimension _dimension = this.dimensions.get(dimension.getNumber());
        if (_dimension == null) {
            this.dimensions.put(dimension.getNumber(), dimension);
        } else {
            Set<String> numbers = this.getMemberNums(dimension.getNumber());
            for (Member member : dimension.getMembers()) {
                if (!numbers.add(member.getNumber())) continue;
                _dimension.add(member);
            }
        }
    }

    @Override
    public void addDimension(List<Dimension> dimensions) {
        if (dimensions == null) {
            return;
        }
        for (Dimension dimension : dimensions) {
            this.addDimension(dimension);
        }
    }

    protected List<Dimension[]> getRows() {
        return this.rows;
    }

    @Override
    public List<Dimension[]> getFloatRows() {
        return this.rows;
    }

    @Override
    public void addFloatRow(Dimension[] dimension) {
        if (dimension != null) {
            this.getRows().add(dimension);
        }
    }

    protected List<Dimension> getCols() {
        return this.cols;
    }

    @Override
    public List<Dimension> getFloatCols() {
        return Collections.unmodifiableList(this.cols);
    }

    @Override
    public void addFloatCol(Dimension dimension) {
        if (dimension != null && !dimension.getMembers().isEmpty()) {
            this.getCols().add(dimension);
        }
    }

    @Override
    public void addFloatCols(List<Dimension> dimensions) {
        if (dimensions != null && !dimensions.isEmpty()) {
            for (Dimension dimension : dimensions) {
                this.addFloatCol(dimension);
            }
        }
    }

    @Override
    public void setFloatColSection(List<Member[]> floatColSection) {
        this.floatColSection = floatColSection;
    }

    @Override
    public List<Member[]> getFloatColSection() {
        return this.floatColSection;
    }

    @Override
    public void clear() {
        this.viewIds.clear();
        this.dimensions.clear();
        this.getRows().clear();
        this.getCols().clear();
        this.floatColSection = null;
    }

    @Override
    public Set<String> getMemberNums(String dimensionNumber) {
        return this.getMemberNumber(this.dimensions.get(dimensionNumber));
    }

    @Override
    public Set<String> getMemberNumsByShort(String shortNumber) {
        Dimension dimension = null;
        for (Dimension dim : this.dimensions.values()) {
            if (!dim.getShortNumber().equals(shortNumber)) continue;
            dimension = dim;
            break;
        }
        return this.getMemberNumber(dimension);
    }

    private Set<String> getMemberNumber(Dimension dimension) {
        if (dimension == null) {
            return Collections.emptySet();
        }
        HashSet memberSet = Sets.newHashSetWithExpectedSize((int)dimension.getMembers().size());
        for (Member member : dimension.getMembers()) {
            memberSet.add(member.getNumber());
        }
        return memberSet;
    }

    @Override
    public IKDQuery copy() {
        Dimension _dimension = null;
        Dimension[] _dimensions = null;
        KDQuery clone = new KDQuery();
        clone.setViews(new HashMap<String, Long>(this.viewIds));
        for (Dimension dimension : this.getDimension()) {
            clone.addDimension(dimension.copy());
        }
        for (Dimension[] dimensionArray : this.getRows()) {
            _dimensions = new Dimension[dimensionArray.length];
            int in = dimensionArray.length;
            for (int i = 0; i < in; ++i) {
                _dimensions[i] = dimensionArray[i].copy();
            }
            clone.addFloatRow(_dimensions);
        }
        for (Dimension dimension : this.getCols()) {
            _dimension = dimension.copy();
            clone.addFloatCol(_dimension);
        }
        if (this.getFloatColSection() != null) {
            ArrayList<Member[]> _cloneSection = new ArrayList<Member[]>(this.getFloatColSection().size());
            for (Member[] section : this.getFloatColSection()) {
                Member[] memberArray = new Member[section.length];
                int in = section.length;
                for (int i = 0; i < in; ++i) {
                    memberArray[i] = section[i].copy();
                    memberArray[i].setDimension(section[i].getDimension().copy());
                }
                _cloneSection.add(memberArray);
            }
            clone.setFloatColSection(_cloneSection);
        }
        return clone;
    }

    @Override
    public IKDQuery copy(Set<String> orgMembers) {
        if (orgMembers == null || orgMembers.isEmpty()) {
            return null;
        }
        IKDQuery clone = this.copy();
        for (Dimension dimension : clone.getDimension()) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) continue;
            ArrayList<Member> removes = new ArrayList<Member>(dimension.getMembers().size());
            for (Member member : dimension.getMembers()) {
                if (orgMembers.contains(member.getNumber())) continue;
                removes.add(member);
            }
            if (!removes.isEmpty()) {
                dimension.remove(removes);
            }
            if (!dimension.getMembers().isEmpty()) break;
            return null;
        }
        return clone;
    }

    @Override
    public IKDQuery copy(Map<String, List<Member>> refMember) {
        if (refMember == null || refMember.isEmpty()) {
            return null;
        }
        List<Member> members = null;
        IKDQuery clone = this.copy();
        for (Dimension dimension : clone.getDimension()) {
            members = refMember.get(dimension.getNumber());
            if (members == null || members.isEmpty()) continue;
            dimension.clearMember();
            for (Member member : members) {
                dimension.add(member);
            }
        }
        return clone;
    }

    public String toString() {
        return "KDQuery{viewIds=" + this.viewIds + ", dimensions=" + this.dimensions + ", rows=" + this.rows + ", cols=" + this.cols + '}';
    }
}

