/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.query.floatData.FloatValue;
import kd.epm.eb.olap.impl.query.floatData.KDFloatData;
import org.jetbrains.annotations.NotNull;

public class KDQueryView
implements IKDQueryView,
Serializable {
    private static final long serialVersionUID = -1227836818189594956L;
    private IKDCube cube = null;
    private List<IKDCell> cells = new LinkedList<IKDCell>();
    private Map<String, List<List<FloatValue>>> floatMap = Maps.newHashMapWithExpectedSize((int)8);

    public KDQueryView(@NotNull IKDCube cube) {
        this.cube = cube;
    }

    @Override
    public IKDCube getCube() {
        return this.cube;
    }

    @Override
    public List<IKDCell> getCells() {
        return this.cells;
    }

    @Override
    public void addCell(IKDCell cell) {
        if (cell != null) {
            this.cells.add(cell);
        }
    }

    @Override
    public void addCells(List<IKDCell> cells) {
        if (cells != null && !cells.isEmpty()) {
            this.cells.addAll(cells);
        }
    }

    @Override
    public Map<String, List<List<FloatValue>>> getFloat() {
        return this.floatMap;
    }

    @Override
    public void mergeFloat(KDFloatData floatData) {
        if (floatData == null) {
            return;
        }
        if (this.floatMap.isEmpty()) {
            ArrayList<List<FloatValue>> data = new ArrayList<List<FloatValue>>();
            data.add(floatData.getFloatIndex(), floatData.getFloatData());
            this.floatMap.put(floatData.getKey(), data);
        } else {
            List _floatValues;
            List data = this.floatMap.computeIfAbsent(floatData.getKey(), k -> new ArrayList());
            List list = _floatValues = data.size() > floatData.getFloatIndex() ? (List)data.get(floatData.getFloatIndex()) : null;
            if (_floatValues == null) {
                data.add(floatData.getFloatIndex(), floatData.getFloatData());
            } else {
                FloatValue _value = null;
                HashMap keys = Maps.newHashMapWithExpectedSize((int)(_floatValues.size() + floatData.getFloatData().size()));
                for (FloatValue value : _floatValues) {
                    keys.put(MembersKey.of((String[])value.getFloatValue()), value);
                }
                for (FloatValue value : floatData.getFloatData()) {
                    _value = (FloatValue)keys.get(MembersKey.of((String[])value.getFloatValue()));
                    if (_value == null) {
                        _floatValues.add(value);
                        continue;
                    }
                    if (!value.isHasNumeric()) continue;
                    _value.setHasNumeric(value.isHasNumeric());
                }
            }
        }
    }
}

