/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.getData;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.query.AbstractGFData;
import kd.epm.eb.olap.impl.query.task.AbstractBaseTask;
import kd.epm.eb.olap.impl.query.task.GetTaskThread;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataGet
extends AbstractGFData {
    public AbstractDataGet(@NotNull LogStats stats) {
        super(stats);
    }

    @Override
    protected AbstractBaseTask getCallable(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, IOlapQuery olapQuery, IKDQuery query, Map<String, Set<Long>> memberMap) {
        return new GetTaskThread(cube, request, olapQuery, query, memberMap);
    }

    @Override
    protected Map<String, List<Map<String, Set<Long>>>> getMembers(IKDCube cube, IKDOlapRequest request) {
        if (cube == null || request == null) {
            return new HashMap<String, List<Map<String, Set<Long>>>>();
        }
        HashMap floatMemberMap = Maps.newHashMapWithExpectedSize((int)request.getOlapQuery().getQueries().size());
        IModelCacheHelper cacheHelper = cube.getModelCache();
        int in = request.getOlapQuery().getQueries().size();
        for (int i = 0; i < in; ++i) {
            IKDQuery query = request.getOlapQuery().getQueries().get(i);
            Map<String, Long> viewIds = this.getViewIds(query.getId(), request);
            List floatArea = floatMemberMap.computeIfAbsent(query.getId(), k -> new LinkedList());
            Map<String, Set<Long>> memberMap = this.getMember(cacheHelper, query, viewIds);
            floatArea.add(memberMap);
        }
        return floatMemberMap;
    }

    private Map<String, Set<Long>> getMember(@NotNull IModelCacheHelper cacheHelper, IKDQuery query, Map<String, Long> viewIds) {
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)query.getDimension().size());
        StringBuilder errors = new StringBuilder();
        boolean hasNoFind = false;
        for (Dimension dimension : query.getDimension()) {
            Long viewId = viewIds.get(dimension.getNumber());
            errors.setLength(0);
            errors.append("member-no-find. dimension = ").append(dimension.getNumber()).append(", member in (");
            Set memberIds = memberMap.computeIfAbsent(dimension.getNumber(), k -> new LinkedHashSet());
            for (Member member : dimension.getMembers()) {
                kd.epm.eb.common.cache.impl.Member _member = cacheHelper.getMember(dimension.getNumber(), viewId, member.getNumber());
                if (_member == null) {
                    hasNoFind = true;
                    errors.append(member.getNumber()).append(',');
                    continue;
                }
                memberIds.add(_member.getId());
                if (!hasNoFind) continue;
                log.warn(errors.toString());
            }
        }
        return memberMap;
    }
}

