/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.getData;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.OlapThreadPools;
import kd.epm.eb.olap.impl.query.KDQueryView;
import kd.epm.eb.olap.impl.query.floatData.KDFloatData;
import kd.epm.eb.olap.impl.query.getData.AbstractDataGet;
import kd.epm.eb.olap.impl.query.task.AbstractBaseTask;
import org.jetbrains.annotations.NotNull;

public class DataGet
extends AbstractDataGet {
    public DataGet(@NotNull LogStats stats) {
        super(stats);
    }

    @Override
    public IKDQueryView doQuery(IKDCube cube, IKDOlapRequest request) {
        KDQueryView view = new KDQueryView(cube);
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin-getData.");
        if (request.getOlapQuery() == null || request.getOlapQuery().getQueries().isEmpty()) {
            stats.addInfo("end getData(olapQuery is null or queries is null).");
            return view;
        }
        this.writeRequestLog(request);
        Map<String, List<Map<String, Set<Long>>>> areaMemberMap = this.getMembers(cube, request);
        List<AbstractBaseTask> threads = this.getTasks(cube, request, areaMemberMap);
        try {
            if (threads != null && !threads.isEmpty()) {
                Future future;
                ArrayList<Future> results = new ArrayList<Future>();
                RequestContext _context = RequestContext.getOrCreate();
                CountDownLatch cdl = new CountDownLatch(threads.size());
                for (AbstractBaseTask _callable : threads) {
                    _callable.setCdl(cdl);
                    future = OlapThreadPools.getOlapQueryPool().submit((Callable)_callable, _context);
                    if (future == null) continue;
                    results.add(future);
                }
                cdl.await();
                int in = results.size();
                for (int i = 0; i < in; ++i) {
                    future = (Future)results.get(i);
                    Object result = future.get();
                    if (result instanceof List) {
                        List _cells = (List)result;
                        view.addCells(_cells);
                        continue;
                    }
                    if (!(result instanceof KDFloatData)) continue;
                    view.mergeFloat((KDFloatData)result);
                }
            }
        }
        catch (Exception ex) {
            log.error("budget-olap-log : ", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c(%1)", (String)"AbstractKDDataGet_0", (String)"epm-eb-olap", (Object[])new Object[]{ex.getMessage() != null ? ex.getMessage() : ""}));
        }
        finally {
            stats.addInfo("out-getData-size" + view.getCells().size());
            stats.addInfo("end-getData.");
            log.info(stats.toString());
        }
        return view;
    }

    @Override
    protected List<AbstractBaseTask> getTasks(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, @NotNull Map<String, List<Map<String, Set<Long>>>> areaMemberMap) {
        return super.getTasks(cube, request, areaMemberMap);
    }

    @Override
    protected AbstractBaseTask getCallable(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, IOlapQuery olapQuery, IKDQuery query, Map<String, Set<Long>> memberMap) {
        return super.getCallable(cube, request, olapQuery, query, memberMap);
    }
}

