/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.OlapThreadPools;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataAgent;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.execute.BizRuleManager;
import kd.epm.eb.olap.impl.query.AbstractKDData;
import kd.epm.eb.olap.impl.query.KDQueryView;
import kd.epm.eb.olap.impl.query.kd.KDDataQueryThread;
import kd.epm.eb.olap.impl.query.kd.KDOtherDataQueryThread;
import kd.epm.eb.olap.impl.query.kd.param.ParamManager;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractDataQueryBase;
import kd.epm.eb.olap.impl.query.queryData.AbstractQueryBase;
import kd.epm.eb.olap.impl.utils.OlapUtils;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public class KDDataQuery
extends AbstractKDData {
    private static final Log log = LogFactory.getLog(KDDataQuery.class);

    public static KDDataQuery get(LogStats stats) {
        return new KDDataQuery(stats);
    }

    public KDDataQuery(LogStats stats) {
        super(stats);
    }

    @Override
    public IKDQueryView doQuery(IKDCube cube, IKDOlapRequest request) {
        this.getStats().addInfo("begin doQuery.");
        KDQueryView view = new KDQueryView(cube);
        if (request.getOlapQuery() == null || request.getOlapQuery().getQueries().isEmpty()) {
            this.getStats().addInfo("end doQuery(olapQuery is null or queries is null).");
            return view;
        }
        IKDValue relation = request.getProperties().getPropertyValue("RELATION_SCHEMA_ID");
        if (relation != null) {
            request.getOlapQuery().getRelation().loadRelation(Long.valueOf(relation.getString()), this.getStats());
        }
        BizRuleManager.getInstance().initBizRules(request, cube);
        this.getStats().add("end-BizRuleManager-initBizRules.");
        ParamManager olapParams = ParamManager.get().initParams(cube, request);
        this.getStats().add("end-ParamManager-initParams.");
        try {
            List<Callable<CubeDataResult>> tasks = this.getQueries(cube, request, olapParams, true);
            this.doQuery(cube, request, tasks, view, true);
            this.getStats().add("end-doQuery-leaf. size = " + tasks.size());
            tasks = this.getQueries(cube, request, olapParams, false);
            this.doQuery(cube, request, tasks, view, false);
            this.getStats().add("end-doQuery-noleaf. size = " + tasks.size());
        }
        catch (Exception ex) {
            log.error("budget-olap-log : ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        return view;
    }

    protected List<Callable<CubeDataResult>> getQueries(IKDCube cube, IKDOlapRequest request, ParamManager paramManager, boolean isLeaf) {
        AbstractQueryBase callable;
        LinkedList<Callable<CubeDataResult>> queries = new LinkedList<Callable<CubeDataResult>>();
        if (cube == null || request == null || paramManager == null) {
            return queries;
        }
        List[] result = this.getRequests(cube, request, isLeaf);
        List requests = result[0];
        List refOrgUnits = result[1];
        boolean hasOtherMetric = this.hasOtherData(cube, request);
        int in = requests.size();
        for (int i = 0; i < in; ++i) {
            QueryParameter param = this.createQueryParam();
            param.setLeaf(isLeaf);
            param.setRefOrgUnits((Set)refOrgUnits.get(i));
            callable = this.getQueryTask(param, cube, (IKDOlapRequest)requests.get(i), paramManager);
            queries.add(callable);
        }
        if (isLeaf && hasOtherMetric) {
            callable = this.getQueryOtherTask(this.createQueryParam(), cube, request);
            queries.add(callable);
        }
        return queries;
    }

    protected AbstractDataQueryBase getQueryTask(QueryParameter param, IKDCube cube, IKDOlapRequest request, ParamManager paramManager) {
        return new KDDataQueryThread(param, cube, request, paramManager);
    }

    protected AbstractQueryBase getQueryOtherTask(QueryParameter param, IKDCube cube, IKDOlapRequest request) {
        return new KDOtherDataQueryThread(param, cube, request);
    }

    protected List[] getRequests(IKDCube cube, IKDOlapRequest request, boolean isLeaf) {
        List[] result = new List[2];
        LinkedList requests = Lists.newLinkedList();
        LinkedList refOrgUnits = Lists.newLinkedList();
        result[0] = requests;
        result[1] = refOrgUnits;
        int orgSize = 20;
        LinkedHashSet numbers = Sets.newLinkedHashSet();
        Dimension orgDim = cube.getModelCache().getDimension(SysDimensionEnum.Entity.getNumber());
        View orgView = orgDim.getView(request.getOlapQuery().getViews().get(SysDimensionEnum.Entity.getNumber()));
        Set<String> orgRel = null;
        if (request.getOlapQuery().getRelation().hasOrgRelation()) {
            orgRel = request.getOlapQuery().getRelation().getOrgRelation();
        }
        int in = request.getOlapQuery().getQueries().size();
        for (int i = 0; i < in; ++i) {
            IKDQuery query = request.getOlapQuery().getQueries().get(i);
            Set<String> orgNumbers = query.getMemberNums(SysDimensionEnum.Entity.getNumber());
            if (orgNumbers == null || orgNumbers.isEmpty()) continue;
            for (String orgNumber : orgNumbers) {
                kd.epm.eb.common.cache.impl.Member member;
                if (orgRel != null && !orgRel.contains(orgNumber) || (member = orgView != null ? orgView.getMember(orgNumber) : orgDim.getMember(orgNumber)) == null || member.isLeaf() != isLeaf) continue;
                numbers.add(orgNumber);
            }
        }
        if (!numbers.isEmpty()) {
            if (numbers.size() > 20 && isLeaf && request.getOlapQuery().getQueries().size() == 1 && this.calcDescartes(request.getOlapQuery().getQueries().get(0)) < 100000L) {
                requests.add(request.copy(numbers));
                refOrgUnits.add(numbers);
            } else {
                List partition = Lists.partition((List)Lists.newArrayList((Iterable)numbers), (int)orgSize);
                for (List _tmpSet : partition) {
                    requests.add(request.copy(new HashSet<String>(_tmpSet)));
                    refOrgUnits.add(new HashSet(_tmpSet));
                }
            }
        }
        return result;
    }

    private Long calcDescartes(IKDQuery ikdQuery) {
        List<kd.epm.eb.common.model.Dimension> dimension = ikdQuery.getDimension();
        long descartes = 1L;
        for (kd.epm.eb.common.model.Dimension dimension1 : dimension) {
            descartes *= (long)dimension1.getMembers().size();
        }
        if (descartes < 0L) {
            return Long.MAX_VALUE;
        }
        return descartes;
    }

    protected boolean hasOtherData(IKDCube cube, IKDOlapRequest request) {
        if (cube == null || request == null) {
            return false;
        }
        Dimension metric = cube.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber());
        if (metric == null) {
            return false;
        }
        kd.epm.eb.common.cache.impl.Member member = null;
        boolean re = false;
        for (IKDQuery query : request.getOlapQuery().getQueries()) {
            for (kd.epm.eb.common.model.Dimension dimension : query.getDimension()) {
                if (!SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
                for (Member _member : dimension.getMembers()) {
                    member = metric.getMember(null, _member.getId());
                    if (member == null || !MetricDataTypeEnum.TEXT.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.DATE.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.ENUM.getIndex().equals(member.getDatatype())) continue;
                    re = true;
                    _member.setIgnore(true);
                }
            }
        }
        return re;
    }

    protected QueryParameter createQueryParam() {
        return new QueryParameter();
    }

    protected void doQuery(IKDCube cube, IKDOlapRequest request, List<Callable<CubeDataResult>> tasks, IKDQueryView view, boolean isDetail) {
        if (tasks == null || tasks.isEmpty() || view == null) {
            return;
        }
        boolean serial = false;
        IKDValue value = request.getProperties().getPropertyValue("CONTROL_SERIAL");
        if (value != null) {
            serial = Boolean.parseBoolean(value.getString());
        }
        boolean hasCompareViewValue = false;
        boolean check = true;
        try {
            this.getStats().addInfo("begin-calc-tasks.");
            if (serial || tasks.size() == 1) {
                int in = tasks.size();
                for (int i = 0; i < in; ++i) {
                    CubeDataResult result = tasks.get(i).call();
                    if (result.getResult() == 1) {
                        view.addCells(result.getCells());
                        continue;
                    }
                    check = false;
                }
            } else if (tasks.size() > 1) {
                LinkedList<Future> futures = new LinkedList<Future>();
                int batchSize = 12;
                LinkedList groupTasks = Lists.newLinkedList();
                ArrayList batchTasks = Lists.newArrayListWithCapacity((int)batchSize);
                for (Callable<CubeDataResult> task : tasks) {
                    batchTasks.add(task);
                    if (batchTasks.size() < batchSize) continue;
                    groupTasks.add(batchTasks);
                    batchTasks = Lists.newArrayListWithCapacity((int)batchSize);
                }
                if (!batchTasks.isEmpty()) {
                    groupTasks.add(batchTasks);
                }
                for (List batch : groupTasks) {
                    Future future;
                    futures.clear();
                    CountDownLatch cdl = new CountDownLatch(batch.size());
                    for (Callable task : batch) {
                        ((AbstractQueryBase)task).setCdl(cdl);
                        future = OlapThreadPools.getFixOlapQueryPool().submit(task);
                        if (future == null) continue;
                        futures.add(future);
                    }
                    cdl.await();
                    int in = futures.size();
                    for (int i = 0; i < in; ++i) {
                        future = (Future)futures.get(i);
                        if (future == null) continue;
                        CubeDataResult result = (CubeDataResult)future.get();
                        if (result.getResult() == 1) {
                            view.addCells(result.getCells());
                            continue;
                        }
                        check = false;
                    }
                }
            }
            this.getStats().add("end-calc-tasks.");
            hasCompareViewValue = check;
            boolean hasSave = PropertyUtils.isSaveData(request.getProperties());
            if (isDetail && hasSave) {
                this.getStats().addInfo("begin-save-cells.");
                IKDProperties properties = request.getProperties();
                properties.setPropertyValue("IGNORE_SAVE_CALC", KDValue.valueOf(Boolean.FALSE.toString()));
                properties.setPropertyValue("IGNORE_SAVE_TEXT", KDValue.valueOf(Boolean.TRUE.toString()));
                properties.setPropertyValue("IGNORE_PERM_SAVE", KDValue.valueOf(Boolean.TRUE.toString()));
                properties.setPropertyValue("IGNORE_DATA_LOCK", KDValue.valueOf(Boolean.TRUE.toString()));
                properties.setPropertyValue("traceId", KDValue.valueOf(JSON.toJSONString((Object)ShrekIdCodeUtils.getDefaultIdCodes((String)request.getId(), (LogStats)this.getStats()))));
                IOlapData olapData = request.from(request.getOlapQuery(), view.getCells());
                if (hasCompareViewValue) {
                    OlapUtils.compareValue(olapData, request.getView(), this.getStats());
                }
                CubeDataAgent.get().save(cube, olapData, properties, this.getViewIds(request));
                this.getStats().add("end-save-cells.");
            }
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("budget-olap-log : ", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u805a\u96c6\u5931\u8d25\u201c%1\u201d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KDDataQuery_1", (String)"epm-eb-olap", (Object[])new Object[]{ex.getMessage()}));
        }
    }
}

