/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.algo.olap.MdxResult;
import kd.epm.eb.algo.olap.MemberScope;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.MemberScopeImpl;
import kd.epm.eb.algo.olap.util.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.query.kd.mdx.IMdxStrategy;
import kd.epm.eb.olap.impl.query.kd.mdx.MdxStrategy;
import kd.epm.eb.olap.impl.query.kd.mdx.MdxUtils;
import kd.epm.eb.olap.impl.query.kd.param.ParamManager;
import kd.epm.eb.olap.impl.query.kd.rst.IKDOlapResult;
import kd.epm.eb.olap.impl.query.kd.rst.KDOlapResult;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractDataQueryBase;
import kd.epm.eb.olap.impl.utils.OlapUtils;
import kd.epm.eb.olap.impl.utils.OptimizeUtils;
import kd.epm.eb.olap.impl.utils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class KDDataQueryThread
extends AbstractDataQueryBase {
    private IMdxStrategy mdxStrategy = null;
    private IKDOlapResult result = null;
    private HashMap<String, String> short2Number = new HashMap(16);
    private Map<String, String> requestMdx = new HashMap<String, String>(16);

    public KDDataQueryThread(QueryParameter parameter, IKDCube cube, IKDOlapRequest request, ParamManager paramManager) {
        super(parameter, cube, request, paramManager);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected CubeDataResult doQuery() {
        CubeDataResult result = new CubeDataResult();
        result.setResult(9);
        if (this.getParameter() == null || this.getCube() == null) {
            this.getParameter().getStats().add("parameter or cube or modelCache is null.");
            return result;
        }
        if (this.getRequest() == null || this.getRequest().getOlapQuery() == null || this.getRequest().getOlapQuery().getQueries().isEmpty()) {
            this.getParameter().getStats().add("request or olapQuery or queries is null.");
            return result;
        }
        IOlapQuery olapQuery = this.getRequest().getOlapQuery();
        Map<String, Connection> dsCubes = null;
        Connection olapConn = null;
        String mdx = null;
        try {
            this.optimize();
            this.getParameter().getStats().add("end optimize.");
            olapConn = this.openConnection();
            olapConn.setId(this.getRequest().getId());
            boolean isCalc = PropertyUtils.isCalcBizRule(this.getRequest().getProperties());
            if (isCalc) {
                dsCubes = this.getDatasetCube(this.getRequest());
                this.setRefDsCubes(olapConn, dsCubes);
                this.getParameter().getStats().add("end openConnection.");
            } else {
                this.getParameter().getStats().addInfo("ignore calc rule.");
            }
            boolean check = true;
            int in = olapQuery.getQueries().size();
            for (int i = 0; i < in; ++i) {
                IKDQuery query = olapQuery.getQueries().get(i);
                mdx = this.getMdxStrategy().transMdx(this.getParameter(), query, olapQuery.getRelation());
                if (mdx != null) {
                    this.getParameter().getStats().add("mdx = " + mdx);
                    Set<String> refCurrOrg = olapQuery.getRelation().getRefCurrOrg(this.getParameter(), this.getRequest().getRefMemberByCalc(this.getCube(), false));
                    MdxResult rst = olapConn.executeMdxQuery(mdx, (List[])olapQuery.getRelation().getFilter(refCurrOrg, query, !this.getParamConfig().hasOptimizeEntity(), this.getParameter().getStats()));
                    result.getCells().addAll(this.getResult().transRst(rst));
                    continue;
                }
                check = false;
            }
            if (check) {
                result.setResult(1);
            }
            this.closeCube(olapConn, dsCubes);
            return result;
        }
        catch (KDBizException ex) {
            try {
                throw ex;
                catch (OlapException ex2) {
                    KDDataQueryThread.getLog().error("budget-olap-log : ", (Throwable)ex2);
                    KDDataQueryThread.getLog().error("budget-olap-log : " + mdx);
                    throw new KDBizException(new ErrorCode("EB040003", ex2.getMessage()), new Object[0]);
                }
                catch (StackOverflowError ex3) {
                    KDDataQueryThread.getLog().error("budget-olap-log : ", (Throwable)ex3);
                    List collect = olapQuery.getFormulas().stream().map(RuleDto::getNumber).collect(Collectors.toList());
                    StringBuilder error = new StringBuilder();
                    error.append("budget-olap-log : ").append(StringUtils.join(collect, (char)','));
                    KDDataQueryThread.getLog().error(error.toString());
                    throw new KDBizException(new ErrorCode("EB040100", ResManager.loadKDString((String)"\u5b58\u5728\u8fed\u4ee3\u4f9d\u8d56\u5bfc\u81f4\u7684\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u62a5\u8868\u5173\u8054\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u201c%1\u201d\u3002", (String)"KDDataQueryThread_1", (String)"epm-eb-olap", (Object[])new Object[0])), new Object[0]);
                }
            }
            catch (Throwable throwable) {
                this.closeCube(olapConn, dsCubes);
                throw throwable;
            }
        }
    }

    @Override
    public IMdxStrategy getMdxStrategy() {
        if (this.mdxStrategy == null) {
            this.mdxStrategy = this.createMdxStrategy();
        }
        return this.mdxStrategy;
    }

    protected IMdxStrategy createMdxStrategy() {
        return new MdxStrategy(this.getCube(), this.getRequest().getProperties(), this.getParamConfig());
    }

    @Override
    public IKDOlapResult getResult() {
        if (this.result == null) {
            this.result = this.createOlapResult();
        }
        return this.result;
    }

    protected IKDOlapResult createOlapResult() {
        return new KDOlapResult(this.getParamConfig(), this.getRequest());
    }

    protected void setRefDsCubes(Connection conn, Map<String, Connection> dsCubes) {
        if (conn == null || dsCubes == null || dsCubes.isEmpty()) {
            return;
        }
        Long _datasetId = this.getRequest().getOlapQuery().getDatasetId();
        DynamicObject dataset = BusinessDataServiceHelper.loadSingleFromCache((Object)_datasetId, (String)"eb_dataset");
        dsCubes.put(dataset.getString("number"), conn);
    }

    protected Map<String, Connection> getDatasetCube(IKDOlapRequest request) {
        Hashtable<String, Connection> datasetCubes = new Hashtable<String, Connection>();
        if (request == null || request.getOlapQuery() == null) {
            return datasetCubes;
        }
        String tableStr = this.getParamConfig().getParamValue("DATA_FACT_TABLES");
        Map allTables = (Map)JSONUtils.parse((String)tableStr, Map.class);
        Set datasetIds = allTables.keySet();
        datasetIds.remove(String.valueOf(request.getOlapQuery().getDatasetId()));
        if (!datasetIds.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)request.getCubeId()));
            List collect = datasetIds.stream().map(Long::valueOf).collect(Collectors.toList());
            builder.add(new QFilter("id", "in", collect));
            Map datasets = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id, number", (QFilter[])builder.toArrays());
            for (DynamicObject dataset : datasets.values()) {
                datasetCubes.put(dataset.getString("number"), this.openConnection(dataset.getLong("id")));
                this.getParameter().getStats().add("openConnection-" + dataset.getString("number"));
            }
        }
        return datasetCubes;
    }

    protected void closeCube(Connection conn, Map<String, Connection> dsCubes) {
        if (dsCubes != null) {
            for (Connection cube : dsCubes.values()) {
                try {
                    if (cube == null) continue;
                    cube.close();
                }
                catch (OlapException ex) {
                    KDDataQueryThread.getLog().error("budget-olap-log : ", (Throwable)ex);
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (OlapException ex) {
                KDDataQueryThread.getLog().error("budget-olap-log : ", (Throwable)ex);
            }
        }
    }

    @Override
    protected void calcRule(Connection conn, Map<String, Connection> dsCubes) {
    }

    private LeafFeature getFeature(LeafFeature feature) {
        if (!this.getParameter().isLeaf() && LeafFeature.NOTLEAF == feature) {
            feature = LeafFeature.ALL;
        }
        return feature;
    }

    private MemberScope rebuildScope(MemberScope scope) {
        if (scope == null || scope.getMemberExpressions() == null) {
            return null;
        }
        MemberScopeImpl memberScope = new MemberScopeImpl(scope.getName());
        for (Pair pair : scope.getMemberExpressions()) {
            memberScope.addPair((String)pair.getValue0(), (String)pair.getValue1());
        }
        return memberScope;
    }

    private String reBuildExpress(Map<String, Pair<Long, Long>> viewAlignMap, RuleDto expr) {
        String express = expr.getMdxRight();
        if (StringUtils.isEmpty((String)express)) {
            return "";
        }
        IKDValue value = null;
        String mdxNumber = null;
        String replaseNumber3 = null;
        List<Dimension> dimensions = this.getRequest().getOlapQuery().getUseDimensions();
        for (Dimension dimension : dimensions) {
            if (this.getParamConfig().hasOptimizeDimensionBySN(dimension.getShortNumber()) && (value = this.getParamConfig().getProperties().getPropertyValue("DEF_MEMBER_MDX_NUM_" + dimension.getNumber())) != null && value.isString()) {
                mdxNumber = value.getString();
                String replaseNumber1 = "" + ',' + '`' + dimension.getShortNumber() + '`' + '.' + mdxNumber;
                String replaseNumber2 = "\\*" + '`' + dimension.getShortNumber() + '`' + '.' + mdxNumber;
                replaseNumber3 = '`' + dimension.getShortNumber() + '`' + '.' + mdxNumber + ',';
                express = express.replaceAll(replaseNumber1, "");
                express = express.replaceAll(replaseNumber2, "");
                express = express.replaceAll(replaseNumber3, "");
            }
            if (!viewAlignMap.containsKey(dimension.getNumber()) || !express.contains('`' + dimension.getShortNumber() + "`")) continue;
            return "$error";
        }
        return express;
    }

    protected boolean checkScopeHasEntityAndEntityRangeHasCurrentThreadEntity(RuleDto expr) {
        Map<String, Set<String>> leftRefMembers = expr.getLeftMembers();
        if (leftRefMembers == null) {
            return true;
        }
        Set<String> refEntitys = leftRefMembers.get(SysDimensionEnum.Entity.getNumber());
        if (refEntitys == null) {
            return true;
        }
        for (String refOrgUnit : this.getParameter().getRefOrgUnits()) {
            if (!refEntitys.contains(refOrgUnit)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFeatureWhileCurrentThreadEntityIsNotLeaf(LeafFeature feature) {
        if (feature == null) {
            return true;
        }
        return this.getParameter().isLeaf() || LeafFeature.LEAF != feature;
    }

    protected void replaceMdxRightWhileFunctionHasEntityDimension(RuleDto expr) {
        String mdxFormula = expr.getMdxRight();
        if (mdxFormula == null || expr.getFunctions() == null) {
            return;
        }
        HashMap<String, String> replateInfo = new HashMap<String, String>(16);
        StringBuilder stringBuilder = new StringBuilder();
        for (IRuleFunction iRuleFunction : expr.getFunctions()) {
            String dimNum;
            if (!iRuleFunction.getFunctionName().equals(RuleFunctionEnum.IsChild.getName()) || !(dimNum = (String)iRuleFunction.getValue(FunctionItemEnum.DIMENSIONLIST.getKey())).equals(SysDimensionEnum.Entity.getNumber())) continue;
            String membNum = (String)iRuleFunction.getValue(FunctionItemEnum.DIMEMBER.getKey());
            stringBuilder.append("IsAncestor(").append(dimNum).append('_').append(membNum).append(')');
            replateInfo.put(stringBuilder.toString(), "1<0");
            stringBuilder.setLength(0);
        }
        if (!replateInfo.isEmpty()) {
            for (Map.Entry entry : replateInfo.entrySet()) {
                mdxFormula = mdxFormula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            expr.setMdxRight(mdxFormula);
        }
    }

    protected MemberScope filterScopeNew(RuleDto expr, MemberScope memberScope, String mdxRight, Map<String, Map<String, Set<String>>> rightMembers) {
        if (memberScope == null || memberScope.getMemberExpressions() == null || memberScope.getMemberExpressions().isEmpty() || StringUtils.isEmpty((String)mdxRight)) {
            return memberScope;
        }
        boolean rightIsNotMember = false;
        if (rightMembers.isEmpty()) {
            rightIsNotMember = true;
        }
        Pair scope = null;
        List memberExpressions = memberScope.getMemberExpressions();
        Iterator scopes = memberExpressions.iterator();
        Map<String, Set<String>> refMember = this.getRequest().getRefMember();
        IModelCacheHelper modelCache = this.getCube().getModelCache();
        HashMap<String, String> short2Number = this.getShortNumber(refMember);
        HashSet<String> dimNumbers = new HashSet<String>(refMember.keySet());
        while (scopes.hasNext()) {
            scope = (Pair)scopes.next();
            String dimShortNumber = (String)scope.getValue0();
            String dimNumber = (String)short2Number.get(dimShortNumber);
            dimNumbers.remove(dimNumber);
            if (SysDimensionEnum.Entity.getShortNumber().equals(dimShortNumber)) {
                scopes.remove();
                continue;
            }
            if (!this.getParamConfig().hasOptimizeDimensionBySN(dimShortNumber)) continue;
            scopes.remove();
        }
        Map<String, Set<String>> leftMembers = expr.getLeftMembers();
        Set<String> entitys = leftMembers.get(SysDimensionEnum.Entity.getNumber());
        if (CollectionUtils.isNotEmpty(entitys)) {
            Set<String> refOrgUnits = this.getParameter().getRefOrgUnits();
            Sets.SetView intersection = Sets.intersection(entitys, refOrgUnits);
            memberExpressions.add(new Pair((Object)SysDimensionEnum.Entity.getShortNumber(), (Object)this.getScopeValue1(SysDimensionEnum.Entity.getShortNumber(), (Collection<String>)intersection)));
        }
        for (String dimNumber : dimNumbers) {
            Dimension dimension = modelCache.getDimension(dimNumber);
            String shortNumber = dimension.getShortNumber();
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || this.getParamConfig().hasOptimizeDimension(dimNumber) || !this.mdxRightHasDimension(mdxRight, shortNumber) && !rightIsNotMember) continue;
            memberExpressions.add(new Pair((Object)shortNumber, (Object)this.getRequestMDX(dimNumber)));
        }
        return memberScope;
    }

    private boolean mdxRightHasDimension(String mdxRight, String shortNumber) {
        String _dimShortNum = OlapUtils.handlerDimShortNum(shortNumber);
        return mdxRight.contains(_dimShortNum);
    }

    private HashMap<String, String> getShortNumber(Map<String, Set<String>> refMember) {
        if (this.short2Number.isEmpty()) {
            IModelCacheHelper modelCache = this.getCube().getModelCache();
            for (String dimNumber : refMember.keySet()) {
                Dimension dimension = modelCache.getDimension(dimNumber);
                String shortNumber = dimension.getShortNumber();
                this.short2Number.put(shortNumber, dimNumber);
            }
        }
        return this.short2Number;
    }

    private String getRequestMDX(String dimNumber) {
        return this.requestMdx.computeIfAbsent(dimNumber, v -> {
            if (dimNumber.equals(SysDimensionEnum.Entity.getNumber())) {
                Set<String> refOrgUnits = this.getParameter().getRefOrgUnits();
                IModelCacheHelper modelCache = this.getCube().getModelCache();
                String dimShortNumber = modelCache.getDimension(dimNumber).getShortNumber();
                return this.getScopeValue1(dimShortNumber, refOrgUnits);
            }
            IKDOlapRequest request = this.getRequest();
            IModelCacheHelper modelCache = this.getCube().getModelCache();
            String dimShortNumber = modelCache.getDimension(dimNumber).getShortNumber();
            Map<String, String> defaultMembers = KDOlapResult.getDefaultMemberMap(this.getRequest(), this.getParamConfig());
            String defaultMember = defaultMembers.get(dimShortNumber);
            if (StringUtils.isNotEmpty((String)defaultMember)) {
                return this.getScopeValue1(dimShortNumber, Lists.newArrayList((Object[])new String[]{defaultMember}));
            }
            Set<String> periods = request.getRefMember().get(dimNumber);
            return this.getScopeValue1(dimShortNumber, periods);
        });
    }

    private String getScopeValue1(String dimShortNumber, Collection<String> periods) {
        StringBuilder mdxStr = new StringBuilder();
        String _dimShortNum = OlapUtils.handlerDimShortNum(dimShortNumber);
        mdxStr.append('{');
        for (String number : periods) {
            MdxUtils.appendMember(mdxStr, _dimShortNum, number);
        }
        mdxStr.setLength(mdxStr.length() - 1);
        mdxStr.append('}');
        return mdxStr.toString();
    }

    @Override
    protected void optimize() {
        OptimizeUtils.get().optimizeParam(this.getParameter(), this.getRequest(), this.getParamConfig(), this.getCube());
    }
}

