/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractQueryBase;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;
import org.jetbrains.annotations.NotNull;

public class KDOtherDataQueryThread
extends AbstractQueryBase {
    public KDOtherDataQueryThread(QueryParameter parameter, IKDCube cube, IKDOlapRequest request) {
        super(parameter, cube, request);
    }

    @Override
    @NotNull
    public CubeDataResult call() throws Exception {
        CubeDataResult result;
        try {
            result = this.doQuery();
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
        finally {
            if (this.getCdl() != null) {
                this.getCdl().countDown();
            }
            this.getParameter().getStats().addInfo("end olap query thread.");
            KDOtherDataQueryThread.getLog().info(this.getParameter().getStats().toString());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected CubeDataResult doQuery() {
        CubeDataResult result = new CubeDataResult();
        result.setResult(9);
        String tableName = OlapTableUtils.getOtherTableName(this.getRequest().getOlapQuery().getDatasetId());
        if (!this.hasTable(tableName)) {
            return result;
        }
        this.getParameter().getStats().addInfo("begin olap query thread. requestId = " + this.getRequest().getId());
        List<kd.epm.eb.common.cache.impl.Dimension> dimensions = this.getRequest().getOlapQuery().getUseDimensions();
        Map<String, Set<String>> memberMap = this.getRequestMember();
        if (memberMap == null) return result;
        if (memberMap.isEmpty()) {
            return result;
        }
        Long viewId = null;
        String field = null;
        String dataType = null;
        String[] metas = null;
        Set<String> numbers = null;
        IKDCell cell = null;
        IKDValue value = null;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid", new Object[0]);
        for (kd.epm.eb.common.cache.impl.Dimension dimension : dimensions) {
            field = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.cache.impl.Dimension)dimension) ? 'f' + dimension.getFieldMapped() : (String)OlapConstant.getFieldMap().get(dimension.getNumber());
            sql.append(",", new Object[0]).append(field, new Object[0]);
        }
        sql.append(", fdata, fdatatype from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]);
        boolean first = true;
        for (kd.epm.eb.common.cache.impl.Dimension dimension : dimensions) {
            numbers = memberMap.get(dimension.getNumber());
            if (numbers == null || numbers.isEmpty()) continue;
            field = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.cache.impl.Dimension)dimension) ? 'f' + dimension.getFieldMapped() : (String)OlapConstant.getFieldMap().get(dimension.getNumber());
            if (first) {
                first = false;
            } else {
                sql.append(" and ", new Object[0]);
            }
            viewId = this.getRequest().getOlapQuery().getViews().get(dimension.getNumber());
            sql.appendIn(field, dimension.getMemberId(viewId, numbers).toArray());
        }
        try (DataSet dataSet = DB.queryDataSet((String)"queryOtherData", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            kd.epm.eb.common.cache.impl.Dimension dimension = null;
            kd.epm.eb.common.cache.impl.Member member = null;
            Iterator iterator = dataSet.iterator();
            while (true) {
                block34: {
                    int in;
                    Row row;
                    if (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        metas = new String[dimensions.size()];
                        in = dimensions.size();
                    } else {
                        result.setResult(1);
                        return result;
                    }
                    for (int i = 0; i < in; ++i) {
                        dimension = dimensions.get(i);
                        member = dimension.getMember(viewId = this.getRequest().getOlapQuery().getViews().get(dimension.getNumber()), row.getLong(i + 1));
                        if (member == null) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9aID\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"KDOtherDataQueryThread_0", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName(), row.getString(i + 1)}));
                        }
                        metas[i] = member.getNumber();
                    }
                    dataType = row.getString("fdatatype");
                    try {
                        if (MetricDataTypeEnum.TEXT.getIndex().equals(dataType)) {
                            value = KDValue.valueOf(row.getString("fdata"));
                            break block34;
                        }
                        if (MetricDataTypeEnum.DATE.getIndex().equals(dataType)) {
                            value = KDValue.valueOf(row.getDate("fdata"));
                        } else if (!MetricDataTypeEnum.ENUM.getIndex().equals(dataType)) {
                            // empty if block
                        }
                    }
                    catch (Throwable ex) {
                        this.getParameter().getStats().addInfo("data trans error" + ex.getMessage());
                    }
                }
                cell = KDCell.of(metas);
                cell.setValue(value);
                result.getCells().add(cell);
            }
        }
        catch (Exception exception) {
            KDOtherDataQueryThread.getLog().error("budget-olap-log : ", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        finally {
            this.getParameter().getStats().addInfo("end olap query thread.");
            KDOtherDataQueryThread.getLog().info(this.getParameter().getStats().toString());
        }
    }

    protected Map<String, Set<String>> getRequestMember() {
        kd.epm.eb.common.cache.impl.Dimension metric = this.getCube().getModelCache().getDimension(SysDimensionEnum.Metric.getNumber());
        if (metric == null) {
            return null;
        }
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)32);
        Set numbers = null;
        kd.epm.eb.common.cache.impl.Member member = null;
        for (IKDQuery query : this.getRequest().getOlapQuery().getQueries()) {
            for (Dimension dimension : query.getDimension()) {
                numbers = memberMap.computeIfAbsent(dimension.getNumber(), k -> Sets.newLinkedHashSetWithExpectedSize((int)100));
                if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                    for (Member _member : dimension.getMembers()) {
                        member = metric.getMember(_member.getId());
                        if (member == null || !MetricDataTypeEnum.TEXT.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.DATE.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.ENUM.getIndex().equals(member.getDatatype())) continue;
                        numbers.add(_member.getNumber());
                    }
                    continue;
                }
                for (Member _member : dimension.getMembers()) {
                    numbers.add(_member.getNumber());
                }
            }
        }
        return memberMap;
    }

    protected boolean hasTable(String tableName) {
        return SqlBatchUtils.hasTable((String)tableName);
    }
}

