/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.mdx;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IRelation;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.query.kd.mdx.IMdxStrategy;
import kd.epm.eb.olap.impl.query.kd.mdx.MdxUtils;
import kd.epm.eb.olap.impl.query.kd.param.IParamConfig;
import kd.epm.eb.olap.impl.query.param.QueryParameter;

public class MdxStrategy
implements IMdxStrategy {
    private IKDCube cube = null;
    private IKDProperties properties = null;
    private IParamConfig paramConfig = null;

    protected IKDCube getCube() {
        return this.cube;
    }

    protected IKDProperties getProperties() {
        return this.properties;
    }

    protected IParamConfig getParamConfig() {
        return this.paramConfig;
    }

    public MdxStrategy(IKDCube cube, IKDProperties properties, IParamConfig paramConfig) {
        this.cube = cube;
        this.properties = properties;
        this.paramConfig = paramConfig;
    }

    @Override
    public String transMdx(QueryParameter parameter, IKDQuery query) {
        return this.transMdx(parameter, query, null);
    }

    @Override
    public String transMdx(QueryParameter parameter, IKDQuery query, IRelation relation) {
        if (parameter == null || this.getCube() == null || query == null || this.getParamConfig() == null) {
            return null;
        }
        Axis axis = this.getAxis(query, relation);
        List<Dimension> rows = axis.getRows();
        List<Dimension> cols = axis.getCols();
        List<Dimension> filters = axis.getFilters();
        StringBuilder mdx = new StringBuilder();
        boolean hasRelation = relation.hasRelation();
        if (hasRelation) {
            mdx.append(" SELECT NON EMPTY ");
        } else {
            mdx.append(" SELECT ");
        }
        MdxUtils.appendSet(mdx, cols);
        mdx.append(" * ");
        MdxUtils.appendMeasures(mdx);
        if (hasRelation) {
            mdx.append(" ON COLUMNS, NON EMPTY ");
        } else {
            mdx.append(" ON COLUMNS,");
        }
        MdxUtils.appendSet(mdx, rows);
        mdx.append(" ON ROWS from BudgetCube");
        if (filters != null && !filters.isEmpty()) {
            StringBuilder where = new StringBuilder();
            MdxUtils.appendTuple(where, filters);
            if (where.length() > 0) {
                mdx.append(" where ").append((CharSequence)where);
            }
        }
        return mdx.toString();
    }

    private Axis getAxis(IKDQuery query, IRelation relation) {
        ArrayList<Dimension> tmpList;
        Axis axis = new Axis();
        for (Dimension dimension : query.getDimension()) {
            if (this.getParamConfig().hasOptimizeDimension(dimension.getNumber())) continue;
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                dimension.setTreeModel(false);
            }
            Set<String> rowDims = relation.getRowDims();
            Set<String> colDims = relation.getColDims();
            if (rowDims != null && rowDims.contains(dimension.getShortNumber())) {
                axis.getRows().add(dimension);
                continue;
            }
            if (colDims != null && colDims.contains(dimension.getShortNumber())) {
                axis.getCols().add(dimension);
                continue;
            }
            if (dimension.getMembers().size() == 1) {
                axis.getFilters().add(dimension);
                continue;
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                if (rowDims != null && !rowDims.isEmpty()) {
                    axis.getCols().add(dimension);
                    continue;
                }
                axis.getRows().add(dimension);
                continue;
            }
            axis.getCols().add(dimension);
        }
        Dimension dimension = null;
        if (axis.getRows().isEmpty() && !axis.getFilters().isEmpty()) {
            tmpList = new ArrayList<Dimension>();
            int in = axis.getFilters().size();
            for (int i = 0; i < in; ++i) {
                dimension = axis.getFilters().get(i);
                if (axis.getRows().isEmpty()) {
                    axis.getRows().add(dimension);
                    continue;
                }
                tmpList.add(dimension);
            }
            axis.getFilters().clear();
            axis.getFilters().addAll(tmpList);
        }
        if (axis.getCols().isEmpty() && !axis.getFilters().isEmpty()) {
            tmpList = new ArrayList();
            int in = axis.getFilters().size();
            for (int i = 0; i < in; ++i) {
                dimension = axis.getFilters().get(i);
                if (axis.getCols().isEmpty()) {
                    axis.getCols().add(dimension);
                    continue;
                }
                tmpList.add(dimension);
            }
            axis.getFilters().clear();
            axis.getFilters().addAll(tmpList);
        }
        if (axis.getRows().isEmpty() && axis.getCols().size() > 1) {
            axis.getRows().add(axis.getCols().remove(axis.getCols().size() - 1));
        }
        if (axis.getRows().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"OlAP\u67e5\u8be2\u9519\u8bef\uff0cMDX\u6784\u9020\u9519\u8bef\uff0c\u884c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MdxStrategy_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (axis.getCols().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u67e5\u8be2\u9519\u8bef\uff0cMDX\u6784\u9020\u9519\u8bef\uff0c\u5217\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MdxStrategy_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        return axis;
    }

    public static class Axis {
        private List<Dimension> rows = new LinkedList<Dimension>();
        private List<Dimension> cols = new LinkedList<Dimension>();
        private List<Dimension> filters = new LinkedList<Dimension>();

        public void setRows(List<Dimension> rows) {
            this.rows = rows;
        }

        public List<Dimension> getRows() {
            return this.rows;
        }

        public void setCols(List<Dimension> cols) {
            this.cols = cols;
        }

        public List<Dimension> getCols() {
            return this.cols;
        }

        public void setFilters(List<Dimension> filters) {
            this.filters = filters;
        }

        public List<Dimension> getFilters() {
            return this.filters;
        }
    }
}

