/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.mdx;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class MdxUtils {
    public static String getDimensionTag(Dimension dimension) {
        return "`" + dimension.getShortNumber() + "`";
    }

    public static void appendSet(StringBuilder mdx, List<Dimension> mbgDims) {
        if (mdx == null || mbgDims == null || mbgDims.isEmpty()) {
            return;
        }
        Dimension mbgDim = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (mbgDim.getMembers().isEmpty()) continue;
            MdxUtils.appendSet(mdx, mbgDim);
            mdx.append(" * ");
        }
        if (mdx.length() > 0 && " * ".equals(mdx.substring(mdx.length() - 3, mdx.length()))) {
            mdx.setLength(mdx.length() - 3);
        }
    }

    public static void appendSet(StringBuilder mdx, Dimension mbgDim) {
        if (mdx == null || mbgDim == null || mbgDim.getMembers().isEmpty()) {
            return;
        }
        Member member = null;
        HashSet mdxSet = Sets.newHashSetWithExpectedSize((int)mbgDim.getMembers().size());
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(mbgDim.getNumber())) {
            List<Member> sortMembers = MdxUtils.sortMembersByBp(mbgDim.getMembers());
            mbgDim.setMembers(sortMembers);
        }
        String dimHeadStr = MdxUtils.getDimensionTag(mbgDim);
        mdx.append('{');
        int in = mbgDim.getMembers().size();
        for (int i = 0; i < in; ++i) {
            member = (Member)mbgDim.getMembers().get(i);
            if (!mdxSet.add(member.getNumber())) continue;
            MdxUtils.appendMember(mdx, dimHeadStr, member);
            mdx.append(',');
        }
        if (mdx.length() > 0) {
            mdx.setLength(mdx.length() - 1);
        }
        mdx.append('}');
    }

    private static List<Member> sortMembersByBp(List<Member> members) {
        List memberNumbers = members.stream().map(Member::getNumber).collect(Collectors.toList());
        HashMap<Long, String> bgMap = new HashMap<Long, String>(16);
        String format = "yyyy-MM-dd";
        HashSet<String> unSortMember = new HashSet<String>();
        for (String memberNumber : memberNumbers) {
            if (!memberNumber.startsWith("FY")) {
                unSortMember.add(memberNumber);
                continue;
            }
            try {
                Date d;
                String dateStr;
                String year = memberNumber.substring(2, 6);
                String suffix = "";
                if (StringUtils.contains((CharSequence)memberNumber, (CharSequence)".")) {
                    suffix = memberNumber.substring(7);
                }
                if (StringUtils.isBlank((CharSequence)suffix)) {
                    dateStr = year + "-12-31";
                    d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                    bgMap.put(d.getTime(), memberNumber);
                    continue;
                }
                if (suffix.startsWith("HF1")) {
                    dateStr = year + "-06-30";
                    d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                    bgMap.put(d.getTime(), memberNumber);
                    continue;
                }
                if (suffix.startsWith("HF2")) {
                    dateStr = year + "-12-30";
                    d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                    bgMap.put(d.getTime(), memberNumber);
                    continue;
                }
                if (suffix.startsWith("Q1")) {
                    dateStr = year + "-03-15";
                    try {
                        d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                        bgMap.put(d.getTime(), memberNumber);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (suffix.startsWith("Q2")) {
                    dateStr = year + "-06-15";
                    d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                    bgMap.put(d.getTime(), memberNumber);
                    continue;
                }
                if (suffix.startsWith("Q3")) {
                    dateStr = year + "-09-15";
                    try {
                        d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                        bgMap.put(d.getTime(), memberNumber);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (suffix.startsWith("Q4")) {
                    dateStr = year + "-12-15";
                    d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                    bgMap.put(d.getTime(), memberNumber);
                    continue;
                }
                dateStr = year + "-" + memberNumber.substring(8) + "-01";
                d = DateUtils.parseDate((String)dateStr, (String[])new String[]{format});
                bgMap.put(d.getTime(), memberNumber);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        List sortBp = bgMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<Member> sortMembers = new ArrayList<Member>(16);
        block7: for (String s : sortBp) {
            for (Member member : members) {
                if (!s.equals(member.getNumber())) continue;
                sortMembers.add(member);
                continue block7;
            }
        }
        block9: for (String s : unSortMember) {
            for (Member member : members) {
                if (!s.equals(member.getNumber())) continue;
                sortMembers.add(member);
                continue block9;
            }
        }
        return sortMembers;
    }

    public static void appendTuple(StringBuilder mdx, List<Dimension> mbgDims) {
        if (mdx == null || mbgDims == null || mbgDims.isEmpty()) {
            return;
        }
        Dimension mbgDim = null;
        Member member = null;
        String dimHeadStr = null;
        StringBuilder _mdx = new StringBuilder();
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (mbgDim.getMembers().size() != 1 || (member = (Member)mbgDim.getMembers().get(0)) == null || member.isIgnore()) continue;
            dimHeadStr = MdxUtils.getDimensionTag(mbgDim);
            MdxUtils.appendMember(_mdx, dimHeadStr, member);
            _mdx.append(',');
        }
        if (_mdx.length() > 0) {
            _mdx.setLength(_mdx.length() - 1);
        }
        if (_mdx.length() > 0) {
            mdx.append('(').append((CharSequence)_mdx).append(')');
        }
    }

    public static void appendMember(StringBuilder mdx, String dimHeadStr, Member member) {
        if (mdx == null || dimHeadStr == null || member == null) {
            return;
        }
        int range = member.getRange();
        if (RangeEnum.ONLY.getIndex() == range) {
            mdx.append(dimHeadStr).append("->").append('`').append(member.getNumber()).append('`');
        } else if (RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == range) {
            mdx.append(dimHeadStr).append("->").append('`').append(member.getNumber()).append('`');
            mdx.append('.').append("Children");
        } else if (RangeEnum.DIRECTSUB.getIndex() == range) {
            mdx.append(dimHeadStr).append("->").append('`').append(member.getNumber()).append('`');
            mdx.append(',');
            mdx.append(dimHeadStr).append("->").append('`').append(member.getNumber()).append('`');
            mdx.append('.').append("Children");
        } else if (RangeEnum.ALL_EXCLUDE.getIndex() == range || RangeEnum.ALL.getIndex() == range || RangeEnum.PEERS_EXCLUDE.getIndex() == range || RangeEnum.PEERS.getIndex() == range || RangeEnum.ALL_DETAIL.getIndex() == range || RangeEnum.ALL_NOTDETAIL.getIndex() == range || RangeEnum.ANCESTOR.getIndex() == range || RangeEnum.ANCESTOR_EXCLUDE.getIndex() == range) {
            // empty if block
        }
    }

    public static void appendMember(StringBuilder mdx, String dimHeadStr, String memberNumber) {
        if (mdx == null || kd.epm.eb.common.utils.StringUtils.isEmpty((String)dimHeadStr) || kd.epm.eb.common.utils.StringUtils.isEmpty((String)memberNumber)) {
            return;
        }
        mdx.append(dimHeadStr).append("->").append('`').append(memberNumber).append('`').append(',');
    }

    public static void appendMember2(StringBuilder mdx, String dimHeadStr, String memberNumber) {
        if (mdx == null || kd.epm.eb.common.utils.StringUtils.isEmpty((String)dimHeadStr) || kd.epm.eb.common.utils.StringUtils.isEmpty((String)memberNumber)) {
            return;
        }
        mdx.append(dimHeadStr).append('.').append(memberNumber).append(',');
    }

    public static void appendMeasures(StringBuilder mdx) {
        if (mdx == null) {
            return;
        }
        mdx.append('{').append("measures").append('.').append("va").append('}');
    }
}

