/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.param;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.CustomizedInput;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.param.BgParamUtils;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.query.param.AbstractInput;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;

public class CubeDataInput
extends AbstractInput {
    private static final Log log = LogFactory.getLog(CubeDataInput.class);
    private String cacheId;
    private String sql;
    private Object[] sqlParams;
    private List<Object[]> dataSet;
    private RowMeta rowMeta;

    public CubeDataInput(Member orgMember, String cacheId, String sql, Object[] sqlParams, RowMeta rowMeta) {
        this.cacheId = cacheId;
        this.sql = sql;
        this.sqlParams = sqlParams;
        this.rowMeta = rowMeta;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public Iterator<Object[]> createIterator() {
        if (this.dataSet == null) {
            long begin = System.nanoTime();
            log.info("budget-olap-log : begin read cube data.");
            CachedDataSet cacheSet = null;
            try {
                cacheSet = Algo.getCacheDataSet((String)this.cacheId);
            }
            catch (AlgoException ex) {
                log.info("budget-olap-log : not find cacheDataSet. cacheId =" + this.cacheId);
            }
            if (cacheSet == null || cacheSet.getRowCount() == 0) {
                try (DataSet ds = DB.queryDataSet((String)"query cubeData", (DBRoute)DBRoute.of((String)"epm"), (String)this.sql, (Object[])this.sqlParams);){
                    CacheHint hint = new CacheHint();
                    hint.setCacheId(this.cacheId);
                    hint.setTimeout(8L, TimeUnit.HOURS);
                    cacheSet = ds.cache(hint);
                }
            } else {
                log.info("budget-olap-log : load from cacheId = " + this.cacheId + "; size =" + cacheSet.getRowCount());
            }
            Row row = null;
            Object[] obj = null;
            this.dataSet = new LinkedList<Object[]>();
            Iterator rows = cacheSet.iterator(0, cacheSet.getRowCount());
            while (rows.hasNext()) {
                row = (Row)rows.next();
                obj = new Object[this.rowMeta.getFieldCount()];
                int xn = this.rowMeta.getFieldCount();
                for (int x = 0; x < xn; ++x) {
                    obj[x] = row.get(this.rowMeta.getField(x).getName());
                }
                this.dataSet.add(obj);
            }
            long use = System.nanoTime() - begin;
            log.info("budget-olap-log : end read cube data. use=" + TimeUnit.NANOSECONDS.toMillis(use) + "ms.");
        }
        return this.dataSet.iterator();
    }

    public void close() {
        this.dataSet.clear();
        this.dataSet = null;
        this.rowMeta = null;
    }

    public static CustomizedInput of(Member orgMember, IKDCube cube, String factTable, RowMeta rowMeta) {
        if (orgMember == null || cube == null || factTable == null) {
            return null;
        }
        if (orgMember.isLeaf() || orgMember.getLevel() > CubeDataInput.getCacheLevel()) {
            return null;
        }
        String cacheId = CubeDataInput.getCacheId(cube.getId(), factTable, orgMember.getNumber());
        return new CubeDataInput(orgMember, cacheId, CubeDataInput.getQuerySql(orgMember, factTable, cube), new Object[]{orgMember.getId()}, rowMeta);
    }

    private static String getCacheId(String cubeId, String factTable, String orgUnitNum) {
        return cubeId + "!" + factTable + "!" + orgUnitNum;
    }

    public static int getCacheLevel() {
        return BgParamUtils.getCacheOrgLevel();
    }

    private static String getQuerySql(Member member, String factTable, IKDCube cube) {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        Dimension orgDim = cube.getModelCache().getDimension(SysDimensionEnum.Entity.getNumber());
        List dimensions = cube.getModelCache().getDimensionList();
        for (Dimension dimension : dimensions) {
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                sql.append("t.").append(dimension.getFieldMapped()).append(',');
                continue;
            }
            sql.append("t.").append((String)OlapConstant.getFieldMap().get(dimension.getNumber())).append(',');
        }
        sql.append("sum(t.fvalue) as fvalue");
        sql.append(" from ").append(factTable).append(" t ");
        sql.append(" join ").append(OlapTableUtils.getDimClosureTable(cube.getId(), orgDim, null)).append(" c on t.forgunitid = c.fchild ");
        sql.append(" where c.fid = ?");
        sql.append(" group by ");
        for (Dimension dimension : dimensions) {
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                sql.append("t.").append(dimension.getFieldMapped()).append(',');
                continue;
            }
            sql.append("t.").append((String)OlapConstant.getFieldMap().get(dimension.getNumber())).append(',');
        }
        sql.setLength(sql.length() - 1);
        return sql.toString();
    }

    public static void closeCacheSet(String cubeId, String factTable, String[] memberNums) {
        if (cubeId == null || factTable == null || memberNums == null || memberNums.length == 0) {
            return;
        }
        CachedDataSet cacheSet = null;
        int in = memberNums.length;
        for (int i = 0; i < in; ++i) {
            if (memberNums[i] == null) continue;
            try {
                cacheSet = Algo.getCacheDataSet((String)CubeDataInput.getCacheId(cubeId, factTable, memberNums[i]));
                if (cacheSet == null) continue;
                cacheSet.close();
                continue;
            }
            catch (AlgoException algoException) {
                // empty catch block
            }
        }
    }
}

