/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.param;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IMemberFilter;
import kd.epm.eb.olap.impl.query.kd.param.ParamConfig;
import kd.epm.eb.olap.impl.query.param.AbstractInput;
import kd.epm.eb.olap.impl.utils.OlapUtils;

public class DimensionMemberInput
extends AbstractInput {
    private static final long serialVersionUID = -3127537890433004085L;
    private List<Object[]> members = new ArrayList<Object[]>();
    private RowMeta rowMeta = null;

    public void setMembers(List<Object[]> members) {
        this.members = members;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Iterator<Object[]> createIterator() {
        return this.members.iterator();
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void close() {
    }

    protected RowMeta buildMeta(Dimension dimension) {
        ArrayList fields = Lists.newArrayListWithCapacity((int)10);
        fields.add(new Field("fid", this.getIdType()));
        fields.add(new Field("fnumber", (DataType)DataType.StringType));
        fields.add(new Field("fparent", this.getParentType()));
        if (ParamConfig.hasWeight(dimension)) {
            fields.add(new Field("fweight", (DataType)DataType.IntegerType));
        } else if (ParamConfig.hasAggregate(dimension)) {
            fields.add(new Field("faggregate", (DataType)DataType.IntegerType));
        } else if (ParamConfig.hasProperty(dimension)) {
            fields.add(new Field("fbptype", (DataType)DataType.IntegerType));
        }
        return new RowMeta(fields.toArray(new Field[fields.size()]));
    }

    public Input of(IKDOlapRequest request, IKDCube cube, Dimension dimension, IMemberFilter filter, Map<String, Long> views) {
        List<Member> filters;
        this.setRowMeta(this.buildMeta(dimension));
        Long viewId = null;
        viewId = views != null ? views.get(dimension.getNumber()) : request.getOlapQuery().getViews().get(dimension.getNumber());
        View view = dimension.getView(viewId);
        List<Member> members = view != null ? view.getAllMembers() : dimension.getAllMembers(viewId);
        List<Member> list = filters = filter != null ? filter.filter(cube, dimension, view, members) : members;
        if (filters != null) {
            ArrayList<Object[]> allMembers = new ArrayList<Object[]>(filters.size());
            if (ParamConfig.hasWeight(dimension)) {
                for (Member member : filters) {
                    allMembers.add(new Object[]{this.getId(member), member.getNumber(), this.getParent(member), OlapUtils.getWeight(member)});
                }
            } else if (ParamConfig.hasAggregate(dimension)) {
                for (Member member : filters) {
                    allMembers.add(new Object[]{this.getId(member), member.getNumber(), this.getParent(member), OlapUtils.getAggregate(member)});
                }
            } else if (ParamConfig.hasProperty(dimension)) {
                for (Member member : filters) {
                    allMembers.add(new Object[]{this.getId(member), member.getNumber(), this.getParent(member), OlapUtils.getType(member)});
                }
            } else {
                for (Member member : filters) {
                    allMembers.add(new Object[]{this.getId(member), member.getNumber(), this.getParent(member)});
                }
            }
            this.setMembers(allMembers);
        }
        return this;
    }

    protected Object getId(Member member) {
        return member.getId();
    }

    protected DataType getIdType() {
        return DataType.LongType;
    }

    protected Object getParent(Member member) {
        return member.getParentId();
    }

    protected DataType getParentType() {
        return DataType.LongType;
    }
}

