/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.param;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IMemberFilter;
import kd.epm.eb.olap.impl.query.param.QueryParameter;

public class MemberFilter
implements IMemberFilter {
    private static final Log log = LogFactory.getLog(MemberFilter.class);
    private QueryParameter parameter = null;
    private IKDOlapRequest request = null;

    @Override
    public void setQueryParameter(QueryParameter parameter) {
        this.parameter = parameter;
    }

    protected QueryParameter getQueryParameter() {
        return this.parameter;
    }

    @Override
    public void setOlapRequest(IKDOlapRequest request) {
        this.request = request;
    }

    protected IKDOlapRequest getOlapRequest() {
        return this.request;
    }

    @Override
    public List<Member> filter(IKDCube cube, Dimension dimension, View view, List<Member> members) {
        if (cube == null || dimension == null || this.getOlapRequest() == null) {
            return members;
        }
        Set<String> calcMembers = this.getOlapRequest().getRefMemberByCalc(cube, true).get(dimension.getNumber());
        Set<String> refMembers = this.getOlapRequest().getRefMember().get(dimension.getNumber());
        if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            if (calcMembers != null && !calcMembers.isEmpty()) {
                members = this.filterOrgUnit(cube, dimension, view, members, calcMembers);
            }
        } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
            members = this.filterBudgetPeriod(cube, dimension, members, calcMembers);
        } else {
            LinkedHashSet<String> _refMembers = new LinkedHashSet<String>();
            if (refMembers != null && !refMembers.isEmpty()) {
                _refMembers.addAll(refMembers);
            }
            if (calcMembers != null && !calcMembers.isEmpty()) {
                _refMembers.addAll(calcMembers);
            }
            members = this.filterUserDefined(dimension, view, members, _refMembers);
        }
        return members;
    }

    protected List<Member> filterOrgUnit(IKDCube cube, Dimension dimension, View view, List<Member> members, Set<String> refMembers) {
        if (cube == null || dimension == null || members == null || refMembers == null || refMembers.isEmpty()) {
            return members;
        }
        LinkedHashSet<String> tmpSet = new LinkedHashSet<String>();
        Member member = null;
        LinkedList<Member> filter = new LinkedList<Member>();
        if (view != null) {
            for (String orgNumber : this.getQueryParameter().getRefOrgUnits()) {
                filter.add(view.getMember(orgNumber));
            }
        } else {
            for (String orgNumber : this.getQueryParameter().getRefOrgUnits()) {
                filter.add(dimension.getMember(orgNumber));
            }
        }
        tmpSet.addAll(this.getQueryParameter().getRefOrgUnits());
        for (String orgNumber : refMembers) {
            member = view != null ? view.getMember(orgNumber) : dimension.getMember(orgNumber);
            if (member == null || !tmpSet.add(member.getNumber())) continue;
            filter.add(member);
        }
        return filter;
    }

    protected List<Member> filterBudgetPeriod(IKDCube cube, Dimension dimension, List<Member> members, Set<String> refMembers) {
        int i;
        if (cube == null || dimension == null || members == null) {
            return members;
        }
        LinkedList<Member> filter = new LinkedList<Member>();
        Member member = null;
        LinkedHashSet periodSet = Sets.newLinkedHashSetWithExpectedSize((int)10);
        int max = 0;
        int min = 9999;
        int year = 0;
        if (this.getOlapRequest() != null) {
            Object query = null;
            int in = this.getOlapRequest().getOlapQuery().getQueries().size();
            for (int i2 = 0; i2 < in; ++i2) {
                query = this.getOlapRequest().getOlapQuery().getQueries().get(i2);
                Set<String> numbers = query.getMemberNums(SysDimensionEnum.BudgetPeriod.getNumber());
                if (numbers == null) continue;
                for (String number : numbers) {
                    try {
                        year = Integer.parseInt(number.substring(2, 6));
                        if (year > max) {
                            max = year;
                        }
                        if (min <= year) continue;
                        min = year;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (refMembers != null && !refMembers.isEmpty()) {
            for (String number : refMembers) {
                try {
                    year = Integer.parseInt(number.substring(2, 6));
                    if (year > max) {
                        max = year;
                    }
                    if (min <= year) continue;
                    min = year;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        for (i = min - 2; i <= max + 2; ++i) {
            periodSet.add(i);
        }
        int in = members.size();
        for (i = 0; i < in; ++i) {
            member = members.get(i);
            if (dimension.getNumber().equals(member.getNumber())) {
                filter.add(member);
                continue;
            }
            try {
                year = Integer.parseInt(member.getNumber().substring(2, 6));
                if (!periodSet.contains(year)) continue;
                filter.add(member);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Member> filterUserDefined(Dimension dimension, View view, List<Member> members, Set<String> refMembers) {
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin filter dimension member - " + dimension.getNumber());
        try {
            List<Member> filters = this.filterUserDefined(members, (AbstractTree)(view != null ? view : dimension), refMembers);
            if (filters != null) {
                List<Member> list = filters;
                return list;
            }
        }
        finally {
            stats.addInfo("end filter dimension member.");
            log.info(stats.toString());
        }
        return members;
    }

    private List<Member> filterUserDefined(List<Member> members, AbstractTree dimension, Set<String> refMembers) {
        if (members == null || dimension == null || refMembers == null) {
            return null;
        }
        Member member = null;
        ArrayList filters = Lists.newArrayListWithCapacity((int)members.size());
        HashSet filterSet = Sets.newHashSetWithExpectedSize((int)members.size());
        for (String memberNumber : refMembers) {
            member = dimension.getMember(memberNumber);
            if (member == null) continue;
            if (filterSet.add(member.getNumber())) {
                filters.add(member);
            }
            for (Member children : member.getAllMembers()) {
                if (children == null || !filterSet.add(children.getNumber())) continue;
                filters.add(children);
            }
            for (Member parent : dimension.getParents(memberNumber)) {
                if (parent == null || !filterSet.add(parent.getNumber())) continue;
                filters.add(parent);
            }
        }
        return filters;
    }
}

