/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.param;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IMemberFilter;
import kd.epm.eb.olap.impl.base.KDProperties;
import kd.epm.eb.olap.impl.query.kd.param.DimensionMemberInput;
import kd.epm.eb.olap.impl.query.kd.param.IParamCheck;
import kd.epm.eb.olap.impl.query.kd.param.IParamConfig;
import kd.epm.eb.olap.impl.query.kd.param.MemberFilter;
import kd.epm.eb.olap.impl.query.kd.param.ParamCheck;
import kd.epm.eb.olap.impl.query.kd.param.ParamManager;
import kd.epm.eb.olap.impl.query.param.DatasetParameter;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public class ParamConfig
implements IParamConfig {
    private static final Log log = LogFactory.getLog(ParamConfig.class);
    private ParamManager manager = null;
    public static final String FACT_NAME = "budgetFact";
    private Map schemaParams = new HashMap();
    private IParamCheck check = null;
    private IKDProperties properties = new KDProperties();
    private Map<String, Long> noneMemberIds = null;

    public static ParamConfig get(ParamManager manager) {
        return new ParamConfig(manager);
    }

    public ParamManager getManager() {
        return this.manager;
    }

    public ParamConfig(ParamManager manager) {
        this.manager = manager;
    }

    @Override
    public InputStream getSchema(QueryParameter parameter, DatasetParameter datasetParam) {
        String schema = this.buildScheme(parameter, datasetParam);
        if (schema == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        return new ByteArrayInputStream(schema.getBytes(StandardCharsets.UTF_8));
    }

    private String buildScheme(QueryParameter parameter, DatasetParameter datasetParam) {
        if (this.getManager() == null || parameter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        String schema = null;
        ByteArrayOutputStream os = null;
        XMLStreamWriter writer = null;
        try {
            os = new ByteArrayOutputStream();
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("Schema");
            writer.writeAttribute("name", "KDOLAP");
            this.outParams(writer, parameter, datasetParam);
            for (Dimension dimension : datasetParam.getDimension()) {
                if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                    dimension.setTreeModel(false);
                }
                this.dimensionCommon(writer, dimension, parameter);
            }
            this.schemaCube(writer, datasetParam);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            schema = ((Object)os).toString();
        }
        catch (XMLStreamException ex) {
            throw new KDBizException(ResManager.loadKDString((String)"Schema\u914d\u7f6e\u53c2\u6570\u6784\u5efa\u9519\u8bef", (String)"ParamConfig_5", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException ex) {
                    log.error("budget-olap-log : build schema error.", (Throwable)ex);
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    log.error("budget-olap-log : build schema error.", (Throwable)ex);
                }
            }
        }
        return schema;
    }

    @Override
    public String getParamValue(String key) {
        return this.getManager().getParamValue(key);
    }

    protected void outParams(XMLStreamWriter writer, QueryParameter parameter, DatasetParameter datasetParam) throws XMLStreamException {
        if (writer == null || parameter == null || datasetParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        String cubeTables = this.getParamValue("DATA_FACT_TABLES");
        if (cubeTables == null) {
            throw new KDBizException(ResManager.loadKDString((String)"LAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u6570\u636e\u7684\u4e8b\u5b9e\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_6", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        String[] tables = cubeTables.split(",");
        if (tables == null || tables.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"LAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u6570\u636e\u7684\u4e8b\u5b9e\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_6", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        writer.writeStartElement("Parameter");
        writer.writeAttribute("name", FACT_NAME);
        writer.writeAttribute("type", "Table");
        writer.writeEndElement();
        for (Dimension dimension : datasetParam.getDimension()) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            writer.writeStartElement("Parameter");
            writer.writeAttribute("name", dimension.getNumber());
            writer.writeAttribute("type", "Table");
            writer.writeEndElement();
        }
    }

    protected void dimensionCommon(XMLStreamWriter writer, Dimension dimension, QueryParameter parameter) throws XMLStreamException {
        if (writer == null || dimension == null || dimension.getNumber() == null || parameter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (this.hasOptimizeDimension(dimension.getNumber())) {
            return;
        }
        writer.writeStartElement("Dimension");
        writer.writeAttribute("name", dimension.getShortNumber());
        writer.writeAttribute("primaryKey", "fid");
        writer.writeAttribute("table", dimension.getNumber());
        writer.writeStartElement("Hierarchy");
        writer.writeAttribute("name", dimension.getShortNumber() + " hierarchy");
        writer.writeStartElement("Level");
        writer.writeAttribute("name", dimension.getShortNumber() + " Level");
        writer.writeAttribute("column", "fid");
        if (dimension.isTreeModel()) {
            writer.writeAttribute("parentColumn", "fparent");
        }
        if (dimension.isOrder()) {
            writer.writeAttribute("orderBy", "fnumber");
        }
        writer.writeStartElement("Property");
        writer.writeAttribute("name", "name");
        writer.writeAttribute("column", "fnumber");
        writer.writeEndElement();
        if (ParamConfig.hasWeight(dimension)) {
            writer.writeStartElement("Property");
            writer.writeAttribute("name", "weight");
            writer.writeAttribute("column", "fweight");
            writer.writeEndElement();
        }
        if (ParamConfig.hasAggregate(dimension)) {
            writer.writeStartElement("Property");
            writer.writeAttribute("name", "disableAgg");
            writer.writeAttribute("column", "faggregate");
            writer.writeEndElement();
        }
        if (ParamConfig.hasProperty(dimension)) {
            writer.writeStartElement("Property");
            writer.writeAttribute("name", "bpType");
            writer.writeAttribute("column", "fbptype");
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static boolean hasWeight(Dimension dimension) {
        if (dimension == null) {
            return false;
        }
        return ParamConfig.hasWeight(dimension.getNumber());
    }

    private static boolean hasWeight(String dimensionNumber) {
        if (dimensionNumber == null) {
            return false;
        }
        return SysDimensionEnum.Account.getNumber().equals(dimensionNumber) || SysDimensionEnum.ChangeType.getNumber().equals(dimensionNumber) || SysDimensionEnum.DataType.getNumber().equals(dimensionNumber) || SysDimensionEnum.AuditTrail.getNumber().equals(dimensionNumber);
    }

    public static boolean hasAggregate(Dimension dimension) {
        if (dimension == null || dimension.getNumber() == null) {
            return false;
        }
        return SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber());
    }

    public static boolean hasProperty(Dimension dimension) {
        if (dimension == null || dimension.getNumber() == null) {
            return false;
        }
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber());
    }

    protected void schemaCube(XMLStreamWriter writer, DatasetParameter dataSetParam) throws XMLStreamException {
        if (writer == null || dataSetParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        writer.writeStartElement("Cube");
        writer.writeAttribute("name", "budgetCube");
        writer.writeAttribute("table", FACT_NAME);
        for (Dimension dimension : dataSetParam.getDimension()) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            writer.writeStartElement("DimensionUsage");
            writer.writeAttribute("name", dimension.getShortNumber());
            writer.writeAttribute("foreignKey", this.getDimUsageFiled(dimension));
            writer.writeEndElement();
        }
        this.measure(writer);
        writer.writeEndElement();
    }

    @Override
    public boolean hasOptimizeDimension(String dimensionNumber) {
        if (dimensionNumber == null) {
            return false;
        }
        boolean re = false;
        if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) && !this.getCheck().hasOrgDim()) {
            re = true;
        } else {
            String dimTag = "OPTIMIZE_TAG_" + dimensionNumber;
            IKDValue propertyValue = this.getProperties().getPropertyValue(dimTag);
            if (propertyValue != null && OlapConstant.OPTIMIZE_VALUE_TRUE.equals(propertyValue.getString())) {
                re = true;
            }
        }
        return re;
    }

    @Override
    public boolean hasOptimizeDimensionBySN(String dimensionShortNumber) {
        if (dimensionShortNumber == null) {
            return false;
        }
        boolean re = false;
        if (SysDimensionEnum.Entity.getShortNumber().equals(dimensionShortNumber) && !this.getCheck().hasOrgDim()) {
            re = true;
        } else {
            String dimTag = "OPTIMIZE_TAG_" + dimensionShortNumber;
            IKDValue propertyValue = this.getProperties().getPropertyValue(dimTag);
            if (propertyValue != null && OlapConstant.OPTIMIZE_VALUE_TRUE.equals(propertyValue.getString())) {
                re = true;
            }
        }
        return re;
    }

    @Override
    public boolean hasOptimizeEntity() {
        return this.hasOptimizeDimension(SysDimensionEnum.Entity.getNumber());
    }

    protected String getDimUsageFiled(Dimension dimension) {
        String field = (String)OlapConstant.getFieldMap().get(dimension.getNumber());
        if (field == null) {
            field = 'f' + dimension.getFieldMapped();
        }
        return field;
    }

    protected void measure(XMLStreamWriter writer) throws XMLStreamException {
        if (writer == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684schema\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ParamConfig_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        writer.writeStartElement("Measure");
        writer.writeAttribute("name", "va");
        writer.writeAttribute("column", "fvalue");
        writer.writeAttribute("aggregator", "sum");
        writer.writeEndElement();
    }

    @Override
    public Map getSchemaParam(QueryParameter parameter, DatasetParameter datasetParam, IKDOlapRequest request) {
        this.buildCubeInfo(this.getSchemaParams(), parameter, datasetParam, request);
        return this.getSchemaParams();
    }

    public void setSchemaParams(Map schemaParams) {
        this.schemaParams = schemaParams;
    }

    @Override
    public Map getSchemaParams() {
        return this.schemaParams;
    }

    protected void buildCubeInfo(Map schemaParams, QueryParameter parameter, DatasetParameter datasetParam, IKDOlapRequest request) {
        if (schemaParams == null || parameter == null || datasetParam.getCube() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"OLAP\u7684\u53c2\u6570\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParamConfig_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IKDCube cube = datasetParam.getCube();
        List<Dimension> dimensions = datasetParam.getDimension();
        Map<String, Long> views = this.getViewId(request, datasetParam);
        List<Input> cubeInputs = this.getCubeInputs(parameter, datasetParam, request);
        schemaParams.put(FACT_NAME, cubeInputs.toArray(new Input[cubeInputs.size()]));
        IMemberFilter filter = this.getMemberFilter();
        filter.setQueryParameter(parameter);
        filter.setOlapRequest(request);
        for (Dimension dimension : dimensions) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            schemaParams.put(dimension.getNumber(), this.getDimensionMemberInput(request, cube, dimension, filter, views));
        }
    }

    protected Input getDimensionMemberInput(IKDOlapRequest request, IKDCube cube, Dimension dimension, IMemberFilter filter, Map<String, Long> views) {
        return new DimensionMemberInput().of(request, cube, dimension, filter, views);
    }

    protected List<Input> getCubeInputs(QueryParameter parameter, DatasetParameter datasetParam, IKDOlapRequest request) {
        return new ArrayList<Input>();
    }

    protected RowMeta getCubeMeta(List<Dimension> dimensions) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Dimension dimension : dimensions) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                fields.add(new Field('f' + dimension.getFieldMapped(), dimension.getNumber(), this.getDimDataType(), false));
                continue;
            }
            fields.add(new Field((String)OlapConstant.getFieldMap().get(dimension.getNumber()), dimension.getNumber(), this.getDimDataType(), false));
        }
        fields.add(new Field("fvalue", (DataType)DataType.BigDecimalType));
        RowMeta cubeRowMeta = new RowMeta(fields.toArray(new Field[fields.size()]));
        return cubeRowMeta;
    }

    protected DataType getDimDataType() {
        return DataType.LongType;
    }

    private Map<String, Long> getViewId(IKDOlapRequest request, DatasetParameter datasetParam) {
        Long busModelId;
        Map<String, Long> viewIds = request.getOlapQuery().getViews();
        if (datasetParam.getDatasetId() == null || datasetParam.getDatasetId() == 0L || datasetParam.getDatasetId().equals(request.getOlapQuery().getDatasetId())) {
            return viewIds;
        }
        DynamicObject dataset = datasetParam.getDataset();
        if (dataset != null && !(busModelId = Long.valueOf(dataset.getDynamicObject("businessmodel").getLong("id"))).equals(request.getOlapQuery().getBusModelId())) {
            return BusinessModelServiceHelper.getViewIds((Long)busModelId);
        }
        return viewIds;
    }

    protected Input buildFactInput(String dataTable, DataFactInfo factInfo, Member orgMember, RowMeta cubeRowMeta, IKDCube cube, LogStats stats) {
        String sql = factInfo.getSql().toString();
        Object[] sqlParams = factInfo.toArrays();
        log.info("budget-olap-log : " + sql + "; params =" + Arrays.toString(sqlParams));
        return new DbInput("olap", "epm", sql, sqlParams, cubeRowMeta);
    }

    protected DataFactInfo buildDataFactSql(IKDOlapRequest request, DatasetParameter datasetParam, String factTable, Long datasetId, Member currOrgUnit, List<Long> accountIds) {
        if (request == null || datasetParam == null || factTable == null || datasetId == null || currOrgUnit == null || accountIds == null) {
            return null;
        }
        DataFactInfo info = new DataFactInfo();
        IModelCacheHelper modelCacheHelper = datasetParam.getCube().getModelCache();
        Long cubeId = modelCacheHelper.getModelobj().getId();
        List<Dimension> dimensions = datasetParam.getDimension();
        Dimension orgDim = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        Set datasetDims = null;
        if (PropertyUtils.isIgnDataset(request.getProperties())) {
            List dataDims = modelCacheHelper.getDimensionList(datasetId);
            datasetDims = dataDims.stream().map(BaseCache::getId).collect(Collectors.toSet());
        }
        boolean hasOrgId = false;
        boolean hasUserDefined = false;
        String field = null;
        Long viewId = request.getOlapQuery().getViews().get(SysDimensionEnum.Entity.getNumber());
        info.getSql().append("select ");
        for (Dimension dimension : dimensions) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            hasUserDefined = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension);
            field = this.getFieldByDimension(hasUserDefined, dimension);
            if (datasetDims != null && !datasetDims.contains(dimension.getId())) {
                Long noneId = this.getNoneMember(request.getCubeId()).get(dimension.getNumber());
                info.getSql().append(noneId).append(" as ").append(field).append(',');
                continue;
            }
            if (hasUserDefined) {
                info.getSql().append("t.").append(field);
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && this.getCheck().hasOrgDim() && !currOrgUnit.isLeaf()) {
                hasOrgId = true;
                info.getSql().append(currOrgUnit.getId()).append(" as ").append(field);
            } else {
                info.getSql().append("t.").append(field);
            }
            info.getSql().append(',');
        }
        if (currOrgUnit.isLeaf() || !OlapConstant.hasGroupBy) {
            info.getSql().append("t.fvalue");
        } else {
            info.getSql().append("sum(t.fvalue) as fvalue");
        }
        info.getSql().append(" from ").append(factTable).append(" t ");
        if (currOrgUnit.isLeaf()) {
            info.getSql().append(" where t.forgunitid = ?");
        } else {
            info.getSql().append(" join ").append(OlapTableUtils.getDimClosureTable(cubeId, orgDim, viewId)).append(" c on t.forgunitid = c.fchild");
            info.getSql().append(" where c.fid = ?");
        }
        info.getSqlParams().add(currOrgUnit.getId());
        info.getSql().append(" and t.faccountid in (").append(SqlBatchUtils.getBatchParamsSql((int)accountIds.size())).append(')');
        info.getSqlParams().addAll(accountIds);
        for (Dimension dimension : dimensions) {
            IKDValue memberVal;
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) continue;
            hasUserDefined = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension);
            field = this.getFieldByDimension(hasUserDefined, dimension);
            if (datasetDims != null && !datasetDims.contains(dimension.getId()) || !this.hasOptimizeDimension(dimension.getNumber()) || (memberVal = this.getProperties().getPropertyValue("DEF_MEMBER_ID_" + dimension.getNumber())) == null) continue;
            info.getSql().append(" and t.").append(field).append(" = ?");
            info.getSqlParams().add(Long.valueOf(memberVal.getString()));
        }
        if (!currOrgUnit.isLeaf() && OlapConstant.hasGroupBy) {
            info.getSql().append(" and t.").append((String)OlapConstant.getFieldMap().get(SysDimensionEnum.Metric.getNumber())).append(" in (select fid from t_eb_structofmetric where fmodelid = ? and fisagg = 1)");
            info.getSqlParams().add(cubeId);
            info.getSql().append(" group by ");
            for (Dimension dimension : dimensions) {
                if (this.hasOptimizeDimension(dimension.getNumber()) || hasOrgId && SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) continue;
                hasUserDefined = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension);
                field = this.getFieldByDimension(hasUserDefined, dimension);
                if (datasetDims != null && !datasetDims.contains(dimension.getId())) continue;
                info.getSql().append("t.").append(field).append(',');
            }
            info.getSql().setLength(info.getSql().length() - 1);
        }
        return info;
    }

    private String getFieldByDimension(boolean hasUserDefined, Dimension dimension) {
        String field = null;
        field = hasUserDefined ? 'f' + dimension.getFieldMapped() : (String)OlapConstant.getFieldMap().get(dimension.getNumber());
        return field;
    }

    protected IMemberFilter getMemberFilter() {
        return new MemberFilter();
    }

    public void clearOptimize(String dimensionNumber) {
        if (dimensionNumber == null) {
            return;
        }
        this.getProperties().removeProperty("OPTIMIZE_TAG_" + dimensionNumber);
        this.getProperties().removeProperty("DEF_MEMBER_NUM_" + dimensionNumber);
        this.getProperties().removeProperty("DEF_MEMBER_ID_" + dimensionNumber);
    }

    @Override
    public OlapConfig getSchemaConfig(IKDOlapRequest request) {
        OlapConfig config = new OlapConfig();
        config.BUILD_AUTOJOINFACTSQL = false;
        return config;
    }

    @Override
    public IParamCheck getCheck() {
        if (this.check == null) {
            this.check = new ParamCheck(this.getManager());
        }
        return this.check;
    }

    @Override
    public IKDProperties getProperties() {
        return this.properties;
    }

    private Map<String, Long> getNoneMember(Long cubeId) {
        if (this.noneMemberIds == null) {
            this.noneMemberIds = MemberServiceHelper.queryNoneMemberIds((Long)cubeId);
        }
        return this.noneMemberIds;
    }

    public static class DataFactInfo {
        private StringBuilder sql = new StringBuilder();
        private List<Object> sqlParams = new LinkedList<Object>();

        public StringBuilder getSql() {
            return this.sql;
        }

        public List<Object> getSqlParams() {
            return this.sqlParams;
        }

        public Object[] toArrays() {
            return this.sqlParams.toArray(new Object[this.sqlParams.size()]);
        }
    }
}

