/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.param;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;

public class ParamManager {
    protected static final Log log = LogFactory.getLog(ParamManager.class);
    private Map<String, String> params = new ConcurrentHashMap<String, String>();

    public static ParamManager get() {
        return new ParamManager();
    }

    public String getParamValue(String key) {
        return this.params.get(key);
    }

    public void setParam(String key, String value) {
        if (key != null) {
            this.params.put(key, value);
        }
    }

    public ParamManager initParams(IKDCube cube, IKDOlapRequest request) {
        Set<String> orgNumbers;
        if (cube == null || request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u521d\u59cb\u5316\u9519\u8bef\uff0c\u4f53\u7cfb\u6216\u8005\u8bf7\u6c42\u4e3a\u7a7a\u3002", (String)"ParamManager_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin-initParams");
        Long cubeId = Long.valueOf(cube.getId());
        Map<String, String> factKeyMap = OlapTableUtils.queryFactTableKey(Long.valueOf(cube.getId()));
        stats.add("end queryFactTable.");
        HashMap<String, Set<String>> factCacheMap = new HashMap<String, Set<String>>();
        HashSet<String> refAccounts = new HashSet<String>();
        HashSet<String> refVersions = new HashSet<String>();
        Map<String, Set<String>> refMembers = request.getRefMemberByCalc(cube, false);
        stats.add("end parse ref members.");
        if (refMembers != null) {
            Set<String> tmpRefVersionNums;
            Set<String> tmpRefAccountNums = refMembers.get(SysDimensionEnum.Account.getNumber());
            if (tmpRefAccountNums != null) {
                refAccounts.addAll(tmpRefAccountNums);
            }
            if ((tmpRefVersionNums = refMembers.get(SysDimensionEnum.Version.getNumber())) != null) {
                refVersions.addAll(tmpRefVersionNums);
            }
        }
        int in = request.getOlapQuery().getQueries().size();
        for (int i = 0; i < in; ++i) {
            Set<String> versions;
            IKDQuery query = request.getOlapQuery().getQueries().get(i);
            if (query == null) continue;
            Set<String> accounts = query.getMemberNums(SysDimensionEnum.Account.getNumber());
            if (accounts != null) {
                refAccounts.addAll(accounts);
            }
            if ((versions = query.getMemberNums(SysDimensionEnum.Version.getNumber())) == null) continue;
            refVersions.addAll(versions);
        }
        stats.addInfo("accountNs =" + Arrays.toString(refAccounts.toArray(new String[refAccounts.size()])));
        stats.addInfo("versionNums =" + Arrays.toString(refVersions.toArray(new String[refVersions.size()])));
        Member account = null;
        Member version = null;
        HashMap<Long, Set> datasetIdMap = new HashMap<Long, Set>();
        Set datasetTabs = null;
        HashSet errorAccounts = Sets.newHashSetWithExpectedSize((int)refAccounts.size());
        HashMap factIndexMap = Maps.newHashMapWithExpectedSize((int)32);
        Dimension accountDim = cube.getModelCache().getDimension(SysDimensionEnum.Account.getNumber());
        Dimension versionDim = cube.getModelCache().getDimension(SysDimensionEnum.Version.getNumber());
        for (String versionNum : refVersions) {
            version = versionDim.getMember(versionNum);
            for (String accountNum : refAccounts) {
                Set<Object> tmpFact;
                account = accountDim.getMember(accountNum);
                if (account == null || account.getDatasetId() == null || account.getDatasetId() == 0L) {
                    errorAccounts.add(accountNum);
                    continue;
                }
                if (ShrekOlapServiceHelper.isStartShrek()) {
                    tmpFact = Collections.emptySet();
                } else {
                    tmpFact = OlapTableUtils.getFactDataTable(cubeId, account, version, factKeyMap, factCacheMap, factIndexMap);
                    if (tmpFact == null || tmpFact.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"OLAP\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u4e8b\u5b9e\u8868\u67e5\u8be2\u9519\u8bef\u3002", (String)"ParamManager_1", (String)"epm-eb-olap", (Object[])new Object[0]));
                    }
                }
                datasetTabs = datasetIdMap.computeIfAbsent(account.getDatasetId(), k -> Sets.newLinkedHashSet());
                datasetTabs.addAll(tmpFact);
            }
        }
        stats.add("end filter factTable.");
        this.setParam("DATA_FACT_TABLES", JSONUtils.toString(datasetIdMap));
        this.setParam("DATA_FACT_ACCOUNT", JSONUtils.toString((Object)factIndexMap));
        refMembers = request.getRefMember();
        if (refMembers != null && (orgNumbers = refMembers.get(SysDimensionEnum.Entity.getNumber())) != null && !orgNumbers.isEmpty()) {
            this.setParam("HAS_ORG_DIMENSION", Boolean.TRUE.toString());
        }
        if (!errorAccounts.isEmpty()) {
            stats.addInfo("errorAccounts = " + Arrays.toString(errorAccounts.toArray(new String[errorAccounts.size()])));
        }
        stats.addInfo("end-initParams.");
        log.info(stats.toString());
        return this;
    }
}

