/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.kd.rst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.MdxResult;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.query.kd.param.IParamConfig;
import kd.epm.eb.olap.impl.query.kd.rst.IKDOlapResult;

public class KDOlapResult
implements IKDOlapResult {
    private IParamConfig paramConfig = null;
    private IKDOlapRequest request = null;

    protected IParamConfig getParamConfig() {
        return this.paramConfig;
    }

    protected IKDOlapRequest getRequest() {
        return this.request;
    }

    public KDOlapResult(IParamConfig paramConfig, IKDOlapRequest request) {
        this.paramConfig = paramConfig;
        this.request = request;
    }

    @Override
    public List<IKDCell> transRst(MdxResult rst) {
        LinkedList<IKDCell> cells = new LinkedList<IKDCell>();
        if (rst == null) {
            return cells;
        }
        Cell cell = null;
        IKDCell kdCell = null;
        Map<String, String> defaultMemberMap = KDOlapResult.getDefaultMemberMap(this.getRequest(), this.getParamConfig());
        Iterator _cells = rst.getCellIterator();
        while (_cells.hasNext()) {
            cell = (Cell)_cells.next();
            kdCell = KDCell.of(cell, this.getRequest().getOlapQuery().getUseDimensions(), defaultMemberMap);
            if (kdCell == null) continue;
            cells.add(kdCell);
        }
        return cells;
    }

    public static Map<String, String> getDefaultMemberMap(IKDOlapRequest request, IParamConfig config) {
        HashMap<String, String> defaultMemberMap = new HashMap<String, String>();
        if (request == null || config == null) {
            return defaultMemberMap;
        }
        IKDValue value = null;
        List<Dimension> dimensions = request.getOlapQuery().getUseDimensions();
        for (Dimension dimension : dimensions) {
            value = config.getProperties().getPropertyValue("DEF_MEMBER_NUM_" + dimension.getNumber());
            if (value == null || !value.isString()) continue;
            defaultMemberMap.put(dimension.getShortNumber(), value.getString());
        }
        return defaultMemberMap;
    }
}

