/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.queryData;

import java.io.InputStream;
import java.util.Map;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.Driver;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.query.kd.mdx.IMdxStrategy;
import kd.epm.eb.olap.impl.query.kd.param.IParamConfig;
import kd.epm.eb.olap.impl.query.kd.param.ParamConfig;
import kd.epm.eb.olap.impl.query.kd.param.ParamManager;
import kd.epm.eb.olap.impl.query.kd.rst.IKDOlapResult;
import kd.epm.eb.olap.impl.query.param.DatasetParameter;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractQueryBase;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public abstract class AbstractDataQueryBase
extends AbstractQueryBase {
    protected ParamManager paramManager = null;
    private IParamConfig paramConfig = null;

    protected void setParamManager(ParamManager paramManager) {
        this.paramManager = paramManager;
    }

    protected ParamManager getParamManager() {
        return this.paramManager;
    }

    public IParamConfig getParamConfig() {
        if (this.paramConfig == null) {
            this.paramConfig = this.createParamConfig();
        }
        return this.paramConfig;
    }

    protected IParamConfig createParamConfig() {
        return ParamConfig.get(this.getParamManager());
    }

    public AbstractDataQueryBase(QueryParameter parameter, IKDCube cube, IKDOlapRequest request, ParamManager paramManager) {
        super(parameter, cube, request);
        this.paramManager = paramManager;
    }

    protected Connection openConnection() throws OlapException {
        return this.openConnection(null);
    }

    protected Connection openConnection(Long datasetId) throws OlapException {
        DatasetParameter datasetParam = this.getDatasetParam(datasetId, this.getCube(), this.getRequest());
        return Driver.openConnection((InputStream)this.getParamConfig().getSchema(this.getParameter(), datasetParam), (Map)this.getParamConfig().getSchemaParam(this.getParameter(), datasetParam, this.getRequest()), (OlapConfig)this.getParamConfig().getSchemaConfig(this.getRequest()));
    }

    protected DatasetParameter getDatasetParam(Long datasetId, IKDCube cube, IKDOlapRequest request) {
        Long _datasetId = datasetId;
        if (_datasetId == null || _datasetId == 0L) {
            _datasetId = request.getOlapQuery().getDatasetId();
        }
        DatasetParameter parameter = new DatasetParameter(cube, _datasetId).builder(request);
        boolean ignDataset = PropertyUtils.isIgnDataset(request.getProperties());
        if (ignDataset) {
            parameter.setDimension(request.getOlapQuery().getUseDimensions());
        }
        return parameter;
    }

    protected abstract void calcRule(Connection var1, Map<String, Connection> var2);

    protected abstract IMdxStrategy getMdxStrategy();

    protected abstract IKDOlapResult getResult();

    protected abstract void optimize();
}

