/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.queryData;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractDataQueryBase;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractQueryBase
implements Callable<CubeDataResult> {
    private static final Log log = LogFactory.getLog(AbstractDataQueryBase.class);
    private QueryParameter parameter = null;
    private IKDCube cube = null;
    private IKDOlapRequest request = null;
    private CountDownLatch cdl = null;

    protected static Log getLog() {
        return log;
    }

    protected QueryParameter getParameter() {
        return this.parameter;
    }

    protected IKDCube getCube() {
        return this.cube;
    }

    protected IKDOlapRequest getRequest() {
        return this.request;
    }

    public void setCdl(CountDownLatch cdl) {
        this.cdl = cdl;
    }

    public CountDownLatch getCdl() {
        return this.cdl;
    }

    public AbstractQueryBase(QueryParameter parameter, IKDCube cube, IKDOlapRequest request) {
        this.parameter = parameter;
        this.cube = cube;
        this.request = request;
    }

    @Override
    @NotNull
    public CubeDataResult call() throws Exception {
        CubeDataResult result;
        this.getParameter().getStats().addInfo("begin-olap-query-thread. requestId = " + this.getRequest().getId());
        try {
            result = this.doQuery();
        }
        catch (Throwable ex) {
            log.error(ex);
            throw new KDBizException(ex.getMessage());
        }
        finally {
            if (this.getCdl() != null) {
                this.getCdl().countDown();
            }
            this.getParameter().getStats().addInfo("end-olap-query-thread.");
            AbstractQueryBase.getLog().info(this.getParameter().getStats().toString());
        }
        return result;
    }

    @NotNull
    protected abstract CubeDataResult doQuery();
}

