/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.shrek;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.queryData.AbstractQueryBase;
import org.jetbrains.annotations.NotNull;

public class ShrekOtherDataQueryThread
extends AbstractQueryBase {
    public ShrekOtherDataQueryThread(QueryParameter parameter, IKDCube cube, IKDOlapRequest request) {
        super(parameter, cube, request);
    }

    @Override
    @NotNull
    protected CubeDataResult doQuery() {
        LogStats stats = new LogStats("budget-shrek-log : ");
        Model model = this.getCube().getModelCache().getModelobj();
        Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)this.getRequest().getOlapQuery().getDatasetId(), (String)"eb_dataset"));
        List dimensions = this.getCube().getModelCache().getDimensionList(this.getRequest().getOlapQuery().getDatasetId());
        Map<String, Set<String>> refMembers = this.getRequest().getRefMember();
        Set filterMetric = MemberServiceHelper.getOtherMember((Long)model.getId(), (IModelCacheHelper)this.getCube().getModelCache());
        CubeDataResult result = new CubeDataResult();
        SelectCommandInfo command = new SelectCommandInfo();
        command.addDims((String[])dimensions.stream().map(BaseCache::getNumber).toArray(String[]::new));
        command.addMeasures(new String[]{"FMONEY"});
        LinkedHashSet<String> members = new LinkedHashSet<String>();
        for (Dimension dimension : dimensions) {
            members.clear();
            Set<String> tmpSet = refMembers.get(dimension.getNumber());
            if (tmpSet != null) {
                members.addAll(tmpSet);
            }
            if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                members.retainAll(filterMetric);
            }
            if (members.isEmpty()) {
                this.getParameter().getStats().addInfo(dimension.getNumber() + " member is null.");
                return result;
            }
            command.addFilter(dimension.getNumber(), members.toArray(new String[0]));
        }
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)model, (Dataset)dataset, (SelectCommandInfo)command, (LogStats)stats);){
            while (reader.hasNext()) {
                IKDCell cell;
                Object[] values = reader.next();
                if (values == null || values[0] == null || (cell = KDCell.of(values)) == null) continue;
                result.getCells().add(cell);
            }
        }
        return result;
    }
}

