/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.shrek.param;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IMemberFilter;
import kd.epm.eb.olap.impl.query.kd.param.ParamConfig;
import kd.epm.eb.olap.impl.query.kd.param.ParamManager;
import kd.epm.eb.olap.impl.query.param.DatasetParameter;
import kd.epm.eb.olap.impl.query.param.QueryParameter;
import kd.epm.eb.olap.impl.query.shrek.param.ShrekCubeInput;
import kd.epm.eb.olap.impl.query.shrek.param.ShrekDimensionMemberInput;

public class ShrekParamConfig
extends ParamConfig {
    public static ParamConfig get(ParamManager manager) {
        return new ShrekParamConfig(manager);
    }

    public ShrekParamConfig(ParamManager manager) {
        super(manager);
    }

    @Override
    protected List<Input> getCubeInputs(QueryParameter parameter, DatasetParameter datasetParam, IKDOlapRequest request) {
        Set members;
        ArrayList<Input> dbInputs = new ArrayList<Input>();
        Long datasetId = datasetParam.getDatasetId();
        IKDCube cube = datasetParam.getCube();
        List<Dimension> dimensions = datasetParam.getDimension();
        Map<String, Dimension> dimensionMap = request.getOlapQuery().getDimensionMap();
        Map<String, Set<String>> refMembers = request.getRefMember();
        Map<String, Set<String>> refMembersByCalc = request.getRefMemberByCalc(cube, false);
        Set filterMetric = MemberServiceHelper.getOtherMember((Long)Long.valueOf(cube.getId()), (IModelCacheHelper)cube.getModelCache());
        RowMeta cubeRowMeta = this.getCubeMeta(dimensions);
        ArrayList<Dimension> useDimension = new ArrayList<Dimension>(dimensions.size());
        for (Dimension dimension : dimensions) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            useDimension.add(dimension);
        }
        LinkedHashSet allMembers = Sets.newLinkedHashSet();
        SelectCommandInfo command = new SelectCommandInfo();
        command.addDims((String[])useDimension.stream().map(BaseCache::getNumber).toArray(String[]::new));
        command.addMeasures(new String[]{"FMONEY"});
        LinkedHashSet<String> entitys = new LinkedHashSet<String>();
        entitys.addAll(parameter.getRefOrgUnits());
        if (refMembersByCalc.get(SysDimensionEnum.Entity.getNumber()) != null) {
            entitys.addAll((Collection)refMembersByCalc.get(SysDimensionEnum.Entity.getNumber()));
        }
        command.addFilter(SysDimensionEnum.Entity.getNumber(), entitys.toArray(new String[0]));
        LinkedHashSet<String> accounts = new LinkedHashSet<String>();
        Set<String> tmpSet = refMembers.get(SysDimensionEnum.Account.getNumber());
        if (tmpSet != null) {
            accounts.addAll(tmpSet);
        }
        if ((tmpSet = refMembersByCalc.get(SysDimensionEnum.Account.getNumber())) != null) {
            accounts.addAll(tmpSet);
        }
        if ((members = dimensionMap.get(SysDimensionEnum.Account.getNumber()).getLeaf(accounts, datasetId)).isEmpty()) {
            dbInputs.add((Input)new ShrekCubeInput(cubeRowMeta, ShrekOlapServiceHelper.emptyReader()));
            parameter.getStats().addInfo("account member is null.");
            return dbInputs;
        }
        command.addFilter(SysDimensionEnum.Account.getNumber(), members.toArray(new String[0]));
        for (Dimension dimension : dimensions) {
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) continue;
            View view = dimension.getView(request.getOlapQuery().getViews().get(dimension.getNumber()));
            if (this.hasOptimizeDimension(dimension.getNumber())) {
                String optMemberTag = "DEF_MEMBER_NUM_" + dimension.getNumber();
                IKDValue optMemberVal = this.getProperties().getPropertyValue(optMemberTag);
                if (optMemberVal == null) continue;
                command.addFilter(dimension.getNumber(), new String[]{optMemberVal.getString()});
                continue;
            }
            members = refMembers.get(dimension.getNumber());
            if (members != null) {
                allMembers.addAll(members);
            }
            if ((members = refMembersByCalc.get(dimension.getNumber())) != null) {
                allMembers.addAll(members);
            }
            members = view != null ? view.getLeaf((Set)allMembers) : dimension.getLeaf((Set)allMembers);
            allMembers.clear();
            if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                members.removeAll(filterMetric);
            }
            if (members.isEmpty()) {
                dbInputs.add((Input)new ShrekCubeInput(cubeRowMeta, ShrekOlapServiceHelper.emptyReader()));
                parameter.getStats().addInfo(dimension.getNumber() + " member is null.");
                return dbInputs;
            }
            command.addFilter(dimension.getNumber(), members.toArray(new String[0]));
        }
        ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cube.getModelCache().getModelobj(), (Dataset)Dataset.of((DynamicObject)datasetParam.getDataset()), (SelectCommandInfo)command, (LogStats)parameter.getStats());
        dbInputs.add((Input)new ShrekCubeInput(cubeRowMeta, reader));
        return dbInputs;
    }

    @Override
    protected RowMeta getCubeMeta(List<Dimension> dimensions) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("fvalue", (DataType)DataType.BigDecimalType));
        for (Dimension dimension : dimensions) {
            if (this.hasOptimizeDimension(dimension.getNumber())) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                fields.add(new Field('f' + dimension.getFieldMapped(), dimension.getNumber(), this.getDimDataType(), false));
                continue;
            }
            fields.add(new Field((String)OlapConstant.getFieldMap().get(dimension.getNumber()), dimension.getNumber(), this.getDimDataType(), false));
        }
        RowMeta cubeRowMeta = new RowMeta(fields.toArray(new Field[fields.size()]));
        return cubeRowMeta;
    }

    @Override
    protected DataType getDimDataType() {
        return DataType.StringType;
    }

    @Override
    protected Input getDimensionMemberInput(IKDOlapRequest request, IKDCube cube, Dimension dimension, IMemberFilter filter, Map<String, Long> views) {
        return new ShrekDimensionMemberInput().of(request, cube, dimension, filter, views);
    }
}

