/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.task;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseTask
implements Callable<Object> {
    public static final Log log = LogFactory.getLog(AbstractBaseTask.class);
    private IKDCube cube;
    private IKDOlapRequest request;
    private IOlapQuery olapQuery;
    private IKDQuery query;
    private Map<String, Set<Long>> memberMap;
    private CountDownLatch cdl = null;
    private LogStats stats = null;

    protected IKDCube getCube() {
        return this.cube;
    }

    protected IKDOlapRequest getRequest() {
        return this.request;
    }

    protected IOlapQuery getOlapQuery() {
        return this.olapQuery;
    }

    protected IKDQuery getQuery() {
        return this.query;
    }

    protected Map<String, Set<Long>> getMemberMap() {
        return this.memberMap;
    }

    public void setCdl(CountDownLatch cdl) {
        this.cdl = cdl;
    }

    public CountDownLatch getCdl() {
        return this.cdl;
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public AbstractBaseTask(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, @NotNull IOlapQuery olapQuery, @NotNull IKDQuery query, Map<String, Set<Long>> memberMap) {
        this.cube = cube;
        this.request = request;
        this.olapQuery = olapQuery;
        this.query = query;
        this.memberMap = memberMap;
    }

    @Override
    public Object call() throws Exception {
        try {
            if (this.check()) {
                this.query();
            }
        }
        finally {
            this.getCdl().countDown();
        }
        return this.getResult();
    }

    protected abstract boolean check();

    protected abstract void query();

    protected abstract Object getResult();
}

