/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.query.task;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.query.task.BaseTask;
import kd.epm.eb.olap.impl.utils.PropertyUtils;
import org.jetbrains.annotations.NotNull;

public class GetTaskThread
extends BaseTask {
    private List<IKDCell> cells = new LinkedList<IKDCell>();

    public GetTaskThread(@NotNull IKDCube cube, @NotNull IKDOlapRequest request, @NotNull IOlapQuery olapQuery, @NotNull IKDQuery query, @NotNull Map<String, Set<Long>> memberMap) {
        super(cube, request, olapQuery, query, memberMap);
    }

    @Override
    protected boolean check() {
        return this.getQuery() != null && !this.getQuery().getDimension().isEmpty();
    }

    private List<IKDCell> getCells() {
        return this.cells;
    }

    @Override
    protected void query() {
        this.getCells().clear();
        DynamicObject datasetObj = DatasetServiceHelper.loadDatasets((Long)this.getOlapQuery().getDatasetId());
        SelectCommandInfo command = new SelectCommandInfo();
        command.addDims(this.getOlapQuery().getUseDimension());
        command.addMeasures(new String[]{"FMONEY"});
        command.setExcludeNull(true);
        for (Dimension dimension : this.getQuery().getDimension()) {
            command.addFilter(dimension.getNumber(), (String[])dimension.getMembers().stream().map(Member::getNumber).toArray(String[]::new));
        }
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)this.getModel(), (Dataset)Dataset.of((DynamicObject)datasetObj), (SelectCommandInfo)command, (boolean)PropertyUtils.isGetAllData(this.getRequest().getProperties()), (LogStats)this.getStats());){
            while (reader.hasNext()) {
                IKDCell cell;
                Object[] values = reader.next();
                if (values == null || values[0] == null || (cell = KDCell.of(values)) == null) continue;
                cell.setDetail(true);
                this.getCells().add(cell);
            }
        }
        catch (Exception ex) {
            log.error("get-data-error:", (Throwable)ex);
            this.getStats().addInfo(ex.getMessage());
        }
    }

    @Override
    protected Object getResult() {
        return this.getCells();
    }
}

