/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.dataSource.KDOlapRequest;
import kd.epm.eb.olap.impl.metadata.OlapData;
import kd.epm.eb.olap.impl.metadata.OlapQuery;
import kd.epm.eb.olap.impl.query.KDQuery;
import kd.epm.eb.olap.impl.utils.OlapCommandInfo;

public class KDOlapRequestUtils {
    private static final Log log = LogFactory.getLog(KDOlapRequestUtils.class);

    public static IKDOlapRequest of(Long cubeId, Long busModelId, Long datasetId, List<IKDCell> cells) {
        return KDOlapRequestUtils.of(UserUtils.getUserId(), cubeId, busModelId, datasetId, cells);
    }

    public static IKDOlapRequest of(Long modifierId, Long cubeId, Long busModelId, Long datasetId, List<IKDCell> cells) {
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        String[] dimensions = null;
        Map dimensionMap = null;
        if (datasetId != null && datasetId != 0L) {
            dimensions = cacheHelper.getDimensionNums(datasetId);
            dimensionMap = cacheHelper.getDimensionMap(datasetId);
        }
        return KDOlapRequestUtils.of(modifierId, cubeId, busModelId, datasetId, dimensions, dimensionMap, cells);
    }

    public static IKDOlapRequest of(Long modifierId, Long cubeId, Long busModelId, Long datasetId, String[] dimension, Map<String, kd.epm.eb.common.cache.impl.Dimension> dimensionMap, List<IKDCell> cells) {
        KDOlapRequest request = new KDOlapRequest();
        request.setCubeId(cubeId);
        request.setOlapData(OlapData.of(modifierId, busModelId, datasetId, dimension, dimensionMap, cells));
        return request;
    }

    public static IKDOlapRequest of(Long cubeId, IOlapData olapData) {
        KDOlapRequest request = new KDOlapRequest();
        request.setCubeId(cubeId);
        request.setOlapData(olapData);
        return request;
    }

    public static IKDOlapRequest of(Long modelId, Long datasetId, SelectCommandInfo queryInfo) {
        return KDOlapRequestUtils.of(modelId, datasetId, queryInfo, false);
    }

    public static IKDOlapRequest of(Long modelId, Long datasetId, Long reportId, SelectCommandInfo queryInfo) {
        return KDOlapRequestUtils.of(modelId, datasetId, reportId, queryInfo, false);
    }

    public static IKDOlapRequest of(Long modelId, Long datasetId, SelectCommandInfo queryInfo, boolean isOnlyLeaf) {
        return KDOlapRequestUtils.of(modelId, datasetId, null, queryInfo, isOnlyLeaf);
    }

    public static IKDOlapRequest of(Long modelId, Long datasetId, Long reportId, SelectCommandInfo queryInfo, boolean isOnlyLeaf) {
        return KDOlapRequestUtils.of(null, modelId, null, datasetId, reportId, queryInfo, null, isOnlyLeaf);
    }

    private static IKDOlapRequest of(IModelCacheHelper modelCacheHelper, Long cubeId, Long busModelId, Long datasetId, Long reportId, SelectCommandInfo queryInfo, Map<String, Long> viewIds, boolean isOnlyLeaf) {
        return KDOlapRequestUtils.of(modelCacheHelper, cubeId, busModelId, datasetId, reportId, new OlapCommandInfo[]{OlapCommandInfo.of(null, queryInfo)}, viewIds, isOnlyLeaf);
    }

    public static IKDOlapRequest of(IModelCacheHelper modelCacheHelper, Long cubeId, Long busModelId, Long datasetId, Long reportId, OlapCommandInfo[] commands, Map<String, Long> viewIds, boolean isOnlyLeaf) {
        if (cubeId == null) {
            return null;
        }
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        }
        Dimension dimension = null;
        kd.epm.eb.common.cache.impl.Dimension dimCache = null;
        Member member = null;
        kd.epm.eb.common.cache.impl.Member memberCache = null;
        KDOlapRequest request = new KDOlapRequest();
        request.setCubeId(cubeId);
        String[] useDimension = null;
        Map dimensionMap = null;
        if (datasetId != null && datasetId != 0L) {
            useDimension = modelCacheHelper.getDimensionNums(datasetId);
            dimensionMap = modelCacheHelper.getDimensionMap(datasetId);
            if (busModelId == null || busModelId == 0L) {
                busModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
            }
        }
        if ((viewIds == null || viewIds.isEmpty()) && busModelId != null) {
            viewIds = modelCacheHelper.getViewsByBusModel(busModelId);
        }
        OlapQuery olapQuery = new OlapQuery(busModelId, datasetId, useDimension, dimensionMap);
        olapQuery.setModelCacheHelper(modelCacheHelper);
        request.setOlapQuery(olapQuery);
        if (reportId != null) {
            request.getProperties().setPropertyValue("REPORT_ID", KDValue.valueOf(String.valueOf(reportId)));
        }
        if (commands != null) {
            for (OlapCommandInfo command : commands) {
                KDQuery query = new KDQuery();
                query.setId(command.getKey());
                if (command.getCommand() != null) {
                    for (DimensionFilterItem item : command.getCommand().getFilter()) {
                        dimCache = modelCacheHelper.getDimension(item.getName());
                        if (dimCache == null) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\u201c%1\u201d\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KDOlapRequestUtils_5", (String)"epm-eb-olap", (Object[])new Object[]{item.getName()}));
                        }
                        dimension = new Dimension(null, item.getName(), item.getName());
                        dimension.setShortNumber(dimCache.getShortNumber());
                        dimension.setFieldMapped(dimCache.getFieldMapped());
                        Long viewId = null;
                        if (query.getId() != null) {
                            String[] partition;
                            for (String partitionKey : partition = query.getId().split("_")) {
                                viewId = (Long)viewIds.get(dimCache.getNumber() + "_" + partitionKey);
                                if (viewId != null) break;
                            }
                        }
                        if (viewId == null && viewIds != null) {
                            viewId = (Long)viewIds.get(dimCache.getNumber());
                        }
                        for (String memberNum : item.getValues()) {
                            if (memberNum == null) {
                                throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\u201c%1\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KDOlapRequestUtils_6", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getNumber()}));
                            }
                            memberCache = dimCache.getMember(viewId, memberNum);
                            if (memberCache == null) {
                                throw new KDBizException(ResManager.loadResFormat((String)"\u6307\u5b9a\u7f16\u7801\uff08%1-%2\uff09\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"KDOlapRequestUtils_7", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getNumber(), memberNum}));
                            }
                            if (isOnlyLeaf && !memberCache.isLeaf()) continue;
                            member = new Member(dimension);
                            member.setId(memberCache.getId());
                            member.setNumber(memberNum);
                            member.setLongNumber(memberCache.getLongNumber());
                            dimension.add(member);
                        }
                        if (dimension.getMembers().isEmpty()) {
                            throw new NullPointerException(ResManager.loadResFormat((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u201c%1\u201d\u7684\u6210\u5458\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"KDOlapRequestUtils_3", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName()}));
                        }
                        query.addDimension(dimension);
                    }
                }
                request.getOlapQuery().addQuery(query);
            }
        }
        request.getOlapQuery().addViews(viewIds);
        return request;
    }

    public static IKDQuery of(String floatKey, List<Dimension[]> rows, List<Dimension> cols) {
        if (floatKey == null || rows == null || rows.isEmpty()) {
            return null;
        }
        KDQuery query = new KDQuery();
        query.setId(floatKey);
        for (Dimension[] row : rows) {
            if (row == null || row.length == 0) continue;
            query.addFloatRow(row);
        }
        query.addFloatCols(cols);
        return query;
    }

    @Deprecated
    public static IKDOlapRequest of(IModelCacheHelper modelCacheHelper, Long cubeId, Long datasetId, SelectCommandInfo queryInfo, Map<String, Long> viewIds) {
        Long bizModelIdByDataSetId = null;
        if (datasetId != null && datasetId != 0L) {
            bizModelIdByDataSetId = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(datasetId);
        }
        return KDOlapRequestUtils.of(modelCacheHelper, cubeId, bizModelIdByDataSetId, datasetId, null, queryInfo, viewIds);
    }

    @Deprecated
    public static IKDOlapRequest of(IModelCacheHelper modelCacheHelper, Long cubeId, Long busModelId, Long datasetId, SelectCommandInfo queryInfo, Map<String, Long> viewIds) {
        return KDOlapRequestUtils.of(modelCacheHelper, cubeId, busModelId, datasetId, null, queryInfo, viewIds);
    }

    @Deprecated
    public static IKDOlapRequest of(IModelCacheHelper modelCacheHelper, Long cubeId, Long busModelId, Long datasetId, Long reportId, SelectCommandInfo queryInfo, Map<String, Long> viewIds) {
        return KDOlapRequestUtils.of(modelCacheHelper, cubeId, busModelId, datasetId, reportId, queryInfo, viewIds, false);
    }
}

