/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils;

import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;

public class OlapTableUtils {
    public static final String PARTITION_FORMAT = "000";

    public static Map<String, String> queryFactTableKey(Long cubeId) {
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapTableUtils_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        return Collections.emptyMap();
    }

    public static String getFactKey(Long dataSetId, Long versionId) {
        if (dataSetId == null) {
            throw new NullPointerException("getFactKey error. dataSetId is null.");
        }
        if (versionId == null) {
            throw new NullPointerException("getFactKey error. versionId is null.");
        }
        return "" + dataSetId + '_' + versionId;
    }

    public static Pair<String, String> mbgFactKey(String factKey) {
        if (StringUtils.isEmpty((CharSequence)factKey)) {
            return null;
        }
        if (!factKey.contains("_")) {
            return new Pair(null, (Object)factKey);
        }
        String[] split = factKey.split("_");
        return new Pair((Object)split[0], (Object)split[1]);
    }

    public static String getDimTableName(Long busModelId) {
        return "t_eb_dim" + busModelId;
    }

    public static String getDimFactTable(Long cubeId, Dimension dimension, Long viewId) {
        String shortNumber = dimension.getShortNumber();
        if (viewId != null && viewId != 0L) {
            return "t_eb_d" + viewId + shortNumber;
        }
        return "t_eb_d" + cubeId + shortNumber;
    }

    public static String getDimClosureTable(Long cubeId, Dimension dimension, Long viewId) {
        if (viewId != null && viewId != 0L) {
            return "t_eb_c" + viewId + dimension.getShortNumber();
        }
        return "t_eb_c" + cubeId + dimension.getShortNumber();
    }

    public static String getDimClosureTable(String cubeId, Dimension dimension, Long viewId) {
        if (viewId != null && viewId != 0L) {
            return "t_eb_c" + viewId + dimension.getShortNumber();
        }
        return "t_eb_c" + cubeId + dimension.getShortNumber();
    }

    public static String getFactTableName(String tableKey, String indexStr) {
        if (tableKey == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e8b\u5b9e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OlapTableUtils_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        return tableKey + indexStr;
    }

    public static String getOtherFactIndex(String factTableName, List<Dimension> dimensions) {
        if (factTableName == null || dimensions == null) {
            return null;
        }
        String indexName = factTableName.replaceFirst("t_eb_od", "ix_eb_od");
        StringBuilder index = new StringBuilder();
        index.append("create index ").append(indexName).append(" on ").append(factTableName).append(" (forgunitid, faccountid, fbgperiodid, fcurrencyid, fversionid, fatid, fctid, fdtid, fmetricid");
        int size = 12;
        int maxSize = 16;
        for (Dimension dimension : dimensions) {
            if (size >= maxSize) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                String column = dimension.getFieldMapped();
                index.append(", ").append('f').append(column.toLowerCase());
                ++size;
                continue;
            }
            if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
            index.append(", ficid");
            ++size;
        }
        index.append(')');
        return index.toString();
    }

    public static Set<String> getFactDataTable(Long cubeId, Member account, Member version, Map<String, String> factKeyMap, Map<String, Set<String>> factCacheMap, Map<String, Set<Long>> factAccIdMap) {
        if (cubeId == null || cubeId == 0L || account == null || version == null || factKeyMap == null || factCacheMap == null) {
            return null;
        }
        String key = account.getNumber() + "_" + version.getNumber();
        HashSet factTables = factCacheMap.get(key);
        if (factTables == null) {
            String tableKey = null;
            String factKey = null;
            String factTable = null;
            DecimalFormat PDF = new DecimalFormat(PARTITION_FORMAT);
            boolean factIndex = true;
            Set accountIds = null;
            LinkedList<Member> accounts = new LinkedList<Member>();
            if (account.isLeaf()) {
                accounts.add(account);
            } else {
                accounts.addAll(account.getLeaf());
            }
            LinkedList<Member> versions = new LinkedList<Member>();
            if (version.isLeaf()) {
                versions.add(version);
            } else {
                versions.addAll(version.getLeaf());
            }
            factTables = Sets.newHashSetWithExpectedSize((int)versions.size());
            for (Member _version : versions) {
                for (Member _account : accounts) {
                    factKey = OlapTableUtils.getFactKey(_account.getDatasetId(), _version.getId());
                    tableKey = factKeyMap.get(factKey);
                    if (tableKey == null) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u79d1\u76ee\u201c%1\u201d\u548c\u7248\u672c\u201c%2\u201d\u5bf9\u5e94\u7684\u6570\u636e\u4e8b\u5b9e\u8868\u4e0d\u5b58\u5728\u3002", (String)"OlapTableUtils_5", (String)"epm-eb-olap", (Object[])new Object[]{_account.getNumber(), _version.getNumber()}));
                    }
                    int partNo = OlapTableUtils.getAccountPartNo(_account);
                    factTable = OlapTableUtils.getFactTableName(tableKey, PDF.format(partNo));
                    factTables.add(factTable);
                    if (!factIndex || factAccIdMap == null) continue;
                    accountIds = factAccIdMap.computeIfAbsent(factTable, k -> new LinkedHashSet());
                    accountIds.add(_account.getId());
                }
                factIndex = false;
            }
            factCacheMap.put(key, factTables);
        }
        return factTables.isEmpty() ? null : factTables;
    }

    public static int getAccountPartNo(Member account) {
        return 0;
    }

    public static String getOtherTableName(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        return "t_eb_od" + datasetId;
    }

    public static String getOtherPKName(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        return "pk_eb_od" + datasetId;
    }

    public static String getOtherUXName(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        return "ux_eb_od" + datasetId;
    }
}

