/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.api.query.IKDQueryView;

public class OlapUtils {
    private static final Integer NEG_ONE = -1;
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;

    public static Integer getWeight(Member member) {
        Integer weight = 1;
        if (member == null || StringUtils.isEmpty((String)member.getAggType())) {
            return weight;
        }
        switch (member.getAggType()) {
            case "2": {
                weight = NEG_ONE;
                break;
            }
            case "5": {
                weight = ZERO;
                break;
            }
        }
        return weight;
    }

    public static Integer getAggregate(Member member) {
        if (member == null) {
            return ZERO;
        }
        return member.hasAgg() ? ZERO : ONE;
    }

    public static Integer getDataType(Member member) {
        if (member == null || StringUtils.isEmpty((String)member.getDatatype())) {
            return 7;
        }
        Integer type = 7;
        try {
            return MetricDataTypeEnum.getAlgoDataType((String)member.getDatatype());
        }
        catch (Exception exception) {
            return type;
        }
    }

    public static Integer getType(Member member) {
        if (member == null || StringUtils.isEmpty((String)member.getDatatype())) {
            return 0;
        }
        Integer type = 0;
        try {
            type = Integer.valueOf(member.getDatatype());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    public static void compareValue(IOlapData olapData, IKDQueryView view, LogStats stats) {
        if (olapData == null || view == null || view.getCells().isEmpty()) {
            return;
        }
        HashMap cells = Maps.newHashMapWithExpectedSize((int)olapData.getCells().size());
        for (IKDCell cell : olapData.getCells()) {
            cells.put(MembersKey.of((String[])cell.getMeta().getNumber()), cell);
        }
        StringBuilder delData = new StringBuilder();
        ArrayList deletes = Lists.newArrayListWithCapacity((int)view.getCells().size());
        for (IKDCell oldCell : view.getCells()) {
            if (cells.containsKey(MembersKey.of((String[])oldCell.getMeta().getNumber()))) continue;
            oldCell.setValue(null);
            deletes.add(oldCell);
            delData.append(Arrays.toString(oldCell.getMeta().getNumber())).append("\r\n");
        }
        if (!deletes.isEmpty()) {
            stats.addInfo("delete-calc-null-value.");
            stats.addInfo(delData.toString());
            olapData.getCells().addAll(deletes);
        }
    }

    public static String handlerDimShortNum(String dimShortNum) {
        return "`" + dimShortNum + "`";
    }
}

