/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils;

import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.base.IKDValue;

public class PropertyUtils {
    private static boolean getPropertyValue(IKDProperties properties, String propertyKey) {
        if (properties == null || propertyKey == null) {
            return false;
        }
        IKDValue value = properties.getPropertyValue(propertyKey);
        return value != null && Boolean.parseBoolean(value.getString());
    }

    private static String getPropertyStringValue(IKDProperties properties, String propertyKey) {
        if (properties == null || propertyKey == null) {
            return null;
        }
        IKDValue value = properties.getPropertyValue(propertyKey);
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public static boolean isIgnDataset(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_DATASET");
    }

    public static boolean isCalcBizRule(IKDProperties properties) {
        boolean hasIgnCalc = PropertyUtils.getPropertyValue(properties, "IGNORE_CALC");
        return !hasIgnCalc;
    }

    public static boolean isSaveData(IKDProperties properties) {
        boolean hasIgnSave = PropertyUtils.getPropertyValue(properties, "IGNORE_SAVE");
        return !hasIgnSave;
    }

    public static boolean isIgnReadPerm(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_PERM_READ");
    }

    public static boolean isIgnWritePerm(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_PERM_SAVE");
    }

    public static boolean isIgnodeDataLock(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_DATA_LOCK");
    }

    public static boolean isIgnSaveOtherData(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_SAVE_TEXT");
    }

    public static boolean isIgnSaveTransaction(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "IGNORE_SAVE_TRANSACTION");
    }

    public static boolean hasDataByAddTo(IKDProperties properties) {
        return "ADDTO".equals(PropertyUtils.getSaveDataType(properties));
    }

    private static String getSaveDataType(IKDProperties properties) {
        return PropertyUtils.getPropertyStringValue(properties, "DATA_SAVE_TYPE");
    }

    public static boolean isSafe(IKDProperties properties) {
        return !PropertyUtils.getPropertyValue(properties, "IGNORE_SAVE_SAFE");
    }

    public static boolean isCompareValue(IKDProperties properties) {
        return !PropertyUtils.getPropertyValue(properties, "IGNORE_SAVE_COMPARE_VALUE");
    }

    public static boolean isGetAllData(IKDProperties properties) {
        return PropertyUtils.getPropertyValue(properties, "DATA_GET_ALL");
    }
}

