/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public class QueryUtils {
    public static void check(IKDCube cube, IKDOlapRequest request) {
        if (cube == null || request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (!ShrekOlapServiceHelper.isStartShrek() && request.getOlapQuery() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        boolean ignBusModel = PropertyUtils.isIgnDataset(request.getProperties());
        if (!ignBusModel) {
            if (request.getOlapQuery().getBusModelId() == null || request.getOlapQuery().getBusModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u4e1a\u52a1\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (request.getOlapQuery().getDatasetId() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u6570\u636e\u96c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_2", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
        }
        if (request.getOlapQuery().getUseDimensions() == null || request.getOlapQuery().getUseDimensions().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u7684\u7ef4\u5ea6\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        List<Dimension> dimensions = request.getOlapQuery().getUseDimensions();
        Set allDimensions = dimensions.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        String useDimStr = dimensions.stream().map(BaseCache::getNumber).collect(Collectors.joining(","));
        for (Dimension dimension : dimensions) {
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || allDimensions.contains(dimension.getNumber())) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u6709\u4e1a\u52a1\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u7684\u7ef4\u5ea6\u201c%1\u201d\u3002", (String)"KDDataQueryAgent_4", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getNumber()}));
        }
        int in = request.getOlapQuery().getQueries().size();
        for (int i = 0; i < in; ++i) {
            IKDQuery query = request.getOlapQuery().getQueries().get(i);
            if (dimensions.size() < query.getDimension().size()) {
                String reqStr = query.getDimension().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.joining(","));
                throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u8bf7\u6c42\u7684\u7ef4\u5ea6\u6570\u91cf\u201c%1\u201d\u4e0e\u4f53\u7cfb\u7ef4\u5ea6\u6570\u91cf\u201c%2\u201d\u4e0d\u4e00\u81f4\u3002", (String)"KDDataQueryAgent_5", (String)"epm-eb-olap", (Object[])new Object[]{reqStr, useDimStr}));
            }
            for (kd.epm.eb.common.model.Dimension dimension : query.getDimension()) {
                if (dimension.getMembers() != null && !dimension.getMembers().isEmpty()) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u67e5\u8be2\u8bf7\u6c42\u4e2d\u7f16\u7801\u4e3a\u201c%1\u201d\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\u3002", (String)"KDDataQueryAgent_6", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getNumber()}));
            }
        }
    }
}

