/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils.check;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.utils.check.AbstractCheck;

public class CheckCube
extends AbstractCheck {
    private static final Log log = LogFactory.getLog(CheckCube.class);

    public synchronized void checkCube(IKDCube cube, Long datasetId, Long[] versionIds) {
    }

    public void deleteCube(Long cubeId) {
        this.deleteCube(cubeId, null);
    }

    public synchronized void deleteCube(Long cubeId, Long datasetId) {
        this.checkParam(cubeId);
    }

    public void checkDeleteCube(Long cubeId) {
        this.checkDeleteCube(cubeId, null);
    }

    public void checkDeleteCube(Long cubeId, Long datasetId) {
        this.checkParam(cubeId);
        if (ShrekOlapServiceHelper.isStartShrek()) {
            Model model = ModelCacheContext.getOrCreate((Long)cubeId).getModelobj();
            ArrayList<Dataset> datasets = new ArrayList<Dataset>(16);
            if (model.isModelByEB()) {
                Dataset dataset = new Dataset(model.getId(), model.getNumber());
                datasets.add(dataset);
            } else {
                Long[] longArray;
                if (datasetId == null || datasetId == 0L) {
                    longArray = DatasetServiceHelper.queryDatasetIds((Long)cubeId);
                } else {
                    Long[] longArray2 = new Long[1];
                    longArray = longArray2;
                    longArray2[0] = datasetId;
                }
                Long[] datasetIds = longArray;
                DynamicObjectCollection datasets1 = DatasetServiceHelper.loadDatasets((Long[])datasetIds);
                if (datasets1 != null) {
                    for (DynamicObject dynamicObject : datasets1) {
                        datasets.add(Dataset.of((DynamicObject)dynamicObject));
                    }
                }
            }
            SelectCommandInfo command = new SelectCommandInfo();
            command.addDims(new String[]{SysDimensionEnum.Account.getNumber()});
            command.addMeasures(new String[]{"FMONEY"});
            command.setExcludeNull(true);
            command.setExcludeDynamicCalcResult(true);
            for (Dataset dataset : datasets) {
                if (!ShrekOlapServiceHelper.existCube((Model)model, (Dataset)dataset)) continue;
                ShrekOlapReader reader = ShrekOlapServiceHelper.queryReaderByExcludeDynamicCalc((Model)model, (Dataset)dataset, (SelectCommandInfo)command, null);
                Throwable throwable = null;
                try {
                    while (reader.hasNext()) {
                        Object[] values = reader.next();
                        if (values == null || values[0] == null) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e8b\u5b9e\u8868\u4e2d\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u4f53\u7cfb\u3002", (String)"CheckCube_1", (String)"epm-eb-olap", (Object[])new Object[0]));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }
}

