/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils.check;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.utils.check.AbstractCheck;

public class CheckMember
extends AbstractCheck {
    private static final Log log = LogFactory.getLog(CheckMember.class);

    public void checkMember(IKDCube cube, Long dimensionId, Long viewId, Long[] memberIds) {
        this.checkParam(cube);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin checkMember.");
        stats.addInfo("end checkDimension.");
        log.info(stats.toString());
    }

    public void deleteMember(IKDCube cube, Long dimensionId, Long viewId, Long[] memberIds) {
    }

    public void checkDeleteMember(IKDCube cube, Long dimensionId, Long[] memberIds) {
        this.checkDeleteMemberByShrek(cube, dimensionId, memberIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeleteMemberByShrek(IKDCube cube, Long dimensionId, Long[] memberIds) {
        this.checkParam(cube);
        this.checkParamByDimension(dimensionId);
        this.checkParamByMember(memberIds);
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin-check-delete-member.");
        LinkedHashSet<String> checkMembers = new LinkedHashSet<String>();
        HashSet datasetIds = Sets.newHashSetWithExpectedSize((int)32);
        Long cubeId = Long.valueOf(cube.getId());
        IModelCacheHelper modelCache = cube.getModelCache();
        Dimension dimension = modelCache.getDimension(dimensionId);
        if (dimension != null) {
            LinkedList members = new LinkedList();
            Member member = null;
            for (Long memberId : memberIds) {
                member = modelCache.getMemberByAnyView(dimension.getNumber(), memberId);
                if (member == null) continue;
                members.addAll(member.getAllMembers());
            }
            for (Member _member : members) {
                checkMembers.add(_member.getNumber());
            }
            boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber());
            if (hasAccount) {
                for (Member _member : members) {
                    datasetIds.add(_member.getDatasetId());
                }
            }
        }
        if (checkMembers.isEmpty()) {
            return;
        }
        try {
            List _datasetIds;
            if (datasetIds.isEmpty() && (_datasetIds = DatasetServiceHelper.queryDatasetIds((Long)cubeId, (Long)dimensionId)) != null) {
                datasetIds.addAll(_datasetIds);
            }
            for (Long datasetId : datasetIds) {
                SelectCommandInfo command = new SelectCommandInfo();
                command.addDims(new String[]{dimension.getNumber()});
                command.addMeasures(new String[]{"FMONEY"});
                Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
                Set allMembers = ShrekOlapServiceHelper.getAllMembers((Model)modelCache.getModelobj(), (Dataset)dataset, (String)dimension.getNumber());
                checkMembers.retainAll(allMembers);
                if (checkMembers.isEmpty()) {
                    return;
                }
                command.addFilter(dimension.getNumber(), checkMembers.toArray(new String[0]));
                ShrekOlapReader reader = ShrekOlapServiceHelper.queryReaderByExcludeDynamicCalc((Model)modelCache.getModelobj(), (Dataset)dataset, (SelectCommandInfo)command, (LogStats)stats);
                Throwable throwable = null;
                try {
                    while (reader.hasNext()) {
                        Object[] values = reader.next();
                        if (values == null || values[0] == null) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8981\u5220\u9664\u7684\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"CheckMember_0", (String)"epm-eb-olap", (Object[])new Object[0]));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        finally {
            stats.add("end-check-delete-member.");
            log.info(stats.toString());
        }
    }
}

