/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils.check;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;
import kd.epm.eb.olap.impl.utils.check.CheckDimension;

public class CheckView
extends CheckDimension {
    @Override
    public void check(IKDCube cube, Long dimensionId, Long viewId) {
        this.checkParam(cube);
        this.checkParamByDimension(dimensionId);
        this.checkParamByView(viewId);
        super.check(cube, dimensionId, viewId);
    }

    @Override
    public void checkDelete(IKDCube cube, Long dimensionId, Long viewId) {
        this.checkParam(cube);
        this.checkParamByDimension(dimensionId);
        this.checkParamByView(viewId);
    }

    @Override
    public void delete(IKDCube cube, Long dimensionId, Long viewId) {
        String closureTable;
        this.checkParam(cube);
        this.checkParamByDimension(dimensionId);
        this.checkParamByView(viewId);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin deleteView");
        Long cubeId = Long.valueOf(cube.getId());
        Dimension dimension = cube.getModelCache().getDimension(dimensionId);
        String dimTable = OlapTableUtils.getDimFactTable(cubeId, dimension, viewId);
        if (SqlBatchUtils.hasTable((String)dimTable)) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("drop table " + dimTable));
            stats.addInfo("delete dimTable = " + dimTable);
        }
        if (SqlBatchUtils.hasTable((String)(closureTable = OlapTableUtils.getDimClosureTable(cubeId, dimension, viewId)))) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("drop table " + closureTable));
            stats.addInfo("delete closureTable = " + closureTable);
        }
        stats.addInfo("end deleteView");
        log.info(stats.toString());
    }
}

