/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils.check.task;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.metadata.IKDCube;

public abstract class AbstractTask
implements Runnable {
    protected static final Log log = LogFactory.getLog(AbstractTask.class);
    private IKDCube cube;
    private List<Map<String, Object>> dimensions;
    private RequestContext context;
    private CountDownLatch cdl;
    private LogStats stats = null;

    protected IKDCube getCube() {
        return this.cube;
    }

    protected List<Map<String, Object>> getDimensions() {
        return this.dimensions;
    }

    public void setContext(RequestContext context) {
        this.context = context;
    }

    public RequestContext getContext() {
        return this.context;
    }

    public void setCdl(CountDownLatch cdl) {
        this.cdl = cdl;
    }

    public CountDownLatch getCdl() {
        return this.cdl;
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public AbstractTask() {
    }

    public AbstractTask(IKDCube cube, List<Map<String, Object>> dimensions, LogStats stats) {
        this();
        this.cube = cube;
        this.dimensions = dimensions;
        this.stats = stats;
    }

    @Override
    public void run() {
        try {
            if (this.verify()) {
                this.process();
            }
        }
        catch (Throwable ex) {
            log.error("budget-data-log : ", ex);
            throw ex;
        }
        finally {
            if (this.getCdl() != null) {
                this.getCdl().countDown();
            }
            this.close();
        }
    }

    protected boolean verify() {
        boolean re = true;
        if (this.cube == null || this.cube.getId() == null) {
            re = false;
            log.warn("budget-olap-log : cubeId is null or 0.");
        }
        if (this.dimensions == null || this.dimensions.isEmpty()) {
            re = false;
            log.warn("budget-olap-log : dimensions is null.");
        }
        if (this.stats == null) {
            throw new NullPointerException("AbstractTask run error. stats is null.");
        }
        return re;
    }

    protected abstract void process();

    public void close() {
        this.cube = null;
        this.dimensions = null;
        this.cdl = null;
    }
}

